/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.jetbrains.annotations.Nullable;

public abstract class SqlAbstractLocalSystemView
extends SqlAbstractSystemView {
    protected SqlAbstractLocalSystemView(String tblName, String desc, GridKernalContext ctx, String[] indexes, Column ... cols) {
        super(tblName, desc, ctx, cols, indexes);
        assert (tblName != null);
        assert (cols != null);
    }

    protected SqlAbstractLocalSystemView(String tblName, String desc, GridKernalContext ctx, String indexedCols, Column ... cols) {
        this(tblName, desc, ctx, new String[]{indexedCols}, cols);
    }

    public SqlAbstractLocalSystemView(String tblName, String desc, GridKernalContext ctx, Column ... cols) {
        this(tblName, desc, ctx, new String[0], cols);
    }

    protected Row createRow(Session ses, Object ... data) {
        Value[] values = new Value[data.length];
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            ValueNull v = o == null ? ValueNull.INSTANCE : (o instanceof Value ? (Value)o : ValueString.get(o.toString()));
            values[i] = this.cols[i].convert(v);
        }
        return ses.getDatabase().createRow(values, 0);
    }

    protected int getColumnIndex(String colName) {
        assert (colName != null);
        for (int i = 0; i < this.cols.length; ++i) {
            if (!colName.equalsIgnoreCase(this.cols[i].getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    protected SqlSystemViewColumnCondition conditionForColumn(String colName, SearchRow first, SearchRow last) {
        return SqlSystemViewColumnCondition.forColumn(this.getColumnIndex(colName), first, last);
    }

    protected static UUID uuidFromValue(Value val) {
        try {
            return UUID.fromString(val.getString());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected static Value valueTimestampFromMillis(long millis) {
        if (millis <= 0L || millis == Long.MAX_VALUE) {
            return ValueNull.INSTANCE;
        }
        return ValueTimestamp.fromMillis(millis);
    }

    @Nullable
    protected static String nodeFilter(CacheConfiguration<?, ?> ccfg) {
        IgnitePredicate<ClusterNode> nodeFilter = ccfg.getNodeFilter();
        if (nodeFilter instanceof CacheConfiguration.IgniteAllNodesPredicate) {
            nodeFilter = null;
        }
        return SqlAbstractLocalSystemView.toStringSafe(nodeFilter);
    }

    @Nullable
    protected static String toStringSafe(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj.toString();
        }
        catch (Exception e) {
            try {
                return "Failed to convert object to string: " + e.getMessage();
            }
            catch (Exception e0) {
                return "Failed to convert object to string (error message is not available)";
            }
        }
    }
}

