/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterQueryModelType;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.internal.h2.command.dml.SelectUnion;

public final class SplitterQueryModel {
    @GridToStringInclude
    private final SplitterQueryModelType type;
    private final GridSqlAlias uniqueAlias;
    private final GridSqlAst parent;
    private final int childIdx;
    private final List<SplitterQueryModel> childModels = new ArrayList<SplitterQueryModel>();
    @GridToStringInclude
    private boolean needSplit;
    @GridToStringInclude
    private boolean needSplitChild;
    private boolean unionAll = true;

    public SplitterQueryModel(SplitterQueryModelType type, GridSqlAst parent, int childIdx, GridSqlAlias uniqueAlias) {
        this(type, parent, childIdx, uniqueAlias, false);
    }

    public SplitterQueryModel(SplitterQueryModelType type, GridSqlAst parent, int childIdx, GridSqlAlias uniqueAlias, boolean needSplit) {
        this.type = type;
        this.parent = parent;
        this.childIdx = childIdx;
        this.uniqueAlias = uniqueAlias;
        this.needSplit = needSplit;
    }

    public SplitterQueryModelType type() {
        return this.type;
    }

    public boolean isQuery() {
        return this.type == SplitterQueryModelType.SELECT || this.type == SplitterQueryModelType.UNION;
    }

    public GridSqlAlias uniqueAlias() {
        return this.uniqueAlias;
    }

    public GridSqlAst parent() {
        return this.parent;
    }

    public int childIndex() {
        return this.childIdx;
    }

    public <X extends GridSqlAst> X ast() {
        return (X)this.parent.child(this.childIdx);
    }

    public boolean needSplit() {
        return this.needSplit;
    }

    public boolean needSplitChild() {
        return this.needSplitChild;
    }

    public void moveChildModelsToWrapModel(SplitterQueryModel wrapModel, int begin, int end) {
        int x;
        for (int i = begin; i <= end; ++i) {
            SplitterQueryModel child = this.childModels.get(i);
            wrapModel.childModels.add(child);
        }
        this.childModels.set(begin, wrapModel);
        for (int i = x = begin + 1; i <= end; ++i) {
            this.childModels.remove(x);
        }
    }

    public void forceSplit() {
        if (this.type == SplitterQueryModelType.SELECT) {
            assert (!this.needSplitChild);
            this.needSplit = true;
        } else if (this.type == SplitterQueryModelType.UNION) {
            this.needSplitChild = true;
            for (SplitterQueryModel childModel : this.childModels) {
                assert (childModel.type() == SplitterQueryModelType.SELECT) : childModel.type();
                childModel.needSplit = true;
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)this.type));
        }
    }

    public void unionAll(boolean unionAll) {
        this.unionAll = unionAll;
    }

    public int childModelsCount() {
        return this.childModels.size();
    }

    public SplitterQueryModel childModel(int idx) {
        return this.childModels.get(idx);
    }

    public void buildQueryModel(GridSqlAst prnt, int childIdx, GridSqlAlias uniqueAlias) {
        Object child = prnt.child(childIdx);
        assert (child != null);
        if (child instanceof GridSqlSelect) {
            SplitterQueryModel model = new SplitterQueryModel(SplitterQueryModelType.SELECT, prnt, childIdx, uniqueAlias);
            this.childModels.add(model);
            model.buildQueryModel((GridSqlAst)child, 2, null);
        } else if (child instanceof GridSqlUnion) {
            SplitterQueryModel model;
            if (this.type == SplitterQueryModelType.UNION) {
                model = this;
            } else {
                model = new SplitterQueryModel(SplitterQueryModelType.UNION, prnt, childIdx, uniqueAlias);
                this.childModels.add(model);
            }
            if (((GridSqlUnion)child).unionType() != SelectUnion.UnionType.UNION_ALL) {
                model.unionAll(false);
            }
            model.buildQueryModel((GridSqlAst)child, 2, null);
            model.buildQueryModel((GridSqlAst)child, 3, null);
        } else {
            assert (this.type == SplitterQueryModelType.SELECT) : this.type;
            if (child instanceof GridSqlAlias) {
                this.buildQueryModel((GridSqlAst)child, 0, (GridSqlAlias)child);
            } else if (child instanceof GridSqlJoin) {
                this.buildQueryModel((GridSqlAst)child, 0, uniqueAlias);
                this.buildQueryModel((GridSqlAst)child, 1, uniqueAlias);
            } else {
                assert (prnt == uniqueAlias) : prnt.getClass();
                if (child instanceof GridSqlTable) {
                    this.childModels.add(new SplitterQueryModel(SplitterQueryModelType.TABLE, prnt, childIdx, uniqueAlias));
                } else if (child instanceof GridSqlSubquery) {
                    this.buildQueryModel((GridSqlAst)child, 0, uniqueAlias);
                } else if (child instanceof GridSqlFunction) {
                    this.childModels.add(new SplitterQueryModel(SplitterQueryModelType.FUNCTION, prnt, childIdx, uniqueAlias));
                } else {
                    throw new IllegalStateException("Unknown child type: " + child.getClass());
                }
            }
        }
    }

    public void analyzeQueryModel(boolean collocatedGrpBy) {
        SplitterQueryModel child;
        int i;
        if (!this.isQuery()) {
            return;
        }
        for (i = 0; i < this.childModels.size(); ++i) {
            child = this.childModels.get(i);
            child.analyzeQueryModel(collocatedGrpBy);
            if (!child.needSplit && !child.needSplitChild) continue;
            this.needSplitChild = true;
        }
        if (this.type == SplitterQueryModelType.SELECT) {
            if (!this.needSplitChild) {
                this.needSplit = SplitterQueryModel.needSplitSelect((GridSqlSelect)this.ast(), collocatedGrpBy);
            }
        } else if (this.type == SplitterQueryModelType.UNION) {
            if (!(this.needSplitChild || this.unionAll && !((GridSqlUnion)this.ast()).hasOffsetLimit())) {
                this.needSplitChild = true;
            }
            if (this.needSplitChild) {
                for (i = 0; i < this.childModels.size(); ++i) {
                    child = this.childModels.get(i);
                    assert (child.type() == SplitterQueryModelType.SELECT) : child.type();
                    if (child.needSplitChild || child.needSplit) continue;
                    child.needSplit = true;
                }
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)this.type));
        }
    }

    public GridSqlJoin findJoin(int idx) {
        assert (this.type == SplitterQueryModelType.SELECT) : this.type;
        assert (this.childModels.size() > 1);
        assert (idx < this.childModels.size()) : idx;
        if (idx == 0) {
            idx = 1;
        }
        GridSqlJoin join = (GridSqlJoin)((GridSqlSelect)this.ast()).from();
        for (int i = this.childModels.size() - 1; i > idx; --i) {
            join = (GridSqlJoin)join.leftTable();
        }
        return join;
    }

    private static boolean needSplitSelect(GridSqlSelect select, boolean collocatedGrpBy) {
        if (select.distinct()) {
            return true;
        }
        if (select.hasOffsetLimit()) {
            return true;
        }
        if (collocatedGrpBy) {
            return false;
        }
        if (select.groupColumns() != null) {
            return true;
        }
        for (int i = 0; i < select.allColumns(); ++i) {
            if (!SplitterUtils.hasAggregates(select.column(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return S.toString(SplitterQueryModel.class, this);
    }
}

