/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.gridgain.internal.h2.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GridSqlJoin
extends GridSqlElement {
    public static final int LEFT_TABLE_CHILD = 0;
    public static final int RIGHT_TABLE_CHILD = 1;
    public static final int ON_CHILD = 2;
    private boolean leftOuter;

    public GridSqlJoin(GridSqlElement leftTbl, GridSqlElement rightTbl, boolean leftOuter, @Nullable GridSqlElement on) {
        super(new ArrayList<GridSqlAst>(3));
        this.addChild(leftTbl);
        this.addChild(rightTbl);
        if (on == null) {
            on = GridSqlConst.TRUE;
        }
        this.addChild(on);
        this.leftOuter = leftOuter;
    }

    public GridSqlElement leftTable() {
        return (GridSqlElement)this.child(0);
    }

    public void leftTable(GridSqlElement tbl) {
        this.child(0, tbl);
    }

    public GridSqlElement rightTable() {
        return (GridSqlElement)this.child(1);
    }

    public void rightTable(GridSqlElement tbl) {
        this.child(1, tbl);
    }

    public GridSqlElement on() {
        return (GridSqlElement)this.child(2);
    }

    public boolean isLeftOuter() {
        return this.leftOuter;
    }

    @Override
    public String getSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.leftTable().getSQL());
        buff.append(this.leftOuter ? " \n LEFT OUTER JOIN " : " \n INNER JOIN ");
        buff.append(this.rightTable().getSQL());
        buff.append(" \n ON ").append(StringUtils.unEnclose(this.on().getSQL()));
        return buff.toString();
    }
}

