/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class GridH2ValueCacheObject
extends Value {
    private CacheObject obj;
    private CacheObjectValueContext valCtx;
    private boolean useLegacyComparator;

    public GridH2ValueCacheObject(CacheObject obj, CacheObjectValueContext valCtx) {
        assert (obj != null);
        if (obj instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)obj).detachAllowed(true);
            obj = ((BinaryObjectImpl)obj).detach();
        }
        this.obj = obj;
        this.valCtx = valCtx;
    }

    public CacheObject getCacheObject() {
        return this.obj;
    }

    public CacheObjectValueContext valueContext() {
        return this.valCtx;
    }

    @Override
    public String getSQL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuilder getSQL(StringBuilder sb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_JAVA_OBJECT;
    }

    @Override
    public int getValueType() {
        return 19;
    }

    @Override
    public String getString() {
        Object obj0 = this.getObject();
        if (obj0 instanceof BinaryObjectEx) {
            String str = ((BinaryObjectEx)obj0).getString();
            return str == null ? obj0.toString() : str;
        }
        return obj0.toString();
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.obj.cacheObjectType() == 1) {
            try {
                return this.obj.valueBytes(this.valCtx);
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert(e);
            }
        }
        return JdbcUtils.serialize(this.obj, H2Utils.getHandler(this.valCtx.kernalContext()));
    }

    @Override
    public Object getObject() {
        return this.getObject(false);
    }

    public Object getObject(boolean cpy) {
        return this.obj.isPlatformType() ? this.obj.value(this.valCtx, cpy) : this.obj;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setObject(parameterIndex, this.getObject(), 2000);
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        int h2;
        Object o1 = this.getObject();
        Object o2 = v.getObject();
        boolean o1Comparable = o1 instanceof Comparable;
        boolean o2Comparable = o2 instanceof Comparable;
        if (o1Comparable && o2Comparable && Utils.haveCommonComparableSuperclass(o1.getClass(), o2.getClass())) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
        if (o1.getClass() != o2.getClass()) {
            if (o1Comparable != o2Comparable) {
                return o1Comparable ? -1 : 1;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
        int h1 = this.hashCode();
        if (h1 == (h2 = v.hashCode())) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (!this.legacyComparator() && o1 instanceof BinaryObjectImpl) {
                return BinaryObjectImpl.compare(o1, o2);
            }
            return Bits.compareNotNullSigned(this.getBytesNoCopy(), v.getBytesNoCopy());
        }
        return h1 > h2 ? 1 : -1;
    }

    public void useLegacyComparator() {
        this.useLegacyComparator = true;
    }

    public boolean legacyComparator() {
        return this.useLegacyComparator;
    }

    @Override
    public int hashCode() {
        return this.getObject().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Value)) {
            return false;
        }
        Value otherVal = (Value)other;
        return otherVal.getType().getValueType() == 19 && this.getObject().equals(otherVal.getObject());
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        return this;
    }

    @Override
    public int getMemory() {
        return 0;
    }
}

