/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.List;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2IndexCostedBase;
import org.apache.ignite.internal.processors.query.h2.opt.join.ProxyDistributedLookupBatch;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexLookupBatch;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.SpatialIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;

public class GridH2ProxyIndex
extends H2IndexCostedBase {
    protected Index idx;

    public GridH2ProxyIndex(GridH2Table tbl, String name, List<IndexColumn> colsList, Index idx) {
        super(tbl, name, GridH2IndexBase.columnsArray(tbl, colsList), IndexType.createNonUnique(false, false, idx instanceof SpatialIndex));
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns(cols, tbl);
        this.idx = idx;
    }

    public Index underlyingIndex() {
        return this.idx;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("add");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("remove row");
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        GridH2RowDescriptor desc = ((GridH2Table)this.idx.getTable()).rowDescriptor();
        return this.idx.find(session, desc.prepareProxyIndexRow(first), desc.prepareProxyIndexRow(last));
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        long rowCnt = this.getRowCountApproximation(ses);
        double baseCost = this.costRangeIndex(ses, masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = ((GridH2IndexBase)this.idx).getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("remove index");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return this.idx.canGetFirstOrLast();
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        return this.idx.findFirstOrLast(session, first);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return this.idx.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.idx.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        IndexLookupBatch batch = this.idx.createLookupBatch(filters, filter);
        if (batch == null) {
            return null;
        }
        GridH2RowDescriptor rowDesc = ((GridH2Table)this.idx.getTable()).rowDescriptor();
        return new ProxyDistributedLookupBatch(batch, rowDesc);
    }

    @Override
    public void removeChildrenAndResources(Session session) {
    }
}

