/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArgument;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArguments;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public final class FastUpdate {
    private final DmlArgument keyArg;
    private final DmlArgument valArg;
    private final DmlArgument newValArg;

    public static FastUpdate create(GridSqlElement key, GridSqlElement val, @Nullable GridSqlElement newVal) {
        DmlArgument keyArg = DmlArguments.create(key);
        DmlArgument valArg = DmlArguments.create(val);
        DmlArgument newValArg = DmlArguments.create(newVal);
        return new FastUpdate(keyArg, valArg, newValArg);
    }

    private FastUpdate(DmlArgument keyArg, DmlArgument valArg, DmlArgument newValArg) {
        this.keyArg = keyArg;
        this.valArg = valArg;
        this.newValArg = newValArg;
    }

    public UpdateResult execute(GridCacheAdapter cache, Object[] args) throws IgniteCheckedException {
        Object key = this.keyArg.get(args);
        assert (key != null);
        Object val = this.valArg.get(args);
        Object newVal = this.newValArg.get(args);
        boolean res = newVal != null ? (val != null ? cache.replace(key, val, newVal) : cache.replace(key, newVal)) : (val != null ? cache.remove(key, val) : cache.remove(key));
        return res ? UpdateResult.ONE : UpdateResult.ZERO;
    }

    public IgniteBiTuple getRow(Object[] args) throws IgniteCheckedException {
        Object key = this.keyArg.get(args);
        assert (key != null);
        Object newVal = this.newValArg.get(args);
        return new IgniteBiTuple<Object, Object>(key, newVal);
    }
}

