/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.disk.AbstractExternalResult;
import org.apache.ignite.internal.processors.query.h2.disk.ExternalResultData;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.ResultExternal;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

public class SortedExternalResult
extends AbstractExternalResult<Value>
implements ResultExternal {
    private final boolean distinct;
    private final int[] distinctIndexes;
    private final int visibleColCnt;
    private final SortOrder sort;
    private TreeMap<ValueRow, Value[]> sortedRowsBuf;
    private ArrayList<Value[]> unsortedRowsBuf;
    private Queue<ExternalResultData.Chunk> resQueue;
    private Comparator<Value> cmp;
    private final Comparator<ExternalResultData.Chunk> chunkCmp;

    public SortedExternalResult(Session ses, boolean distinct, int[] distinctIndexes, int visibleColCnt, final SortOrder sort, long initSize) {
        super(ses, SortedExternalResult.isDistinct(distinct, distinctIndexes), initSize, Value.class);
        this.distinct = SortedExternalResult.isDistinct(distinct, distinctIndexes);
        this.distinctIndexes = distinctIndexes;
        this.visibleColCnt = visibleColCnt;
        this.sort = sort;
        this.cmp = ses.getDatabase().getCompareMode();
        this.chunkCmp = new Comparator<ExternalResultData.Chunk>(){

            @Override
            public int compare(ExternalResultData.Chunk o1, ExternalResultData.Chunk o2) {
                int c = sort.compare((Value[])o1.currentRow().getValue(), (Value[])o2.currentRow().getValue());
                if (c != 0) {
                    return c;
                }
                return Long.compare(o1.start(), o2.start());
            }
        };
    }

    private SortedExternalResult(SortedExternalResult parent) {
        super(parent);
        this.distinct = parent.distinct;
        this.distinctIndexes = parent.distinctIndexes;
        this.visibleColCnt = parent.visibleColCnt;
        this.sort = parent.sort;
        this.cmp = parent.cmp;
        this.chunkCmp = parent.chunkCmp;
    }

    @Override
    public Value[] next() {
        ExternalResultData.Chunk batch = this.resQueue.poll();
        if (batch == null) {
            throw new NoSuchElementException();
        }
        Value[] row = (Value[])batch.currentRow().getValue();
        if (batch.next()) {
            this.resQueue.offer(batch);
        }
        return row;
    }

    @Override
    public int addRows(Collection<Value[]> rows) {
        for (Value[] row : rows) {
            if (this.distinct && this.containsRowWithOrderCheck(row)) continue;
            this.addRowToBuffer(row);
            ++this.size;
        }
        if (this.needToSpill()) {
            this.spillRowsBufferToDisk();
        }
        return this.size;
    }

    @Override
    public int addRow(Value[] row) {
        if (this.distinct && this.containsRowWithOrderCheck(row)) {
            return this.size;
        }
        this.addRowToBuffer(row);
        if (this.needToSpill()) {
            this.spillRowsBufferToDisk();
        }
        return ++this.size;
    }

    private boolean containsRowWithOrderCheck(Value[] row) {
        Value[] previous;
        assert (this.unsortedRowsBuf == null);
        ValueRow distKey = this.getRowKey(row);
        Value[] valueArray = previous = this.sortedRowsBuf == null ? null : this.sortedRowsBuf.get(distKey);
        if (previous != null) {
            if (this.sort != null && this.sort.compare(previous, row) > 0) {
                this.sortedRowsBuf.remove(distKey);
                --this.size;
                return false;
            }
            return true;
        }
        Map.Entry<ValueRow, T[]> prevRow = this.data.get(distKey);
        Value[] valueArray2 = previous = prevRow == null ? null : (Value[])prevRow.getValue();
        if (previous == null) {
            return false;
        }
        if (this.sort != null && this.sort.compare(previous, row) > 0) {
            this.data.remove(distKey);
            --this.size;
            return false;
        }
        return true;
    }

    private static boolean isDistinct(boolean distinct, int[] distinctIndexes) {
        return distinct || distinctIndexes != null;
    }

    @Override
    public boolean contains(Value[] values) {
        ValueRow key = this.getRowKey(values);
        if (!F.isEmpty(this.sortedRowsBuf) && this.sortedRowsBuf.containsKey(key)) {
            return true;
        }
        return this.data.contains(key);
    }

    @Override
    public int removeRow(Value[] values) {
        Value[] prev;
        ValueRow key = this.getRowKey(values);
        if (this.sortedRowsBuf != null && (prev = this.sortedRowsBuf.remove(key)) != null) {
            return --this.size;
        }
        if (this.data.remove(key)) {
            --this.size;
        }
        return this.size;
    }

    private void addRowToBuffer(Value[] row) {
        if (this.distinct) {
            assert (this.unsortedRowsBuf == null);
            if (this.sortedRowsBuf == null) {
                this.sortedRowsBuf = new TreeMap(this.cmp);
            }
            ValueRow key = this.getRowKey(row);
            Object[] old = this.sortedRowsBuf.put(key, row);
            long delta = H2Utils.calculateMemoryDelta(key, old, row);
            this.memTracker.reserve(delta);
        } else {
            assert (this.sortedRowsBuf == null);
            if (this.unsortedRowsBuf == null) {
                this.unsortedRowsBuf = new ArrayList();
            }
            this.unsortedRowsBuf.add(row);
            long delta = H2Utils.calculateMemoryDelta(null, null, row);
            this.memTracker.reserve(delta);
        }
    }

    private void spillRowsBufferToDisk() {
        if (F.isEmpty(this.sortedRowsBuf) && F.isEmpty(this.unsortedRowsBuf)) {
            return;
        }
        int size = this.distinct ? this.sortedRowsBuf.size() : this.unsortedRowsBuf.size();
        ArrayList<Map.Entry<ValueRow, T[]>> rows = new ArrayList<Map.Entry<ValueRow, T[]>>(size);
        if (this.distinct) {
            for (Map.Entry entry : this.sortedRowsBuf.entrySet()) {
                rows.add(new IgniteBiTuple(entry.getKey(), entry.getValue()));
            }
        } else {
            for (Value[] valueArray : this.unsortedRowsBuf) {
                rows.add(new IgniteBiTuple<Object, Value[]>(null, valueArray));
            }
        }
        this.sortedRowsBuf = null;
        this.unsortedRowsBuf = null;
        if (this.sort != null) {
            rows.sort((o1, o2) -> this.sort.compare((Value[])o1.getValue(), (Value[])o2.getValue()));
        }
        this.data.store(rows);
        long delta = 0L;
        for (Map.Entry entry : rows) {
            delta += H2Utils.calculateMemoryDelta((ValueRow)entry.getKey(), (Object[])entry.getValue(), null);
        }
        this.memTracker.release(-delta);
    }

    @Override
    public void reset() {
        this.spillRowsBufferToDisk();
        if (this.resQueue != null) {
            this.resQueue.clear();
            for (ExternalResultData.Chunk chunk : this.data.chunks()) {
                chunk.reset();
            }
        } else {
            this.resQueue = this.sort == null ? new ArrayDeque() : new PriorityQueue<ExternalResultData.Chunk>(this.chunkCmp);
        }
        for (ExternalResultData.Chunk chunk : this.data.chunks()) {
            if (!chunk.next()) continue;
            this.resQueue.offer(chunk);
        }
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        this.onChildCreated();
        return new SortedExternalResult(this);
    }

    private ValueRow getRowKey(Value[] row) {
        if (this.distinctIndexes != null) {
            int cnt = this.distinctIndexes.length;
            Value[] newValues = new Value[cnt];
            for (int i = 0; i < cnt; ++i) {
                newValues[i] = row[this.distinctIndexes[i]];
            }
            row = newValues;
        } else if (row.length > this.visibleColCnt) {
            row = Arrays.copyOf(row, this.visibleColCnt);
        }
        return ValueRow.get(row);
    }
}

