/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.disk.ExternalResultData;
import org.apache.ignite.internal.processors.query.h2.disk.TrackableFileIoFactory;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.ValueRow;

public class ExternalResultHashIndex
implements AutoCloseable {
    private static final double LOAD_FACTOR = 0.5;
    private static final long MIN_CAPACITY = 256L;
    private static final long MAX_CAPACITY = 0x400000000000000L;
    private static final long REMOVED_FLAG = Long.MIN_VALUE;
    private final TrackableFileIoFactory fileIOFactory;
    private final String dir;
    private final String spillFileName;
    private int id;
    private File idxFile;
    private FileIO fileIo;
    private final ExternalResultData rowStore;
    private final ByteBuffer reusableBuff = ByteBuffer.allocate(12);
    private final H2MemoryTracker memTracker;
    private long cap;
    private long entriesCnt;
    private boolean closed;

    ExternalResultHashIndex(TrackableFileIoFactory fileIOFactory, File spillFile, ExternalResultData rowStore, long initSize, H2MemoryTracker tracker) {
        this.fileIOFactory = fileIOFactory;
        this.dir = spillFile.getParent();
        this.spillFileName = spillFile.getName();
        this.rowStore = rowStore;
        this.memTracker = tracker;
        if (initSize <= 256L) {
            initSize = 256L;
        }
        long initCap = Long.highestOneBit(initSize) * 4L;
        this.initNewIndexFile(initCap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalResultHashIndex(ExternalResultHashIndex parent) {
        try {
            this.fileIOFactory = parent.fileIOFactory;
            this.idxFile = parent.idxFile;
            ExternalResultHashIndex externalResultHashIndex = this;
            synchronized (externalResultHashIndex) {
                this.checkCancelled();
                this.fileIo = this.fileIOFactory.create(this.idxFile, parent.memTracker, StandardOpenOption.READ);
            }
            this.rowStore = parent.rowStore;
            this.cap = parent.cap;
            this.entriesCnt = parent.entriesCnt;
            this.dir = parent.dir;
            this.spillFileName = parent.spillFileName;
            this.memTracker = parent.memTracker;
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create new hash index.", e);
        }
    }

    public void put(ValueRow key, long rowAddr) {
        assert (key != null);
        this.ensureCapacity();
        int hashCode = key.hashCode();
        this.putEntryToFreeSlot(hashCode, rowAddr);
    }

    public long get(ValueRow key) {
        Entry entry = this.findEntry(key);
        return entry == null ? -1L : entry.rowAddress();
    }

    public boolean contains(ValueRow key) {
        Entry entry = this.findEntry(key);
        return entry != null;
    }

    public long remove(ValueRow key) {
        Entry entry = this.findEntry(key);
        if (entry == null) {
            return -1L;
        }
        this.writeEntryToIndexFile(entry.slot(), key.hashCode(), entry.rowAddress() | Long.MIN_VALUE);
        --this.entriesCnt;
        return entry.rowAddress();
    }

    private void putEntryToFreeSlot(int hashCode, long rowAddr) {
        long slot = this.findFreeSlotForInsert(hashCode);
        this.writeEntryToIndexFile(slot, hashCode, rowAddr);
        ++this.entriesCnt;
    }

    private long findFreeSlotForInsert(int hashCode) {
        Entry entry;
        long slot;
        long startSlot = slot = this.slot(hashCode);
        while ((entry = this.readEntryFromIndexFile(slot)) != null && !entry.isRemoved() && !entry.isEmpty()) {
            slot = (slot + 1L) % this.cap;
            assert (slot != startSlot);
        }
        return slot;
    }

    private long slot(long hashCode) {
        long hc64 = hashCode << 48 ^ hashCode << 32 ^ hashCode << 16 ^ hashCode;
        return hc64 & this.cap - 1L;
    }

    private Entry findEntry(ValueRow key) {
        long slot;
        int hashCode = key.hashCode();
        long initialSlot = slot = this.slot(hashCode);
        Entry entry = this.readEntryFromIndexFile(slot);
        while (!entry.isEmpty()) {
            if (!entry.isRemoved() && hashCode == entry.hashCode()) {
                Map.Entry<ValueRow, T[]> row = this.rowStore.readRowFromFile(entry.rowAddress());
                assert (row != null) : "row=" + row;
                ValueRow keyFromDisk = row.getKey();
                if (key.equals(keyFromDisk)) break;
            }
            if ((slot = (slot + 1L) % this.cap) == initialSlot) {
                return null;
            }
            entry = this.readEntryFromIndexFile(slot);
        }
        return entry.isEmpty() || entry.isRemoved() ? null : entry;
    }

    private Entry readEntryFromIndexFile(long slot) {
        return this.readEntryFromIndexFile(slot, this.fileIo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry readEntryFromIndexFile(long slot, FileIO fileCh) {
        try {
            if (slot != -1L) {
                this.gotoSlot(slot);
            } else {
                slot = fileCh.position() / 12L;
            }
            this.reusableBuff.clear();
            ExternalResultHashIndex externalResultHashIndex = this;
            synchronized (externalResultHashIndex) {
                this.checkCancelled();
                fileCh.readFully(this.reusableBuff);
            }
            this.reusableBuff.flip();
            int hashCode = this.reusableBuff.getInt();
            long addr = this.reusableBuff.getLong() - 1L;
            return new Entry(hashCode, addr, slot);
        }
        catch (IOException e) {
            U.closeQuiet(this);
            throw new IgniteException("Failed to read query result the from spill idx file. [slot=" + slot + ']', e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntryToIndexFile(long slot, int hashCode, long addr) {
        try {
            this.gotoSlot(slot);
            this.reusableBuff.clear();
            this.reusableBuff.putInt(hashCode);
            this.reusableBuff.putLong(addr + 1L);
            this.reusableBuff.flip();
            ExternalResultHashIndex externalResultHashIndex = this;
            synchronized (externalResultHashIndex) {
                this.checkCancelled();
                this.fileIo.writeFully(this.reusableBuff);
            }
        }
        catch (IOException e) {
            U.closeQuiet(this);
            throw new IgniteException("Failed to write intermediate query result to the spill file.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoSlot(long slot) {
        try {
            ExternalResultHashIndex externalResultHashIndex = this;
            synchronized (externalResultHashIndex) {
                this.checkCancelled();
                this.fileIo.position(slot * 12L);
            }
        }
        catch (Exception e) {
            U.closeQuiet(this);
            throw new IgniteException("Failed to reset the index spill file, slot=" + slot, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity() {
        if ((double)this.entriesCnt <= 0.5 * (double)this.cap) {
            return;
        }
        FileIO oldFileIo = this.fileIo;
        File oldIdxFile = this.idxFile;
        long oldSize = this.cap;
        try {
            this.initNewIndexFile(oldSize * 2L);
            this.copyDataFromOldFile(oldFileIo, oldIdxFile, oldSize);
        }
        finally {
            U.closeQuiet(oldFileIo);
            oldIdxFile.delete();
        }
    }

    private void copyDataFromOldFile(FileIO oldFile, File oldIdxFile, long oldSize) {
        try {
            this.entriesCnt = 0L;
            oldFile.position(0L);
            for (long i = 0L; i < oldSize; ++i) {
                Entry e = this.readEntryFromIndexFile(-1L, oldFile);
                if (e.isRemoved() || e.isEmpty()) continue;
                this.putEntryToFreeSlot(e.hashCode(), e.rowAddress());
            }
        }
        catch (IOException e) {
            U.closeQuiet(this);
            U.closeQuiet(oldFile);
            throw new IgniteException("Failed to extend hash index.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNewIndexFile(long cap) {
        try {
            assert (cap > 0L && (cap & cap - 1L) == 0L) : "cap=" + cap;
            if (cap > 0x400000000000000L) {
                throw new IllegalArgumentException("Maximum capacity is exceeded [curCapacity=" + cap + ", maxCapacity=" + 0x400000000000000L + ']');
            }
            this.cap = cap;
            this.idxFile = new File(this.dir, this.spillFileName + "_idx_" + this.id++);
            this.idxFile.deleteOnExit();
            ExternalResultHashIndex externalResultHashIndex = this;
            synchronized (externalResultHashIndex) {
                this.checkCancelled();
                this.fileIo = this.fileIOFactory.create(this.idxFile, this.memTracker, StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
                this.reusableBuff.clear();
                this.fileIo.write(this.reusableBuff, cap * 12L);
            }
        }
        catch (IOException e) {
            U.closeQuiet(this);
            throw new IgniteException("Failed to create an index spill file for the intermediate query results.", e);
        }
    }

    private synchronized void checkCancelled() {
        if (this.closed) {
            throw DbException.get(57014);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        ExternalResultHashIndex externalResultHashIndex = this;
        synchronized (externalResultHashIndex) {
            if (this.closed) {
                return;
            }
            U.closeQuiet(this.fileIo);
            this.closed = true;
        }
        this.idxFile.delete();
    }

    ExternalResultHashIndex createShallowCopy() {
        return new ExternalResultHashIndex(this);
    }

    private static class Entry {
        static final int ENTRY_BYTES = 12;
        private final int hashCode;
        private final long rowAddr;
        private final long slot;

        Entry(int hashCode, long rowAddr, long slot) {
            this.hashCode = hashCode;
            this.rowAddr = rowAddr;
            this.slot = slot;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public long rowAddress() {
            return this.rowAddr & Long.MAX_VALUE;
        }

        public long slot() {
            return this.slot;
        }

        public boolean isRemoved() {
            return (this.rowAddr & Long.MIN_VALUE) != 0L;
        }

        public boolean isEmpty() {
            return this.rowAddr == -1L;
        }

        public String toString() {
            return S.toString(Entry.class, this);
        }
    }
}

