/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;

public class H2IOUtils {
    private H2IOUtils() {
    }

    public static void storeRow(H2CacheRow row, long pageAddr, int off, boolean storeMvcc) {
        assert (row.link() != 0L);
        PageUtils.putLong(pageAddr, off, row.link());
        if (storeMvcc) {
            long mvccCrdVer = row.mvccCoordinatorVersion();
            long mvccCntr = row.mvccCounter();
            int mvccOpCntr = row.mvccOperationCounter();
            assert (MvccUtils.mvccVersionIsValid(mvccCrdVer, mvccCntr, mvccOpCntr));
            PageUtils.putLong(pageAddr, off + 8, mvccCrdVer);
            PageUtils.putLong(pageAddr, off + 16, mvccCntr);
            PageUtils.putInt(pageAddr, off + 24, mvccOpCntr);
        }
    }

    static void store(long dstPageAddr, int dstOff, BPlusIO<H2Row> srcIo, long srcPageAddr, int srcIdx, boolean storeMvcc) {
        H2RowLinkIO rowIo = (H2RowLinkIO)((Object)srcIo);
        long link = rowIo.getLink(srcPageAddr, srcIdx);
        PageUtils.putLong(dstPageAddr, dstOff, link);
        if (storeMvcc) {
            long mvccCrdVer = rowIo.getMvccCoordinatorVersion(srcPageAddr, srcIdx);
            long mvccCntr = rowIo.getMvccCounter(srcPageAddr, srcIdx);
            int mvccOpCntr = rowIo.getMvccOperationCounter(srcPageAddr, srcIdx);
            assert (MvccUtils.mvccVersionIsValid(mvccCrdVer, mvccCntr, mvccOpCntr));
            PageUtils.putLong(dstPageAddr, dstOff + 8, mvccCrdVer);
            PageUtils.putLong(dstPageAddr, dstOff + 16, mvccCntr);
            PageUtils.putInt(dstPageAddr, dstOff + 24, mvccOpCntr);
        }
    }
}

