/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2IOUtils;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;

public abstract class AbstractH2ExtrasLeafIO
extends BPlusLeafIO<H2Row>
implements H2RowLinkIO {
    protected final int payloadSize;

    public static void register() {
        AbstractH2ExtrasLeafIO.register(false);
        AbstractH2ExtrasLeafIO.register(true);
    }

    private static void register(boolean mvcc) {
        int type = mvcc ? 23000 : 10000;
        for (short payload = 1; payload <= 2048; payload = (short)(payload + 1)) {
            IOVersions<? extends AbstractH2ExtrasLeafIO> io = AbstractH2ExtrasLeafIO.getVersions((short)(type + payload - 1), payload, mvcc);
            PageIO.registerH2ExtraLeaf(io, mvcc);
        }
    }

    public static IOVersions<? extends BPlusLeafIO<H2Row>> getVersions(int payload, boolean mvccEnabled) {
        assert (payload >= 0 && payload <= 2048);
        if (payload == 0) {
            return mvccEnabled ? H2MvccLeafIO.VERSIONS : H2LeafIO.VERSIONS;
        }
        return PageIO.getLeafVersions((short)(payload - 1), mvccEnabled);
    }

    private static IOVersions<? extends AbstractH2ExtrasLeafIO> getVersions(short type, short payload, boolean mvcc) {
        return new IOVersions((PageIO[])new AbstractH2ExtrasLeafIO[]{mvcc ? new H2MvccExtrasLeafIO(type, 1, (int)payload) : new H2ExtrasLeafIO(type, 1, (int)payload)});
    }

    AbstractH2ExtrasLeafIO(short type, int ver, int itemSize, int payloadSize) {
        super(type, ver, itemSize + payloadSize);
        this.payloadSize = payloadSize;
    }

    @Override
    public final void storeByOffset(long pageAddr, int off, H2Row row) {
        InlineIndexColumn idx;
        int size;
        this.assertPageType(pageAddr);
        H2CacheRow row0 = (H2CacheRow)row;
        assert (row0.link() != 0L);
        List<InlineIndexColumn> inlineIdxs = InlineIndexColumnFactory.getCurrentInlineIndexes();
        assert (inlineIdxs != null) : "no inline index helpers";
        int fieldOff = 0;
        for (int i = 0; i < inlineIdxs.size() && (size = (idx = inlineIdxs.get(i)).put(pageAddr, off + fieldOff, row.getValue(idx.columnIndex()), this.payloadSize - fieldOff)) != 0; ++i) {
            fieldOff += size;
        }
        H2IOUtils.storeRow(row0, pageAddr, off + this.payloadSize, this.storeMvccInfo());
    }

    @Override
    public final void store(long dstPageAddr, int dstIdx, BPlusIO<H2Row> srcIo, long srcPageAddr, int srcIdx) {
        this.assertPageType(dstPageAddr);
        int srcOff = srcIo.offset(srcIdx);
        byte[] payload = PageUtils.getBytes(srcPageAddr, srcOff, this.payloadSize);
        long link = PageUtils.getLong(srcPageAddr, srcOff + this.payloadSize);
        assert (link != 0L);
        int dstOff = this.offset(dstIdx);
        PageUtils.putBytes(dstPageAddr, dstOff, payload);
        H2IOUtils.store(dstPageAddr, dstOff + this.payloadSize, srcIo, srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    @Override
    public H2Row getLookupRow(BPlusTree<H2Row, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = this.getMvccOperationCounter(pageAddr, idx);
            return ((H2Tree)tree).createMvccRow(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((H2Tree)tree).createRow(link);
    }

    @Override
    public final long getLink(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + this.payloadSize);
    }

    @Override
    public int getPayloadSize() {
        return this.payloadSize;
    }
}

