/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.apache.ignite.internal.util.GridUnsafe;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueString;

public class StringInlineIndexColumn
extends AbstractInlineIndexColumn {
    protected static final Charset CHARSET = StandardCharsets.UTF_8;
    private final boolean compareIgnoreCase;
    private final boolean useOptimizedCompare;

    public StringInlineIndexColumn(Column col, boolean useOptimizedCompare) {
        this(col, 13, useOptimizedCompare, false);
    }

    StringInlineIndexColumn(Column col, int type, boolean useOptimizedCompare, boolean compareIgnoreCase) {
        super(col, type, (short)-1);
        this.compareIgnoreCase = compareIgnoreCase;
        this.useOptimizedCompare = useOptimizedCompare;
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type || !this.useOptimizedCompare) {
            return this.isValueFull(pageAddr, off) ? Integer.MIN_VALUE : -2;
        }
        return this.compareAsString(pageAddr, off, v, this.compareIgnoreCase);
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        byte[] s2 = val.getString().getBytes(CHARSET);
        short size = s2.length + 3 <= maxSize ? (short)s2.length : (short)((s2 = StringInlineIndexColumn.trimUTF8(s2, maxSize - 3)) == null ? 0 : s2.length | 0x8000);
        if (s2 == null) {
            PageUtils.putByte(pageAddr, off, (byte)-1);
            return 0;
        }
        PageUtils.putByte(pageAddr, off, (byte)val.getValueType());
        PageUtils.putShort(pageAddr, off + 1, size);
        PageUtils.putBytes(pageAddr, off + 3, s2);
        return s2.length + 3;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueString.get(new String(this.readBytes(pageAddr, off), CHARSET));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return val.getString().getBytes(CHARSET).length + 3;
    }

    private int compareAsString(long pageAddr, int off, Value v, boolean ignoreCase) {
        int res;
        char v2;
        char v1;
        int c;
        String s2 = v.getString();
        int len1 = PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE;
        int len2 = s2.length();
        int cntr1 = 0;
        int cntr2 = 0;
        long addr = pageAddr + (long)off + 3L;
        while (cntr1 < len1 && cntr2 < len2 && (c = GridUnsafe.getByte(addr) & 0xFF) <= 127) {
            ++cntr1;
            ++addr;
            v1 = (char)c;
            v2 = s2.charAt(cntr2++);
            if (ignoreCase) {
                v1 = Character.toUpperCase(v1);
                v2 = Character.toUpperCase(v2);
            }
            if (v1 == v2) continue;
            return Integer.signum(v1 - v2);
        }
        block7: while (cntr1 < len1 && cntr2 < len2) {
            c = GridUnsafe.getByte(addr++) & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++cntr1;
                    v1 = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    int c2;
                    if ((cntr1 += 2) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    if (((c2 = GridUnsafe.getByte(addr++) & 0xFF) & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 2));
                    }
                    c &= 0x1F;
                    c = c << 6 | c2 & 0x3F;
                    v1 = (char)c;
                    break;
                }
                case 14: {
                    if ((cntr1 += 3) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    int c2 = GridUnsafe.getByte(addr++) & 0xFF;
                    int c3 = GridUnsafe.getByte(addr++) & 0xFF;
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 3));
                    }
                    c &= 0xF;
                    c = c << 6 | c2 & 0x3F;
                    c = c << 6 | c3 & 0x3F;
                    v1 = (char)c;
                    break;
                }
                case 15: {
                    if ((cntr1 += 4) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    int c2 = GridUnsafe.getByte(addr++) & 0xFF;
                    int c3 = GridUnsafe.getByte(addr++) & 0xFF;
                    int c4 = GridUnsafe.getByte(addr++) & 0xFF;
                    if ((c & 0xF8) != 240 || (c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 4));
                    }
                    c &= 7;
                    c = c << 6 | c2 & 0x3F;
                    c = c << 6 | c3 & 0x3F;
                    c = c << 6 | c4 & 0x3F;
                    v1 = (char)(55296 + ((c -= 65536) >> 10 & 0x7FF));
                    if (v1 != (v2 = s2.charAt(cntr2++))) {
                        return Integer.signum(v1 - v2);
                    }
                    if (cntr2 == len2) {
                        return 1;
                    }
                    v1 = (char)(56320 + (c & 0x3FF));
                    if (v1 == (v2 = s2.charAt(cntr2++))) continue block7;
                    return Integer.signum(v1 - v2);
                }
                default: {
                    throw new IllegalStateException("Malformed input around byte: " + cntr1);
                }
            }
            v2 = s2.charAt(cntr2++);
            if (ignoreCase) {
                v1 = Character.toUpperCase(v1);
                v2 = Character.toUpperCase(v2);
            }
            if (v1 == v2) continue;
            return Integer.signum(v1 - v2);
        }
        int n = cntr1 == len1 && cntr2 == len2 ? 0 : (res = cntr1 == len1 ? -1 : 1);
        if (this.isValueFull(pageAddr, off)) {
            return res;
        }
        if (res >= 0) {
            return 1;
        }
        return -2;
    }

    private boolean isValueFull(long pageAddr, int off) {
        return (PageUtils.getShort(pageAddr, off + 1) & 0x8000) == 0;
    }

    static byte[] trimUTF8(byte[] bytes, int limit) {
        if (bytes.length <= limit) {
            return bytes;
        }
        for (int i = limit; i > 0; --i) {
            if ((bytes[i] & 0xC0) == 128) continue;
            byte[] res = new byte[i];
            System.arraycopy(bytes, 0, res, 0, i);
            return res;
        }
        return null;
    }
}

