/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.BytesInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;

public abstract class H2TreeIndexBase
extends GridH2IndexBase {
    static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 64;
    static final int IGNITE_VARIABLE_TYPE_DEFAULT_INDEX_SIZE = 10;
    static final Pattern STRING_WITH_LENGTH_SQL_PATTERN = Pattern.compile("\\w+\\((\\d+)\\)");

    protected H2TreeIndexBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        super(tbl, name, cols, type);
    }

    public abstract int inlineSize();

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        long rowCnt = this.getRowCountApproximation(ses);
        double baseCost = this.costRangeIndex(ses, masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    static int computeInlineSize(String name, List<InlineIndexColumn> inlineIdxs, int cfgInlineSize, int maxInlineSize, IgniteLogger log) {
        int propSize;
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        boolean fixedSize = true;
        int n = propSize = maxInlineSize == -1 ? IgniteSystemProperties.getInteger("IGNITE_MAX_INDEX_PAYLOAD_SIZE", 64) : maxInlineSize;
        if (propSize == 0) {
            return 0;
        }
        int size = 0;
        for (InlineIndexColumn idxHelper : inlineIdxs) {
            Matcher m4;
            String sql;
            int sizeInc = idxHelper.size() < 0 ? 10 : idxHelper.size() + 1;
            fixedSize &= idxHelper.size() != -1;
            if ((idxHelper instanceof StringInlineIndexColumn || idxHelper instanceof BytesInlineIndexColumn) && (sql = idxHelper.columnSql()) != null && (m4 = STRING_WITH_LENGTH_SQL_PATTERN.matcher(sql)).find()) {
                sizeInc = Integer.parseInt(m4.group(1)) + 3;
            }
            if ((size += sizeInc) <= propSize) continue;
            size = propSize;
        }
        if (cfgInlineSize != -1) {
            cfgInlineSize = Math.min(2048, cfgInlineSize);
            if (fixedSize && size < cfgInlineSize) {
                log.warning("Explicit INLINE_SIZE for fixed size index item is too big. This will lead to wasting of space inside index pages. Ignoring [index=" + name + ", explicitInlineSize=" + cfgInlineSize + ", realInlineSize=" + size + ']');
                return size;
            }
            return cfgInlineSize;
        }
        return Math.min(2048, size);
    }

    static List<InlineIndexColumn> getAvailableInlineColumns(boolean affinityKey, String cacheName, String idxName, IgniteLogger log, boolean pk, Table tbl, IndexColumn[] cols, InlineIndexColumnFactory factory, boolean inlineObjHashSupported) {
        ArrayList<InlineIndexColumn> res = new ArrayList<InlineIndexColumn>(cols.length);
        for (IndexColumn col : cols) {
            if (!InlineIndexColumnFactory.typeSupported(col.column.getType().getValueType())) {
                String idxType = pk ? "PRIMARY KEY" : (affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
                U.warn(log, "Column cannot be inlined into the index because it's type doesn't support inlining, index access may be slow due to additional page reads (change column type if possible) [cacheName=" + cacheName + ", tableName=" + tbl.getName() + ", idxName=" + idxName + ", idxType=" + idxType + ", colName=" + col.columnName + ", columnType=" + InlineIndexColumnFactory.nameTypeByCode(col.column.getType().getValueType()) + ']');
                res.trimToSize();
                break;
            }
            res.add(factory.createInlineHelper(col.column, inlineObjHashSupported));
        }
        return res;
    }
}

