/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.managers.IgniteMBeansManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.mxbean.SqlQueryMXBean;
import org.apache.ignite.internal.mxbean.SqlQueryMXBeanImpl;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCachingManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.StaticMvccQueryTracker;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.LinkMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.RegisteredQueryCursor;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.ColumnInformation;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryFinishedInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.processors.query.GridQueryStartedInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.TableInformation;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.CommandProcessor;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.DistributedSqlConfiguration;
import org.apache.ignite.internal.processors.query.h2.FunctionsManager;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2JavaObjectSerializer;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.H2RowCacheRegistry;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IndexQuerySqlGenerator;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildFullClosure;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildPartialClosure;
import org.apache.ignite.internal.processors.query.h2.LongRunningQueryManager;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryTracker;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParser;
import org.apache.ignite.internal.processors.query.h2.QueryParserResult;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultSelect;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.TextIndexRebuildClosure;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.affinity.H2PartitionResolver;
import org.apache.ignite.internal.processors.query.h2.affinity.PartitionExtractor;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeClientIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccLeafIO;
import org.apache.ignite.internal.processors.query.h2.defragmentation.IndexingDefragmentation;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.DmlUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.extension.SqlPluginExtension;
import org.apache.ignite.internal.processors.query.h2.maintenance.MaintenanceRebuildIndexUtils;
import org.apache.ignite.internal.processors.query.h2.maintenance.RebuildIndexWorkflowCallback;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.sql.GridFirstValueFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridLastValueFunction;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservationManager;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationException;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManager;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManagerImpl;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.gridgain.internal.h2.api.JavaObjectSerializer;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.value.DataType;
import org.jetbrains.annotations.Nullable;

public class IgniteH2Indexing
implements GridQueryIndexing {
    public static final String INDEX_REBUILD_MNTC_TASK_NAME = "indexRebuildMaintenanceTask";
    private static final int DFLT_UPDATE_RERUN_ATTEMPTS = 4;
    private final boolean updateInTxAllowed = Boolean.getBoolean("IGNITE_ALLOW_DML_INSIDE_TRANSACTION");
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private GridSpinBusyLock busyLock;
    private final H2RowCacheRegistry rowCache = new H2RowCacheRegistry();
    protected volatile GridKernalContext ctx;
    private final QueryContextRegistry qryCtxRegistry = new QueryContextRegistry();
    private CommandProcessor cmdProc;
    protected PartitionReservationManager partReservationMgr;
    private PartitionExtractor partExtractor;
    private RunningQueryManager runningQryMgr;
    private QueryParser parser;
    private QueryMemoryManager memoryMgr;
    private DistributedSqlConfiguration distrCfg;
    private IndexingDefragmentation defragmentation = new IndexingDefragmentation(this);
    private final IgniteInClosure<? super IgniteInternalFuture<?>> logger = new IgniteInClosure<IgniteInternalFuture<?>>(){

        @Override
        public void apply(IgniteInternalFuture<?> fut) {
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error(IgniteH2Indexing.this.log, e.getMessage(), e);
            }
        }
    };
    private ConnectionManager connMgr;
    private SchemaManager schemaMgr;
    private LongRunningQueryManager longRunningQryMgr;
    private GridLocalEventListener discoLsnr;
    private GridMessageListener qryLsnr;
    private IgniteStatisticsManager statsMgr;
    private final Map<Integer, SchemaIndexCacheFuture> idxRebuildFuts = new ConcurrentHashMap<Integer, SchemaIndexCacheFuture>();

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    @Override
    public List<JdbcParameterMeta> parameterMetaData(String schemaName, SqlFieldsQuery qry) throws IgniteSQLException {
        assert (qry != null);
        ArrayList<JdbcParameterMeta> metas = new ArrayList<JdbcParameterMeta>();
        SqlFieldsQuery curQry = qry;
        while (curQry != null) {
            QueryParserResult parsed = this.parser.parse(schemaName, curQry, true);
            metas.addAll(parsed.parametersMeta());
            curQry = parsed.remainingQuery();
        }
        return metas;
    }

    @Override
    public List<GridQueryFieldMetadata> resultMetaData(String schemaName, SqlFieldsQuery qry) throws IgniteSQLException {
        QueryParserResult parsed = this.parser.parse(schemaName, qry, true);
        if (parsed.remainingQuery() != null) {
            return null;
        }
        if (parsed.isSelect()) {
            return parsed.select().meta();
        }
        return null;
    }

    @Override
    public void store(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        String cacheName = cctx.name();
        H2TableDescriptor tbl = this.schemaMgr.tableForType(this.schema(cacheName), cacheName, type.name());
        if (tbl == null) {
            return;
        }
        tbl.table().update(row, prevRow, prevRowAvailable);
        if (tbl.luceneIndex() != null) {
            long expireTime = row.expireTime();
            if (expireTime == 0L) {
                expireTime = Long.MAX_VALUE;
            }
            tbl.luceneIndex().store(row.key(), row.value(), row.version(), expireTime);
        }
    }

    @Override
    public void remove(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row) throws IgniteCheckedException {
        String cacheName;
        H2TableDescriptor tbl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + row.key() + ", val=" + row.value() + ']');
        }
        if ((tbl = this.schemaMgr.tableForType(this.schema(cacheName = cctx.name()), cacheName, type.name())) == null) {
            return;
        }
        if (tbl.table().remove(row) && tbl.luceneIndex() != null) {
            tbl.luceneIndex().remove(row.key());
        }
    }

    @Override
    public void dynamicIndexCreate(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        this.schemaMgr.createIndex(schemaName, tblName, idxDesc, ifNotExists, cacheVisitor);
    }

    @Override
    public void dynamicIndexDrop(String schemaName, String idxName, boolean ifExists) throws IgniteCheckedException {
        this.schemaMgr.dropIndex(schemaName, idxName, ifExists);
    }

    @Override
    public void dynamicAddColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
        this.schemaMgr.addColumn(schemaName, tblName, cols, ifTblExists, ifColNotExists);
        this.clearPlanCache();
    }

    @Override
    public void dynamicDropColumn(String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifColExists) throws IgniteCheckedException {
        this.schemaMgr.dropColumn(schemaName, tblName, cols, ifTblExists, ifColExists);
        this.clearPlanCache();
    }

    GridH2IndexBase createSortedIndex(String name, GridH2Table tbl, boolean pk, boolean affinityKey, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, int inlineSize) {
        try {
            GridCacheContextInfo cacheInfo = tbl.cacheInfo();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating cache index [cacheId=" + cacheInfo.cacheId() + ", idxName=" + name + ']');
            }
            if (cacheInfo.affinityNode()) {
                int segments = tbl.rowDescriptor().context().config().getQueryParallelism();
                H2RowCache cache = this.rowCache.forGroup(cacheInfo.groupId());
                return H2TreeIndex.createIndex(cacheInfo.cacheContext(), cache, tbl, name, pk, affinityKey, unwrappedCols, wrappedCols, inlineSize, segments, this.log);
            }
            return H2TreeClientIndex.createIndex(tbl, name, pk, unwrappedCols, inlineSize, this.log);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalText(String schemaName, String cacheName, String qry, String typeName, IndexingQueryFilter filters) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.schemaMgr.tableForType(schemaName, cacheName, typeName);
        if (tbl != null && tbl.luceneIndex() != null) {
            Long qryId = this.runningQueryManager().register(qry, GridCacheQueryType.TEXT, schemaName, true, null, null, null, false, false, false, null);
            Throwable failReason = null;
            try {
                GridCloseableIterator gridCloseableIterator = tbl.luceneIndex().query(qry.toUpperCase(), filters);
                return gridCloseableIterator;
            }
            catch (Throwable t2) {
                failReason = t2;
                throw t2;
            }
            finally {
                this.runningQueryManager().unregister(qryId, failReason);
            }
        }
        return new GridEmptyCloseableIterator<IgniteBiTuple<K, V>>();
    }

    private GridQueryFieldsResult executeSelectLocal(final @Nullable Long qryId, final QueryDescriptor qryDesc, final QueryParameters qryParams, QueryParserResultSelect select, IndexingQueryFilter filter, final MvccQueryTracker mvccTracker, final GridQueryCancel cancel, boolean inTx, final int timeout) {
        assert (!select.mvccEnabled() || mvccTracker != null);
        final String qry = select.forUpdate() ? (inTx ? select.forUpdateQueryTx() : select.forUpdateQueryOutTx()) : qryDesc.sql();
        boolean mvccEnabled = mvccTracker != null;
        try {
            assert (select != null);
            if (this.ctx.security().enabled()) {
                this.checkSecurity(select.cacheIds());
            }
            MvccSnapshot mvccSnapshot = null;
            if (mvccEnabled) {
                mvccSnapshot = mvccTracker.snapshot();
            }
            final long maxMem = qryParams.maxMemory();
            final QueryContext qctx = new QueryContext(0, filter, null, mvccSnapshot, null, true);
            return new GridQueryFieldsResultAdapter(select.meta(), null){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public GridCloseableIterator<List<?>> iterator() throws IgniteCheckedException {
                    H2PooledConnection conn = IgniteH2Indexing.this.connections().connection(qryDesc.schemaName());
                    try (MTC.TraceSurroundings ignored = MTC.support(IgniteH2Indexing.this.ctx.tracing().create(SpanType.SQL_ITER_OPEN, MTC.span()));){
                        H2Utils.setupConnection(conn, qctx, qryDesc.distributedJoins(), qryDesc.enforceJoinOrder(), qryParams.lazy());
                        H2Utils.initializeCatalog(conn);
                        List<Object[]> args = F.asList(qryParams.arguments());
                        PreparedStatement stmt = conn.prepareStatement(qry, H2StatementCache.queryFlags(qryDesc));
                        Marshaller m4 = IgniteH2Indexing.this.ctx.config().getMarshaller();
                        byte[] paramsBytes = U.marshal(m4, (Object)args.toArray(new Object[0]));
                        ClassLoader ldr = U.resolveClassLoader(IgniteH2Indexing.this.ctx.config());
                        Object[] params = (Object[])((BinaryMarshaller)m4).binaryMarshaller().unmarshal(paramsBytes, ldr);
                        H2Utils.bindParameters(stmt, F.asList(params));
                        H2QueryInfo qryInfo = new H2QueryInfo(H2QueryInfo.QueryType.LOCAL, stmt, qry, IgniteH2Indexing.this.ctx.discovery().localNode(), qryId, qryDesc.label());
                        ResultSet rs = IgniteH2Indexing.this.executeSqlQueryWithTimer(stmt, conn, qry, timeout, cancel, qryParams.dataPageScanEnabled(), qryInfo, maxMem);
                        H2FieldsIterator h2FieldsIterator = new H2FieldsIterator(rs, mvccTracker, conn, qryParams.pageSize(), IgniteH2Indexing.this.log, IgniteH2Indexing.this, qryInfo, IgniteH2Indexing.this.ctx.tracing());
                        return h2FieldsIterator;
                    }
                    catch (Error | RuntimeException | IgniteCheckedException e) {
                        conn.close();
                        try {
                            if (mvccTracker == null) throw e;
                            mvccTracker.onDone();
                            throw e;
                        }
                        catch (Exception e0) {
                            e.addSuppressed(e0);
                        }
                        throw e;
                    }
                }
            };
        }
        catch (Exception e) {
            IgniteTxAdapter tx = null;
            if (mvccEnabled && (tx != null || (tx = MvccUtils.tx(this.ctx)) != null)) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    public static int operationTimeout(int qryTimeout, IgniteTxAdapter tx) {
        if (tx != null) {
            int remaining = (int)tx.remainingTime();
            return remaining > 0 && qryTimeout > 0 ? Math.min(remaining, qryTimeout) : Math.max(remaining, qryTimeout);
        }
        return qryTimeout;
    }

    @Override
    public long streamUpdateQuery(String schemaName, String qry, @Nullable Object[] params, IgniteDataStreamer<?, ?> streamer, String qryInitiatorId) throws IgniteCheckedException {
        QueryParserResultDml dml = this.streamerParse(schemaName, qry);
        return this.streamQuery0(qry, schemaName, streamer, dml, params, qryInitiatorId);
    }

    @Override
    public List<Long> streamBatchedUpdateQuery(String schemaName, String qry, List<Object[]> params, SqlClientContext cliCtx, String qryInitiatorId) throws IgniteCheckedException {
        if (cliCtx == null || !cliCtx.isStream()) {
            U.warn(this.log, "Connection is not in streaming mode.");
            return IgniteH2Indexing.zeroBatchedStreamedUpdateResult(params.size());
        }
        QueryParserResultDml dml = this.streamerParse(schemaName, qry);
        IgniteDataStreamer<?, ?> streamer = cliCtx.streamerForCache(dml.streamTable().cacheName());
        assert (streamer != null);
        ArrayList<Long> ress = new ArrayList<Long>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            long res = this.streamQuery0(qry, schemaName, streamer, dml, params.get(i), qryInitiatorId);
            ress.add(res);
        }
        return ress;
    }

    private long streamQuery0(String qry, String schemaName, IgniteDataStreamer streamer, QueryParserResultDml dml, Object[] args, String qryInitiatorId) throws IgniteCheckedException {
        Long qryId = this.runningQryMgr.register(qry, GridCacheQueryType.SQL_FIELDS, schemaName, true, null, null, qryInitiatorId, false, false, false, null);
        Exception failReason = null;
        try {
            UpdatePlan plan = dml.plan();
            List<List<?>> planRows = plan.createRows(args != null ? args : X.EMPTY_OBJECT_ARRAY);
            GridQueryCacheObjectsIterator iter = new GridQueryCacheObjectsIterator(planRows.iterator(), this.objectContext(), true);
            if (planRows.size() == 1) {
                IgniteBiTuple<?, ?> t2 = plan.processRow((List)iter.next());
                streamer.addData(t2.getKey(), t2.getValue());
                long l = 1L;
                return l;
            }
            LinkedHashMap rows = new LinkedHashMap(plan.rowCount());
            while (iter.hasNext()) {
                List row = (List)iter.next();
                IgniteBiTuple<?, ?> t3 = plan.processRow(row);
                rows.put(t3.getKey(), t3.getValue());
            }
            streamer.addData(rows);
            long l = rows.size();
            return l;
        }
        catch (IgniteCheckedException | IgniteException e) {
            failReason = e;
            throw e;
        }
        finally {
            this.runningQryMgr.unregister(qryId, failReason);
        }
    }

    private QueryParserResultDml streamerParse(String schemaName, String qry) {
        QueryParserResult parseRes = this.parser.parse(schemaName, new SqlFieldsQuery(qry), false);
        QueryParserResultDml dml = parseRes.dml();
        if (dml == null || !dml.streamable()) {
            throw new IgniteSQLException("Streaming mode supports only INSERT commands without subqueries.", 1002);
        }
        return dml;
    }

    private static List<Long> zeroBatchedStreamedUpdateResult(int size) {
        Object[] res = new Long[size];
        Arrays.fill(res, (Object)0L);
        return Arrays.asList(res);
    }

    private ResultSet executeSqlQuery(H2PooledConnection conn, PreparedStatement stmt, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        if (cancel != null) {
            cancel.add(() -> IgniteH2Indexing.cancelStatement(stmt));
        }
        Session ses = H2Utils.session(conn);
        if (timeoutMillis >= 0) {
            ses.setQueryTimeout(timeoutMillis);
        } else {
            ses.setQueryTimeout(this.distrCfg.defaultQueryTimeout());
        }
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            if (X.hasCause((Throwable)e, QueryMemoryTracker.TrackerWasClosedException.class)) {
                cancel.checkCancelled();
            }
            if (e.getErrorCode() == 57014) {
                throw new QueryCancelledException();
            }
            if (e.getCause() instanceof IgniteSQLException) {
                throw (IgniteSQLException)e.getCause();
            }
            if (e.getCause() instanceof CacheException) {
                throw (CacheException)e.getCause();
            }
            throw new IgniteSQLException(e);
        }
    }

    private static void cancelStatement(PreparedStatement stmt) {
        try {
            stmt.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeSqlQueryWithTimer(H2PooledConnection conn, String sql, @Nullable Collection<Object> params, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo, long maxMem) throws IgniteCheckedException {
        PreparedStatement stmt = conn.prepareStatementNoCache(sql);
        H2Utils.bindParameters(stmt, params);
        return this.executeSqlQueryWithTimer(stmt, conn, sql, timeoutMillis, cancel, dataPageScanEnabled, qryInfo, maxMem);
    }

    public void enableDataPageScan(Boolean dataPageScanEnabled) {
        CacheDataTree.setDataPageScanEnabled(false);
    }

    /*
     * Exception decompiling
     */
    public ResultSet executeSqlQueryWithTimer(PreparedStatement stmt, H2PooledConnection conn, String sql, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo, long maxMem) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public H2MemoryTracker memTracker(H2QueryInfo qryInfo) {
        assert (qryInfo.runningQueryId() != null);
        GridRunningQueryInfo runningQryInfo = this.runningQryMgr.runningQueryInfo(qryInfo.runningQueryId());
        if (runningQryInfo != null && runningQryInfo.memoryMetricProvider() != null && !(runningQryInfo.memoryMetricProvider() instanceof H2MemoryTracker)) {
            return null;
        }
        if (runningQryInfo != null && runningQryInfo.memoryMetricProvider() instanceof H2MemoryTracker) {
            return ((H2MemoryTracker)((Object)runningQryInfo.memoryMetricProvider())).createChildTracker();
        }
        assert (false) : "Cannot find running query info to get memory tracker [qryInfo=" + qryInfo + ']';
        this.log.warning("Cannot find running query info to get memory tracker [qryInfo=" + qryInfo + ']');
        return null;
    }

    public void initSession(H2PooledConnection conn, H2QueryInfo qryInfo, long maxMem) {
        Session s2 = H2Utils.session(conn);
        s2.groupByDataFactory(this.memoryMgr);
        s2.queryDescription(qryInfo::description);
        GridRunningQueryInfo runningQryInfo = null;
        if (qryInfo.runningQueryId() != null) {
            runningQryInfo = this.runningQryMgr.runningQueryInfo(qryInfo.runningQueryId());
        }
        H2MemoryTracker tracker = null;
        if (runningQryInfo != null && runningQryInfo.nodeId().equals(qryInfo.node()) && runningQryInfo.memoryMetricProvider() != null) {
            if (runningQryInfo.memoryMetricProvider() instanceof H2MemoryTracker) {
                tracker = ((H2MemoryTracker)((Object)runningQryInfo.memoryMetricProvider())).createChildTracker();
            } else {
                return;
            }
        }
        if (tracker == null) {
            tracker = (H2MemoryTracker)((Object)this.memoryMgr.createQueryMemoryTracker(maxMem));
        }
        s2.memoryTracker(tracker);
    }

    @Override
    public SqlFieldsQuery generateFieldsQuery(String cacheName, SqlQuery qry) {
        String sql;
        String type;
        String schemaName = this.schema(cacheName);
        H2TableDescriptor tblDesc = this.schemaMgr.tableForType(schemaName, cacheName, type = qry.getType());
        if (tblDesc == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        try {
            sql = H2Utils.generateFieldsQueryString(qry.getSql(), qry.getAlias(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        SqlFieldsQuery res = QueryUtils.withQueryTimeout(new SqlFieldsQuery(sql), qry.getTimeout(), TimeUnit.MILLISECONDS);
        res.setArgs(qry.getArgs());
        res.setDistributedJoins(qry.isDistributedJoins());
        res.setLocal(qry.isLocal());
        res.setPageSize(qry.getPageSize());
        res.setPartitions(qry.getPartitions());
        res.setReplicatedOnly(qry.isReplicatedOnly());
        res.setSchema(schemaName);
        res.setSql(sql);
        return res;
    }

    @Override
    public <K, V> SqlFieldsQuery generateFieldsQuery(String cacheName, IndexQuery<K, V> qry, String type) {
        if (qry.isLocal() && this.ctx.clientNode()) {
            throw new CacheException("Execution of local IndexQuery on client node disallowed.");
        }
        String schemaName = this.schema(cacheName);
        H2TableDescriptor tblDesc = this.schemaMgr.tableForType(schemaName, cacheName, type);
        if (tblDesc == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        IndexQuerySqlGenerator.SqlGeneratorResult result = IndexQuerySqlGenerator.generate(qry, tblDesc);
        SqlFieldsQuery fieldsQuery = new SqlFieldsQuery(result.sql());
        fieldsQuery.setArgs(result.arguments());
        fieldsQuery.setLocal(qry.isLocal());
        fieldsQuery.setPageSize(qry.getPageSize());
        fieldsQuery.setSchema(schemaName);
        fieldsQuery.setLabel(qry.getLabel());
        if (qry.getPartition() != null) {
            fieldsQuery.setPartitions(qry.getPartition());
        }
        return fieldsQuery;
    }

    /*
     * Exception decompiling
     */
    private FieldsQueryCursor<List<?>> executeCommand(QueryDescriptor qryDesc, QueryParameters qryParams, @Nullable SqlClientContext cliCtx, QueryParserResultCommand cmd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkClusterState(QueryParserResult parseRes) {
        if (!this.ctx.state().publicApiActiveState(true)) {
            if (parseRes.isCommand()) {
                QueryParserResultCommand cmd = parseRes.command();
                assert (cmd != null);
                SqlCommand cmd0 = cmd.commandNative();
                if (cmd0 instanceof SqlCommitTransactionCommand || cmd0 instanceof SqlRollbackTransactionCommand) {
                    return;
                }
            }
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
        }
    }

    @Override
    public List<FieldsQueryCursor<List<?>>> querySqlFields(String schemaName, SqlFieldsQuery qry, @Nullable SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, GridQueryCancel cancel) {
        try {
            ArrayList res = new ArrayList(1);
            String label = qry.getLabel();
            SqlFieldsQuery remainingQry = qry;
            if (!failOnMultipleStmts) {
                cancel.multiStatement(true);
            }
            while (remainingQry != null) {
                Span qrySpan = this.ctx.tracing().create(SpanType.SQL_QRY, MTC.span()).addTag("sql.schema", () -> schemaName);
                if (label != null) {
                    qrySpan.addTag("sql.query.label", () -> label);
                }
                try {
                    MTC.TraceSurroundings ignored = MTC.supportContinual(qrySpan);
                    Throwable throwable = null;
                    try {
                        QueryParserResult parseRes = this.parser.parse(schemaName, remainingQry, !failOnMultipleStmts);
                        qrySpan.addTag("sql.query.text", () -> parseRes.queryDescriptor().sql());
                        remainingQry = parseRes.remainingQuery();
                        QueryDescriptor newQryDesc = parseRes.queryDescriptor();
                        QueryParameters newQryParams = parseRes.queryParameters();
                        if (!newQryDesc.batched()) {
                            int qryParamsCnt;
                            int n = qryParamsCnt = F.isEmpty(newQryParams.arguments()) ? 0 : newQryParams.arguments().length;
                            if (qryParamsCnt < parseRes.parametersCount()) {
                                throw new IgniteSQLException("Invalid number of query parameters [expected=" + parseRes.parametersCount() + ", actual=" + qryParamsCnt + ", newQryParams=" + newQryParams + ']');
                            }
                        }
                        this.checkClusterState(parseRes);
                        if (parseRes.isCommand()) {
                            QueryParserResultCommand cmd = parseRes.command();
                            assert (cmd != null);
                            if (cmd.noOp() && remainingQry == null && newQryDesc.sql().isEmpty()) continue;
                            FieldsQueryCursor<List<?>> cmdRes = this.executeCommand(newQryDesc, newQryParams, cliCtx, cmd);
                            res.add(cmdRes);
                            continue;
                        }
                        if (parseRes.isDml()) {
                            QueryParserResultDml dml = parseRes.dml();
                            assert (dml != null);
                            if (cancel.multiStatement()) {
                                cancel.last(remainingQry == null);
                            }
                            List<? extends FieldsQueryCursor<List<?>>> dmlRes = this.executeDml(newQryDesc, newQryParams, dml, cancel);
                            res.addAll(dmlRes);
                            continue;
                        }
                        assert (parseRes.isSelect());
                        QueryParserResultSelect select = parseRes.select();
                        assert (select != null);
                        if (cancel.multiStatement()) {
                            cancel.last(remainingQry == null);
                        }
                        List<? extends FieldsQueryCursor<List<?>>> qryRes = this.executeSelect(newQryDesc, newQryParams, select, keepBinary, cancel);
                        res.addAll(qryRes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
                catch (Throwable th) {
                    qrySpan.addTag("error", th::getMessage).end();
                    throw th;
                }
            }
            return res;
        }
        catch (Error | RuntimeException e) {
            GridNearTxLocal tx = (GridNearTxLocal)this.ctx.cache().context().tm().tx();
            if (!(tx == null || tx.mvccSnapshot() == null || e instanceof IgniteSQLException && ((IgniteSQLException)e).sqlState() == "42000")) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private List<? extends FieldsQueryCursor<List<?>>> executeDml(QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, GridQueryCancel cancel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<? extends FieldsQueryCursor<List<?>>> executeSelect(QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultSelect select, boolean keepBinary, GridQueryCancel cancel) {
        assert (cancel != null);
        Long qryId = this.registerRunningQuery(qryDesc, qryParams, cancel);
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.tracing().create(SpanType.SQL_CURSOR_OPEN, MTC.span()));){
            GridNearTxLocal tx = null;
            MvccQueryTracker tracker = null;
            GridCacheContext mvccCctx = null;
            boolean inTx = false;
            if (select.mvccEnabled()) {
                boolean autoStartTx;
                mvccCctx = this.ctx.cache().context().cacheContext(select.mvccCacheId());
                if (mvccCctx == null) {
                    throw new IgniteCheckedException("Cache has been stopped concurrently [cacheId=" + select.mvccCacheId() + ']');
                }
                boolean bl = autoStartTx = !qryParams.autoCommit() && MvccUtils.tx(this.ctx) == null;
                if (autoStartTx) {
                    MvccUtils.txStart(this.ctx, (long)qryParams.timeout());
                }
                tx = MvccUtils.tx(this.ctx);
                MvccUtils.checkActive(tx);
                inTx = tx != null;
                tracker = MvccUtils.mvccTracker(mvccCctx, tx);
            }
            int timeout = IgniteH2Indexing.operationTimeout(qryParams.timeout(), tx);
            Iterable<List<?>> iter = this.executeSelect0(qryId, qryDesc, qryParams, select, keepBinary, tracker, cancel, inTx, timeout);
            if (select.forUpdate() && inTx) {
                iter = this.lockSelectedRows(iter, mvccCctx, timeout, qryParams.pageSize());
            }
            RegisteredQueryCursor cursor = new RegisteredQueryCursor(iter, cancel, this.runningQueryManager(), qryParams.lazy(), qryId, this.ctx.tracing());
            cancel.add(cursor::cancel);
            cursor.fieldsMeta(select.meta());
            cursor.partitionResult(select.twoStepQuery() != null ? select.twoStepQuery().derivedPartitions() : null);
            List<RegisteredQueryCursor<List<?>>> list = Collections.singletonList(cursor);
            return list;
        }
        catch (Exception e) {
            this.runningQryMgr.unregister(qryId, e);
            if (e instanceof IgniteCheckedException) {
                throw U.convertException((IgniteCheckedException)e);
            }
            if (!(e instanceof RuntimeException)) throw new IgniteSQLException("Failed to execute SELECT statement: " + qryDesc.sql(), e);
            throw (RuntimeException)e;
        }
    }

    private QueryCursorImpl<List<?>> executeSelectForDml(@Nullable Long qryId, String schema, SqlFieldsQuery selectQry, MvccQueryTracker mvccTracker, GridQueryCancel cancel, int timeout) {
        QueryParserResult parseRes = this.parser.parse(schema, selectQry, false);
        QueryParserResultSelect select = parseRes.select();
        assert (select != null);
        Iterable<List<?>> iter = this.executeSelect0(qryId, parseRes.queryDescriptor(), parseRes.queryParameters(), select, true, mvccTracker, cancel, false, timeout);
        QueryCursorImpl cursor = new QueryCursorImpl(iter, cancel, true, parseRes.queryParameters().lazy());
        cursor.fieldsMeta(select.meta());
        cursor.partitionResult(select.twoStepQuery() != null ? select.twoStepQuery().derivedPartitions() : null);
        return cursor;
    }

    private Iterable<List<?>> executeSelect0(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultSelect select, boolean keepBinary, MvccQueryTracker mvccTracker, GridQueryCancel cancel, boolean inTx, int timeout) {
        Iterable<List<Object>> iter;
        assert (!select.mvccEnabled() || mvccTracker != null);
        if (this.ctx.security().enabled()) {
            this.checkSecurity(select.cacheIds());
        }
        if (select.splitNeeded()) {
            GridCacheTwoStepQuery twoStepQry;
            GridCacheTwoStepQuery gridCacheTwoStepQuery = twoStepQry = select.forUpdate() && inTx ? select.forUpdateTwoStepQuery() : select.twoStepQuery();
            assert (twoStepQry != null);
            iter = this.executeSelectDistributed(qryId, qryDesc, qryParams, twoStepQry, keepBinary, mvccTracker, cancel, timeout);
        } else {
            IndexingQueryFilter filter = qryDesc.local() ? this.backupFilter(null, qryParams.partitions()) : null;
            GridQueryFieldsResult res = this.executeSelectLocal(qryId, qryDesc, qryParams, select, filter, mvccTracker, cancel, inTx, timeout);
            iter = () -> {
                try {
                    return new GridQueryCacheObjectsIterator(res.iterator(), this.objectContext(), keepBinary);
                }
                catch (IgniteCheckedException | IgniteSQLException e) {
                    throw new CacheException(e);
                }
            };
        }
        return iter;
    }

    private Iterable<List<?>> lockSelectedRows(final Iterable<List<?>> cur, final GridCacheContext cctx, int pageSize, long timeout) {
        assert (cctx != null && cctx.mvccEnabled());
        GridNearTxLocal tx = MvccUtils.tx(this.ctx);
        if (tx == null) {
            throw new IgniteSQLException("Failed to perform SELECT FOR UPDATE operation: transaction has already finished.");
        }
        final ArrayList rowsCache = new ArrayList();
        UpdateSourceIterator<KeyCacheObject> srcIt = new UpdateSourceIterator<KeyCacheObject>(){
            private Iterator<List<?>> it;
            {
                this.it = cur.iterator();
            }

            @Override
            public EnlistOperation operation() {
                return EnlistOperation.LOCK;
            }

            @Override
            public boolean hasNextX() throws IgniteCheckedException {
                return this.it.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyCacheObject nextX() throws IgniteCheckedException {
                List<?> res = this.it.next();
                Collection collection = rowsCache;
                synchronized (collection) {
                    rowsCache.add(res.subList(0, res.size() - 1));
                    if (rowsCache.size() > MvccCachingManager.TX_SIZE_THRESHOLD) {
                        throw new IgniteCheckedException("Too many rows are locked by SELECT FOR UPDATE statement. Consider locking fewer keys or increase the limit by setting a IGNITE_MVCC_TX_SIZE_CACHING_THRESHOLD system property. Current value is " + MvccCachingManager.TX_SIZE_THRESHOLD + " rows.");
                    }
                }
                return cctx.toCacheKeyObject(res.get(res.size() - 1));
            }
        };
        IgniteInternalFuture<Long> fut = tx.updateAsync(cctx, srcIt, pageSize, timeout, true);
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        return rowsCache;
    }

    private Long registerRunningQuery(QueryDescriptor qryDesc, QueryParameters qryParams, GridQueryCancel cancel) {
        return this.runningQryMgr.register(qryDesc.sql(), GridCacheQueryType.SQL_FIELDS, qryDesc.schemaName(), qryDesc.local(), this.memoryMgr.createQueryMemoryTracker(qryParams.maxMemory()), cancel, qryDesc.queryInitiatorId(), qryDesc.enforceJoinOrder(), qryParams.lazy(), qryDesc.distributedJoins(), qryDesc.label());
    }

    private void checkSecurity(Collection<Integer> cacheIds) {
        if (F.isEmpty(cacheIds)) {
            return;
        }
        for (Integer cacheId : cacheIds) {
            DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(cacheId);
            if (desc == null) continue;
            this.ctx.security().authorize(desc.cacheName(), SecurityPermission.CACHE_READ);
        }
    }

    public void registerQueryStartedListener(Consumer<GridQueryStartedInfo> lsnr) {
        this.runningQueryManager().registerQueryStartedListener(lsnr);
    }

    public boolean unregisterQueryStartedListener(Object lsnr) {
        return this.runningQueryManager().unregisterQueryStartedListener(lsnr);
    }

    public void registerQueryFinishedListener(Consumer<GridQueryFinishedInfo> lsnr) {
        this.runningQueryManager().registerQueryFinishedListener(lsnr);
    }

    public boolean unregisterQueryFinishedListener(Object lsnr) {
        return this.runningQueryManager().unregisterQueryFinishedListener(lsnr);
    }

    @Override
    public UpdateSourceIterator<?> executeUpdateOnDataNodeTransactional(GridCacheContext<?, ?> cctx, int[] ids, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, int timeout, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot, GridQueryCancel cancel) {
        QueryCursorImpl<List<Object>> cur;
        GridCacheContext<?, ?> cctx0;
        SqlFieldsQuery fldsQry = QueryUtils.withQueryTimeout(new SqlFieldsQuery(qry), timeout, TimeUnit.MILLISECONDS);
        if (params != null) {
            fldsQry.setArgs(params);
        }
        fldsQry.setEnforceJoinOrder(U.isFlagSet(flags, 2));
        fldsQry.setPageSize(pageSize);
        fldsQry.setLocal(true);
        fldsQry.setLazy(U.isFlagSet(flags, 32));
        boolean loc = true;
        boolean replicated = U.isFlagSet(flags, 16);
        if (!replicated && !F.isEmpty(ids) && (cctx0 = CU.firstPartitioned(cctx.shared(), ids)) != null && cctx0.config().getQueryParallelism() > 1) {
            fldsQry.setDistributedJoins(true);
            loc = false;
        }
        QueryParserResult parseRes = this.parser.parse(schema, fldsQry, false);
        assert (parseRes.remainingQuery() == null);
        QueryParserResultDml dml = parseRes.dml();
        assert (dml != null);
        IndexingQueryFilter filter = this.backupFilter(topVer, parts);
        UpdatePlan plan = dml.plan();
        GridCacheContext planCctx = plan.cacheContext();
        DmlUtils.setKeepBinaryContext(planCctx);
        SqlFieldsQuery selectFieldsQry = QueryUtils.withQueryTimeout(new SqlFieldsQuery(plan.selectQuery(), fldsQry.isCollocated()), fldsQry.getTimeout(), TimeUnit.MILLISECONDS).setArgs(fldsQry.getArgs()).setDistributedJoins(fldsQry.isDistributedJoins()).setEnforceJoinOrder(fldsQry.isEnforceJoinOrder()).setLocal(fldsQry.isLocal()).setPageSize(fldsQry.getPageSize()).setLazy(fldsQry.isLazy());
        if (!loc && !plan.isLocalSubquery()) {
            cur = this.executeSelectForDml(null, schema, selectFieldsQry, new StaticMvccQueryTracker(planCctx, mvccSnapshot), cancel, timeout);
        } else {
            selectFieldsQry.setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(schema, selectFieldsQry, false);
            final GridQueryFieldsResult res = this.executeSelectLocal(null, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), filter, new StaticMvccQueryTracker(planCctx, mvccSnapshot), cancel, true, timeout);
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return res.iterator();
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
            }, cancel, true, selectParseRes.queryParameters().lazy());
        }
        return plan.iteratorForTransaction(this.connections(), cur);
    }

    private Iterable<List<?>> executeSelectDistributed(final @Nullable Long qryId, final QueryDescriptor qryDesc, final QueryParameters qryParams, final GridCacheTwoStepQuery twoStepQry, final boolean keepBinary, final MvccQueryTracker mvccTracker, final GridQueryCancel cancel, final int timeout) {
        Iterable<List<?>> iter;
        PartitionResult derivedParts = twoStepQry.derivedPartitions();
        final int[] parts = PartitionResult.calculatePartitions(qryParams.partitions(), derivedParts, qryParams.arguments());
        if (parts != null && parts.length == 0) {
            iter = new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    return new Iterator<List<?>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public List<?> next() {
                            return null;
                        }
                    };
                }
            };
        } else {
            assert (!twoStepQry.mvccEnabled() || !F.isEmpty(twoStepQry.cacheIds()));
            assert (twoStepQry.mvccEnabled() == (mvccTracker != null));
            iter = new Iterable<List<?>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Iterator<List<?>> iterator() {
                    try (MTC.TraceSurroundings ignored = MTC.support(IgniteH2Indexing.this.ctx.tracing().create(SpanType.SQL_ITER_OPEN, MTC.span()));){
                        Iterator<List<?>> iterator = IgniteH2Indexing.this.rdcQryExec.query(qryId, qryDesc.label(), qryDesc.schemaName(), twoStepQry, keepBinary, qryDesc.enforceJoinOrder(), timeout, cancel, qryParams.arguments(), parts, qryParams.lazy(), mvccTracker, qryParams.dataPageScanEnabled(), qryParams.pageSize(), qryParams.maxMemory());
                        return iterator;
                    }
                    catch (Throwable e) {
                        if (mvccTracker == null) throw e;
                        mvccTracker.onDone();
                        throw e;
                    }
                }
            };
        }
        return iter;
    }

    public UpdateResult executeUpdateOnDataNode(String schemaName, SqlFieldsQuery qry, IndexingQueryFilter filter, GridQueryCancel cancel, boolean loc) throws IgniteCheckedException {
        QueryParserResult parseRes = this.parser.parse(schemaName, qry, false);
        assert (parseRes.remainingQuery() == null);
        QueryParserResultDml dml = parseRes.dml();
        assert (dml != null);
        return this.executeUpdate(null, parseRes.queryDescriptor(), parseRes.queryParameters(), dml, loc, filter, cancel);
    }

    @Override
    public boolean registerType(GridCacheContextInfo cacheInfo, GridQueryTypeDescriptor type, boolean isSql) throws IgniteCheckedException {
        H2Utils.validateTypeDescriptor(type);
        if (type.keyClass() == Object.class && F.isEmpty(type.primaryKeyFields())) {
            this.log.warning("Key of user type has no fields configured for table=" + type.tableName());
        }
        this.schemaMgr.onCacheTypeCreated(cacheInfo, this, type, isSql);
        return true;
    }

    @Override
    public GridCacheContextInfo registeredCacheInfo(String cacheName) {
        for (H2TableDescriptor tbl : this.schemaMgr.tablesForCache(cacheName)) {
            if (!F.eq(tbl.cacheName(), cacheName)) continue;
            return tbl.cacheInfo();
        }
        return null;
    }

    @Override
    public void closeCacheOnClient(String cacheName) {
        GridCacheContextInfo cacheInfo = this.registeredCacheInfo(cacheName);
        if (cacheInfo != null) {
            this.parser.clearCache();
            cacheInfo.clearCacheContext();
        }
    }

    @Override
    public String schema(String cacheName) {
        return this.schemaMgr.schemaName(cacheName);
    }

    @Override
    public Set<String> schemasNames() {
        return this.schemaMgr.schemaNames();
    }

    @Override
    public Collection<TableInformation> tablesInformation(String schemaNamePtrn, String tblNamePtrn, String ... tblTypes) {
        boolean allTypes;
        ArrayList<TableInformation> infos;
        HashSet<String> types;
        block5: {
            block4: {
                types = F.isEmpty(tblTypes) ? Collections.emptySet() : new HashSet<String>(Arrays.asList(tblTypes));
                infos = new ArrayList<TableInformation>();
                allTypes = F.isEmpty(tblTypes);
                if (allTypes) break block4;
                if (!types.contains(TableType.TABLE.name())) break block5;
            }
            this.schemaMgr.dataTables().stream().filter(t2 -> QueryUtils.matches(t2.getSchema().getName(), schemaNamePtrn)).filter(t2 -> QueryUtils.matches(t2.getName(), tblNamePtrn)).map(t2 -> {
                int cacheGrpId = t2.cacheInfo().groupId();
                CacheGroupDescriptor cacheGrpDesc = this.ctx.cache().cacheGroupDescriptors().get(cacheGrpId);
                if (cacheGrpDesc == null) {
                    return null;
                }
                GridQueryTypeDescriptor type = t2.rowDescriptor().type();
                IndexColumn affCol = t2.getExplicitAffinityKeyColumn();
                String affinityKeyCol = affCol != null ? affCol.columnName : null;
                return new TableInformation(t2.getSchema().getName(), t2.getName(), TableType.TABLE.name(), cacheGrpId, cacheGrpDesc.cacheOrGroupName(), t2.cacheId(), t2.cacheName(), affinityKeyCol, type.keyFieldAlias(), type.valueFieldAlias(), type.keyTypeName(), type.valueTypeName());
            }).filter(Objects::nonNull).forEach(infos::add);
        }
        if ((allTypes || types.contains(TableType.VIEW.name())) && QueryUtils.matches(QueryUtils.sysSchemaName(), schemaNamePtrn)) {
            this.schemaMgr.systemViews().stream().filter(t2 -> QueryUtils.matches(t2.getTableName(), tblNamePtrn)).map(v -> new TableInformation(QueryUtils.sysSchemaName(), v.getTableName(), TableType.VIEW.name())).forEach(infos::add);
        }
        return infos;
    }

    @Override
    public Collection<ColumnInformation> columnsInformation(String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        ArrayList<ColumnInformation> infos = new ArrayList<ColumnInformation>();
        this.schemaMgr.dataTables().stream().filter(t2 -> QueryUtils.matches(t2.getSchema().getName(), schemaNamePtrn)).filter(t2 -> QueryUtils.matches(t2.getName(), tblNamePtrn)).flatMap(tbl -> {
            IndexColumn affCol = tbl.getAffinityKeyColumn();
            return Stream.of(tbl.getColumns()).filter(Column::getVisible).filter(c -> QueryUtils.matches(c.getName(), colNamePtrn)).map(c -> {
                GridQueryProperty prop = tbl.rowDescriptor().type().property(c.getName());
                boolean isAff = affCol != null && c.getColumnId() == affCol.column.getColumnId();
                return new ColumnInformation(c.getColumnId() - 2 + 1, tbl.getSchema().getName(), tbl.getName(), c.getName(), prop.type(), c.isNullable(), prop.defaultValue(), H2Utils.resolveDefaultPrecisionIfUndefined(prop), H2Utils.resolveDefaultScaleIfUndefined(prop), isAff);
            });
        }).forEach(infos::add);
        if (QueryUtils.matches(QueryUtils.sysSchemaName(), schemaNamePtrn)) {
            this.schemaMgr.systemViews().stream().filter(v -> QueryUtils.matches(v.getTableName(), tblNamePtrn)).flatMap(view -> Stream.of(view.getColumns()).filter(c -> QueryUtils.matches(c.getName(), colNamePtrn)).map(c -> new ColumnInformation(c.getColumnId() + 1, QueryUtils.sysSchemaName(), view.getTableName(), c.getName(), IgniteUtils.classForName(DataType.getTypeClassName(c.getType().getValueType(), false), Object.class), c.isNullable(), null, (int)c.getType().getPrecision(), c.getType().getScale(), false))).forEach(infos::add);
        }
        return infos;
    }

    @Override
    public boolean isConvertibleToColumnType(String schemaName, String tblName, String colName, Class<?> cls) {
        GridH2Table table = this.schemaMgr.dataTable(schemaName, tblName);
        if (table == null) {
            throw new IgniteSQLException("Table was not found [schemaName=" + schemaName + ", tableName=" + tblName + ']');
        }
        try {
            return H2Utils.isConvertableToColumnType(cls, table.getColumn(colName).getType().getValueType());
        }
        catch (DbException e) {
            throw new IgniteSQLException("Colum with specified name was not found for the table [schemaName=" + schemaName + ", tableName=" + tblName + ", colName=" + colName + ']', e);
        }
    }

    @Override
    public boolean isStreamableInsertStatement(String schemaName, SqlFieldsQuery qry) throws SQLException {
        QueryParserResult parsed = this.parser.parse(schemaName, qry, true);
        return parsed.isDml() && parsed.dml().streamable() && parsed.remainingQuery() == null;
    }

    @Override
    public GridQueryRowCacheCleaner rowCacheCleaner(int grpId) {
        return this.rowCache.forGroup(grpId);
    }

    @Override
    public void markAsRebuildNeeded(GridCacheContext cctx) {
        assert (cctx.group().persistenceEnabled()) : cctx;
        this.markIndexRebuild(cctx.name(), true);
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> rebuildInMemoryIndexes(GridCacheContext cctx) {
        assert (cctx != null);
        if (this.ctx.clientNode()) {
            return null;
        }
        if (cctx.shared().pageStore() == null) {
            return null;
        }
        String cacheName = cctx.name();
        Collection descriptors = this.schemaMgr.tablesForCache(cacheName).stream().filter(descriptor -> Objects.nonNull(descriptor.luceneIndex())).collect(Collectors.toList());
        if (descriptors.isEmpty()) {
            return null;
        }
        GridFutureAdapter<Void> rebuildCacheIdxFut = new GridFutureAdapter<Void>();
        SchemaIndexCacheFuture intRebFut = new SchemaIndexCacheFuture(new SchemaIndexOperationCancellationToken());
        GridFutureAdapter outRebuildIdxFut = new GridFutureAdapter();
        SchemaIndexCacheFuture prevIntRebFut = this.idxRebuildFuts.put(cctx.cacheId(), intRebFut);
        assert (prevIntRebFut == null);
        TextIndexRebuildClosure clo = new TextIndexRebuildClosure(this.ctx.query(), cctx, descriptors);
        rebuildCacheIdxFut.listen(fut -> {
            Throwable err = fut.error();
            if (err == null) {
                try {
                    this.markIndexRebuild(cacheName, false);
                }
                catch (Throwable t2) {
                    err = t2;
                }
            }
            if (err != null) {
                U.error(this.log, "Failed to rebuild indexes for cache: " + cacheName, err);
            }
            this.idxRebuildFuts.remove(cctx.cacheId(), intRebFut);
            intRebFut.onDone(err);
            outRebuildIdxFut.onDone(err);
        });
        if (!rebuildCacheIdxFut.isDone()) {
            this.rebuildIndexesFromHash0(cctx, clo, rebuildCacheIdxFut, intRebFut.cancelToken());
        }
        return outRebuildIdxFut;
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> rebuildIndexesFromHash(GridCacheContext cctx, boolean force) {
        SchemaIndexCacheVisitorClosure clo;
        assert (cctx != null);
        if (!CU.affinityNode(cctx.localNode(), cctx.config().getNodeFilter())) {
            return null;
        }
        IgnitePageStoreManager pageStore = cctx.shared().pageStore();
        String cacheName = cctx.name();
        if (pageStore != null && pageStore.hasIndexStore(cctx.groupId()) && !force) {
            boolean required = false;
            for (H2TableDescriptor tblDesc : this.schemaMgr.tablesForCache(cacheName)) {
                GridH2Table tbl = tblDesc.table();
                assert (tbl != null);
                required = tbl.checkIfIndexesRebuildRequired();
                if (!required) continue;
                break;
            }
            if (!required) {
                return null;
            }
        }
        this.markIndexRebuild(cacheName, true);
        GridFutureAdapter<Void> rebuildCacheIdxFut = new GridFutureAdapter<Void>();
        GridFutureAdapter outRebuildCacheIdxFut = new GridFutureAdapter();
        if (cctx.group().metrics() != null) {
            cctx.group().metrics().addIndexBuildCountPartitionsLeft(cctx.topology().localPartitions().size());
        }
        SchemaIndexCacheFuture intRebFut = new SchemaIndexCacheFuture(new SchemaIndexOperationCancellationToken());
        SchemaIndexCacheFuture prevIntRebFut = this.idxRebuildFuts.put(cctx.cacheId(), intRebFut);
        assert (prevIntRebFut == null);
        cctx.kernalContext().query().onStartRebuildIndexes(cctx);
        try {
            this.prepareIndexesForRebuild(cacheName);
        }
        catch (IgniteCheckedException e) {
            rebuildCacheIdxFut.onDone(e);
        }
        if (pageStore == null || !pageStore.hasIndexStore(cctx.groupId())) {
            clo = new IndexRebuildFullClosure(cctx.queries(), cctx.mvccEnabled());
        } else {
            IndexRebuildPartialClosure clo0 = new IndexRebuildPartialClosure(cctx);
            for (H2TableDescriptor tblDesc : this.schemaMgr.tablesForCache(cacheName)) {
                GridH2Table tbl = tblDesc.table();
                assert (tbl != null);
                tbl.collectIndexesForPartialRebuild(clo0, force);
            }
            clo = clo0;
        }
        rebuildCacheIdxFut.listen(fut -> {
            Throwable err = fut.error();
            if (err == null) {
                try {
                    this.markIndexRebuild(cacheName, false);
                }
                catch (Throwable t2) {
                    err = t2;
                }
            }
            if (err != null) {
                U.error(this.log, "Failed to rebuild indexes for cache: " + cacheName, err);
            } else {
                cctx.kernalContext().query().onFinishRebuildIndexes(cctx);
            }
            this.idxRebuildFuts.remove(cctx.cacheId(), intRebFut);
            intRebFut.onDone(err);
            outRebuildCacheIdxFut.onDone(err);
        });
        if (!rebuildCacheIdxFut.isDone()) {
            this.rebuildIndexesFromHash0(cctx, clo, rebuildCacheIdxFut, intRebFut.cancelToken());
        }
        return outRebuildCacheIdxFut;
    }

    protected void rebuildIndexesFromHash0(GridCacheContext cctx, SchemaIndexCacheVisitorClosure clo, GridFutureAdapter<Void> rebuildIdxFut, SchemaIndexOperationCancellationToken cancel) {
        new SchemaIndexCacheVisitorImpl(cctx, cancel, rebuildIdxFut).visit(clo);
    }

    private void markIndexRebuild(String cacheName, boolean val) {
        for (H2TableDescriptor tblDesc : this.schemaMgr.tablesForCache(cacheName)) {
            assert (tblDesc.table() != null);
            tblDesc.table().markRebuildFromHashInProgress(val);
        }
    }

    private void prepareIndexesForRebuild(String cacheName) throws IgniteCheckedException {
        try (H2PooledConnection conn = this.connMgr.connection();){
            for (H2TableDescriptor tblDesc : this.schemaMgr.tablesForCache(cacheName)) {
                assert (tblDesc.table() != null);
                tblDesc.table().prepareIndexesForRebuild(H2Utils.session(conn));
            }
        }
    }

    public GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    public RunningQueryManager runningQueryManager() {
        return this.runningQryMgr;
    }

    public QueryMemoryManager memoryManager() {
        return this.memoryMgr;
    }

    @Override
    public void start(GridKernalContext ctx, GridSpinBusyLock busyLock) throws IgniteCheckedException {
        JavaObjectSerializer h2Serializer;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        this.busyLock = busyLock;
        if (SysProperties.serializeJavaObject) {
            U.warn(this.log, "Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        this.ctx = ctx;
        this.partReservationMgr = new PartitionReservationManager(ctx);
        this.connMgr = new ConnectionManager(ctx);
        this.longRunningQryMgr = new LongRunningQueryManager(ctx);
        this.parser = new QueryParser(this, this.connections());
        this.schemaMgr = new SchemaManager(ctx, this.connections());
        this.schemaMgr.start(ctx.config().getSqlConfiguration().getSqlSchemas());
        this.statsMgr = new IgniteStatisticsManagerImpl(ctx, this.schemaMgr);
        this.nodeId = ctx.localNodeId();
        this.marshaller = ctx.config().getMarshaller();
        this.memoryMgr = new QueryMemoryManager(ctx);
        this.runningQryMgr = new RunningQueryManager(ctx);
        this.mapQryExec = new GridMapQueryExecutor();
        this.rdcQryExec = new GridReduceQueryExecutor();
        this.mapQryExec.start(ctx, this);
        this.rdcQryExec.start(ctx, this);
        this.discoLsnr = evt -> {
            this.mapQryExec.onNodeLeft((DiscoveryEvent)evt);
            this.rdcQryExec.onNodeLeft((DiscoveryEvent)evt);
        };
        ctx.event().addLocalEventListener(this.discoLsnr, 12, 11);
        this.qryLsnr = (nodeId, msg, plc) -> this.onMessage(nodeId, msg);
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, this.qryLsnr);
        this.partExtractor = new PartitionExtractor(new H2PartitionResolver(this), ctx);
        this.cmdProc = new CommandProcessor(ctx, this.schemaMgr, this);
        this.cmdProc.start();
        if (JdbcUtils.serializer != null) {
            U.warn(this.log, "Custom H2 serialization is already configured, will override.");
        }
        JdbcUtils.serializer = h2Serializer = this.h2Serializer();
        this.connMgr.setH2Serializer(h2Serializer);
        this.registerAggregateFunctions();
        this.registerSqlFunctions();
        this.distrCfg = new DistributedSqlConfiguration(ctx, this.log);
        this.distrCfg.listenDisabledFunctions(new FunctionsManager());
        ctx.maintenanceRegistry().registerWorkflowCallbackIfTaskExists(INDEX_REBUILD_MNTC_TASK_NAME, task -> new RebuildIndexWorkflowCallback(MaintenanceRebuildIndexUtils.parseMaintenanceTaskParameters(task.parameters()), this, this.log));
    }

    @Override
    public void onKernalStart() {
        this.memoryMgr.cleanSpillDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(UUID nodeId, Object msg) {
        assert (msg != null);
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (msg instanceof GridCacheQueryMarshallable) {
                ((GridCacheQueryMarshallable)msg).unmarshall(this.ctx.config().getMarshaller(), this.ctx);
            }
            try {
                boolean processed = true;
                boolean tracebleMsg = false;
                if (msg instanceof GridQueryNextPageRequest) {
                    this.mapQueryExecutor().onNextPageRequest(node, (GridQueryNextPageRequest)msg);
                    tracebleMsg = true;
                } else if (msg instanceof GridQueryNextPageResponse) {
                    this.reduceQueryExecutor().onNextPage(node, (GridQueryNextPageResponse)msg);
                    tracebleMsg = true;
                } else if (msg instanceof GridH2QueryRequest) {
                    this.mapQueryExecutor().onQueryRequest(node, (GridH2QueryRequest)msg);
                } else if (msg instanceof GridH2DmlRequest) {
                    this.mapQueryExecutor().onDmlRequest(node, (GridH2DmlRequest)msg);
                } else if (msg instanceof GridH2DmlResponse) {
                    this.reduceQueryExecutor().onDmlResponse(node, (GridH2DmlResponse)msg);
                } else if (msg instanceof GridQueryFailResponse) {
                    this.reduceQueryExecutor().onFail(node, (GridQueryFailResponse)msg);
                } else if (msg instanceof GridQueryCancelRequest) {
                    this.mapQueryExecutor().onCancel(node, (GridQueryCancelRequest)msg);
                } else {
                    processed = false;
                }
                if (processed && this.log.isDebugEnabled() && (!tracebleMsg || this.log.isTraceEnabled())) {
                    this.log.debug("Processed message: [srcNodeId=" + nodeId + ", msg=" + msg + ']');
                }
            }
            catch (Throwable th) {
                U.error(this.log, "Failed to process message: [srcNodeId=" + nodeId + ", msg=" + msg + ']', th);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CacheObjectValueContext objectContext() {
        return this.ctx.query().objectContext();
    }

    public boolean send(Object topic, int topicOrd, Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, final @Nullable IgniteInClosure2X<ClusterNode, Message> locNodeHnd, byte plc, boolean runLocParallel) {
        boolean ok = true;
        if (specialize == null && msg instanceof GridCacheQueryMarshallable) {
            ((GridCacheQueryMarshallable)((Object)msg)).marshall(this.marshaller);
        }
        ClusterNode locNode = null;
        for (ClusterNode node : nodes) {
            if (node.isLocal()) {
                if (locNode != null) {
                    throw new IllegalStateException();
                }
                locNode = node;
                continue;
            }
            try {
                if (specialize != null && (msg = specialize.apply(node, msg)) instanceof GridCacheQueryMarshallable) {
                    ((GridCacheQueryMarshallable)((Object)msg)).marshall(this.marshaller);
                }
                this.ctx.io().sendGeneric(node, topic, topicOrd, msg, plc);
            }
            catch (IgniteCheckedException e) {
                ok = false;
                U.warn(this.log, "Failed to send message [node=" + node + ", msg=" + msg + ", errMsg=" + e.getMessage() + "]");
            }
        }
        if (locNode != null) {
            assert (locNodeHnd != null);
            if (specialize != null && (msg = specialize.apply(locNode, msg)) instanceof GridCacheQueryMarshallable) {
                ((GridCacheQueryMarshallable)((Object)msg)).marshall(this.marshaller);
            }
            if (runLocParallel) {
                final ClusterNode finalLocNode = locNode;
                final Message finalMsg = msg;
                try {
                    this.ctx.closure().runLocal(new GridPlainRunnable(){

                        @Override
                        public void run() {
                            if (!IgniteH2Indexing.this.busyLock.enterBusy()) {
                                return;
                            }
                            try {
                                locNodeHnd.apply(finalLocNode, finalMsg);
                            }
                            finally {
                                IgniteH2Indexing.this.busyLock.leaveBusy();
                            }
                        }
                    }, plc).listen(this.logger);
                }
                catch (IgniteCheckedException e) {
                    ok = false;
                    U.error(this.log, "Failed to execute query locally.", e);
                }
            } else {
                locNodeHnd.apply(locNode, msg);
            }
        }
        return ok;
    }

    private JavaObjectSerializer h2Serializer() {
        return new H2JavaObjectSerializer(this.ctx);
    }

    public DataHandler dataHandler() {
        return this.connMgr.dataHandler();
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        if (this.mapQryExec != null) {
            this.mapQryExec.stop();
        }
        this.qryCtxRegistry.clearSharedOnLocalNodeStop();
        if (this.runningQryMgr != null) {
            this.runningQryMgr.stop();
        }
        if (this.schemaMgr != null) {
            this.schemaMgr.stop();
        }
        if (this.longRunningQryMgr != null) {
            this.longRunningQryMgr.stop();
        }
        if (this.connMgr != null) {
            this.connMgr.stop();
        }
        if (this.connMgr != null) {
            this.cmdProc.stop();
        }
        this.memoryMgr.close();
        this.statsMgr.stop();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
    }

    @Override
    public void onClientDisconnect() throws IgniteCheckedException {
        if (!MvccUtils.mvccEnabled(this.ctx)) {
            return;
        }
        GridNearTxLocal tx = MvccUtils.tx(this.ctx);
        if (tx != null) {
            this.cmdProc.doRollback(tx);
        }
    }

    @Override
    public boolean initCacheContext(GridCacheContext cacheCtx) {
        GridCacheContextInfo cacheInfo = this.registeredCacheInfo(cacheCtx.name());
        if (cacheInfo != null) {
            assert (!cacheInfo.isCacheContextInited()) : cacheInfo.name();
            assert (cacheInfo.name().equals(cacheCtx.name())) : cacheInfo.name() + " != " + cacheCtx.name();
            cacheInfo.initCacheContext(cacheCtx);
            return true;
        }
        return false;
    }

    @Override
    public void registerCache(String cacheName, String schemaName, GridCacheContextInfo<?, ?> cacheInfo) throws IgniteCheckedException {
        this.rowCache.onCacheRegistered(cacheInfo);
        this.schemaMgr.onCacheCreated(cacheName, schemaName, cacheInfo.config().getSqlFunctionClasses());
    }

    @Override
    public void unregisterCache(GridCacheContextInfo cacheInfo, boolean destroy, boolean clearIdx) {
        this.cancelIndexRebuildFuture(this.idxRebuildFuts.remove(cacheInfo.cacheId()));
        this.rowCache.onCacheUnregistered(cacheInfo);
        String cacheName = cacheInfo.name();
        this.partReservationMgr.onCacheStop(cacheName);
        this.schemaMgr.onCacheDestroyed(cacheName, destroy, clearIdx);
        this.connMgr.onCacheDestroyed();
        this.clearPlanCache();
    }

    @Override
    public void destroyOrphanIndex(RootPage page, String indexName, int grpId, PageMemory pageMemory, GridAtomicLong removeId, ReuseList reuseList, boolean mvccEnabled) throws IgniteCheckedException {
        assert (this.ctx.cache().context().database().checkpointLockIsHeldByThread());
        long metaPageId = page.pageId().pageId();
        int inlineSize = this.getInlineSize(page, grpId, pageMemory);
        String grpName = this.ctx.cache().cacheGroup(grpId).cacheOrGroupName();
        BPlusTree<H2Row, H2Row> tree = new BPlusTree<H2Row, H2Row>(grpName + "IndexTree##" + indexName, grpId, grpName, pageMemory, this.ctx.cache().context().wal(), (AtomicLong)removeId, metaPageId, reuseList, H2ExtrasInnerIO.getVersions(inlineSize, mvccEnabled), H2ExtrasLeafIO.getVersions(inlineSize, mvccEnabled), 2, this.ctx.failure(), this.ctx.cache().context().diagnostic().pageLockTracker()){

            @Override
            protected int compare(BPlusIO<H2Row> io, long pageAddr, int idx, H2Row row) {
                throw new AssertionError();
            }

            @Override
            public H2Row getRow(BPlusIO<H2Row> io, long pageAddr, int idx, Object x) {
                throw new AssertionError();
            }
        };
        tree.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInlineSize(RootPage page, int grpId, PageMemory pageMemory) throws IgniteCheckedException {
        long metaPageId = page.pageId().pageId();
        long metaPage = pageMemory.acquirePage(grpId, metaPageId);
        try {
            int n;
            long pageAddr = pageMemory.readLock(grpId, metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong(metaPageId) + ']';
            try {
                BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
                n = io.getInlineSize(pageAddr);
            }
            catch (Throwable throwable) {
                pageMemory.readUnlock(grpId, metaPageId, metaPage);
                throw throwable;
            }
            pageMemory.readUnlock(grpId, metaPageId, metaPage);
            return n;
        }
        finally {
            pageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }

    private void clearPlanCache() {
        this.parser.clearCache();
    }

    @Override
    public IndexingQueryFilter backupFilter(@Nullable AffinityTopologyVersion topVer, @Nullable int[] parts) {
        return this.backupFilter(topVer, parts, false);
    }

    public IndexingQueryFilter backupFilter(@Nullable AffinityTopologyVersion topVer, @Nullable int[] parts, boolean treatReplicatedAsPartitioned) {
        return new IndexingQueryFilterImpl(this.ctx, topVer, parts, treatReplicatedAsPartitioned);
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.ctx.cache().context().exchange().readyAffinityVersion();
    }

    public boolean serverTopologyChanged(AffinityTopologyVersion readyVer) {
        GridDhtPartitionsExchangeFuture fut = this.ctx.cache().context().exchange().lastTopologyFuture();
        if (fut.isDone()) {
            return false;
        }
        AffinityTopologyVersion initVer = fut.initialVersion();
        return initVer.compareTo(readyVer) > 0 && !fut.firstEvent().node().isClient();
    }

    public void awaitForReadyTopologyVersion(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        this.ctx.cache().context().exchange().affinityReadyFuture(topVer).get();
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.rdcQryExec.onDisconnected(reconnectFut);
        this.cmdProc.onDisconnected();
    }

    public List<GridRunningQueryInfo> runningSqlQueries() {
        return this.runningQryMgr.runningSqlQueries();
    }

    @Override
    public Collection<GridRunningQueryInfo> runningQueries(long duration) {
        return this.runningQryMgr.longRunningQueries(duration);
    }

    @Override
    public void cancelQueries(Collection<Long> queries) {
        if (!F.isEmpty(queries)) {
            for (Long qryId : queries) {
                this.runningQryMgr.cancel(qryId);
            }
        }
    }

    @Override
    public void onKernalStop() {
        this.connMgr.onKernalStop();
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_QUERY, this.qryLsnr);
        this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
    }

    public QueryContextRegistry queryContextRegistry() {
        return this.qryCtxRegistry;
    }

    public ConnectionManager connections() {
        return this.connMgr;
    }

    public QueryParser parser() {
        return this.parser;
    }

    public SchemaManager schemaManager() {
        return this.schemaMgr;
    }

    public PartitionExtractor partitionExtractor() {
        return this.partExtractor;
    }

    public PartitionReservationManager partitionReservationManager() {
        return this.partReservationMgr;
    }

    public H2MemoryTracker memoryTrackerForQry(Long qryId) {
        if (qryId == null) {
            return null;
        }
        GridRunningQueryInfo info = this.runningQryMgr.runningQueryInfo(qryId);
        if (info == null) {
            return null;
        }
        GridQueryMemoryMetricProvider memTracker = info.memoryMetricProvider();
        assert (memTracker == null || memTracker instanceof H2MemoryTracker) : "Memory tracker either should be null or should be instance of " + H2MemoryTracker.class.getName() + ", but it is " + memTracker.getClass().getName();
        return (H2MemoryTracker)((Object)memTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryCursorImpl<List<?>>> executeUpdateDistributed(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, GridQueryCancel cancel) throws IgniteCheckedException {
        if (qryDesc.batched()) {
            List<Object> ress;
            List<Object[]> argss = qryParams.batchedArguments();
            UpdatePlan plan = dml.plan();
            GridCacheContext cctx = plan.cacheContext();
            if (plan.hasRows() && plan.mode() == UpdateMode.INSERT && !cctx.mvccEnabled()) {
                CacheOperationContext opCtx = DmlUtils.setKeepBinaryContext(cctx);
                try {
                    List<List<List<?>>> cur = plan.createRows(argss);
                    ress = DmlUtils.processSelectResultBatched(plan, cur, qryParams.updateBatchSize());
                }
                finally {
                    DmlUtils.restoreKeepBinaryContext(cctx, opCtx);
                }
            } else {
                ress = new ArrayList(argss.size());
                Throwable batchException = null;
                int[] cntPerRow = new int[argss.size()];
                boolean bl = false;
                for (Object[] args : argss) {
                    try {
                        UpdateResult res = this.executeUpdate(qryId, qryDesc, qryParams.toSingleBatchedArguments(args), dml, false, null, cancel);
                        cntPerRow[var12_16++] = (int)res.counter();
                        ress.add(res);
                    }
                    catch (Exception e) {
                        SQLException sqlEx = QueryUtils.toSqlException(e);
                        batchException = DmlUtils.chainException((SQLException)batchException, sqlEx);
                        cntPerRow[var12_16++] = -3;
                    }
                }
                if (batchException != null) {
                    BatchUpdateException e = new BatchUpdateException(batchException.getMessage(), ((SQLException)batchException).getSQLState(), ((SQLException)batchException).getErrorCode(), cntPerRow, batchException);
                    throw new IgniteCheckedException(e);
                }
            }
            ArrayList resCurs = new ArrayList(ress.size());
            for (UpdateResult updateResult : ress) {
                updateResult.throwIfError();
                QueryCursorImpl<List<Long>> resCur = new QueryCursorImpl<List<Long>>(Collections.singletonList(Collections.singletonList(updateResult.counter())), cancel, false, false);
                resCur.fieldsMeta(H2Utils.UPDATE_RESULT_META);
                resCurs.add(resCur);
            }
            return resCurs;
        }
        UpdateResult res = this.executeUpdate(qryId, qryDesc, qryParams, dml, false, null, cancel);
        res.throwIfError();
        QueryCursorImpl<List<Long>> resCur = new QueryCursorImpl<List<Long>>(Collections.singletonList(Collections.singletonList(res.counter())), cancel, false, false);
        resCur.fieldsMeta(H2Utils.UPDATE_RESULT_META);
        resCur.partitionResult(res.partitionResult());
        return Collections.singletonList(resCur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult executeUpdate(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        Object[] errKeys = null;
        long items = 0L;
        PartitionResult partRes = null;
        GridCacheContext cctx = dml.plan().cacheContext();
        boolean transactional = cctx != null && cctx.mvccEnabled();
        int maxRetryCnt = transactional ? 1 : 4;
        for (int i = 0; i < maxRetryCnt; ++i) {
            UpdateResult r;
            CacheOperationContext opCtx = cctx != null ? DmlUtils.setKeepBinaryContext(cctx) : null;
            try {
                r = transactional ? this.executeUpdateTransactional(qryId, qryDesc, qryParams, dml, loc, cancel) : this.executeUpdateNonTransactional(qryId, qryDesc, qryParams, dml, loc, filters, cancel);
            }
            finally {
                if (opCtx != null) {
                    DmlUtils.restoreKeepBinaryContext(cctx, opCtx);
                }
            }
            items += r.counter();
            errKeys = r.errorKeys();
            partRes = r.partitionResult();
            if (F.isEmpty(errKeys)) break;
        }
        if (F.isEmpty(errKeys) && partRes == null) {
            if (items == 1L) {
                return UpdateResult.ONE;
            }
            if (items == 0L) {
                return UpdateResult.ZERO;
            }
        }
        return new UpdateResult(items, errKeys, partRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult executeUpdateNonTransactional(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        Iterable<List<Object>> cur;
        GridQueryCancel selectCancel;
        DmlDistributedPlanInfo distributedPlan;
        UpdatePlan plan = dml.plan();
        UpdateResult fastUpdateRes = plan.processFast(qryParams.arguments());
        if (fastUpdateRes != null) {
            return fastUpdateRes;
        }
        DmlDistributedPlanInfo dmlDistributedPlanInfo = distributedPlan = loc ? null : plan.distributedPlan();
        if (distributedPlan != null) {
            UpdateResult result;
            if (cancel == null) {
                cancel = new GridQueryCancel();
            }
            if ((result = this.rdcQryExec.update(qryDesc.schemaName(), distributedPlan.getCacheIds(), qryDesc.sql(), qryParams.arguments(), qryDesc.enforceJoinOrder(), qryParams.pageSize(), qryParams.timeout(), qryParams.partitions(), distributedPlan.isReplicatedOnly(), cancel)) != null) {
                return result;
            }
        }
        GridQueryCancel gridQueryCancel = selectCancel = cancel != null ? new GridQueryCancel() : null;
        if (cancel != null) {
            cancel.add(selectCancel::cancel);
        }
        SqlFieldsQuery selectFieldsQry = new SqlFieldsQueryEx(plan.selectQuery() == null ? "" : plan.selectQuery(), (Boolean)true).setCollocated(qryDesc.collocated()).setArgs(qryParams.arguments()).setDistributedJoins(qryDesc.distributedJoins()).setEnforceJoinOrder(qryDesc.enforceJoinOrder()).setLocal(qryDesc.local()).setPageSize(qryParams.pageSize()).setTimeout(qryParams.timeout(), TimeUnit.MILLISECONDS).setMaxMemory(qryParams.maxMemory()).setLazy(qryParams.lazy() && plan.canSelectBeLazy()).setLabel(qryDesc.label());
        if (!loc && !plan.isLocalSubquery()) {
            assert (!F.isEmpty(plan.selectQuery()));
            cur = this.executeSelectForDml(qryId, qryDesc.schemaName(), selectFieldsQry, null, selectCancel, qryParams.timeout());
        } else if (plan.hasRows()) {
            cur = plan.createRows(qryParams.arguments());
        } else {
            selectFieldsQry.setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(qryDesc.schemaName(), selectFieldsQry, false);
            final GridQueryFieldsResult res = this.executeSelectLocal(qryId, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), filters, null, selectCancel, false, qryParams.timeout());
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return new GridQueryCacheObjectsIterator(res.iterator(), IgniteH2Indexing.this.objectContext(), true);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
            }, cancel, true, qryParams.lazy());
        }
        int pageSize = qryParams.updateBatchSize();
        try {
            UpdateResult updateResult = DmlUtils.processSelectResult(plan, cur, pageSize);
            return updateResult;
        }
        finally {
            if (cur instanceof AutoCloseable) {
                U.closeQuiet((AutoCloseable)((Object)cur));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private UpdateResult executeUpdateTransactional(@Nullable Long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, GridQueryCancel cancel) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void registerMxBeans(IgniteMBeansManager mbMgr) throws IgniteCheckedException {
        SqlQueryMXBeanImpl qryMXBean = new SqlQueryMXBeanImpl(this.ctx);
        mbMgr.registerMBean("SQL Query", qryMXBean.getClass().getSimpleName(), qryMXBean, SqlQueryMXBean.class);
    }

    public LongRunningQueryManager longRunningQueries() {
        return this.longRunningQryMgr;
    }

    @Override
    public long indexSize(String schemaName, String tblName, String idxName) throws IgniteCheckedException {
        GridH2Table tbl = this.schemaMgr.dataTable(schemaName, tblName);
        if (tbl == null) {
            return 0L;
        }
        H2TreeIndex idx = (H2TreeIndex)tbl.userIndex(idxName);
        return idx == null ? 0L : idx.size();
    }

    private void registerAggregateFunctions() throws IgniteCheckedException {
        H2Utils.registerAggregateFunction(this.log, this.connMgr, "FIRSTVALUE", GridFirstValueFunction.class);
        H2Utils.registerAggregateFunction(this.log, this.connMgr, "LASTVALUE", GridLastValueFunction.class);
    }

    private void registerSqlFunctions() throws IgniteCheckedException {
        SqlPluginExtension[] ext = (SqlPluginExtension[])this.ctx.plugins().extensions(SqlPluginExtension.class);
        if (Objects.nonNull(ext)) {
            for (SqlPluginExtension e : ext) {
                H2Utils.registerSqlFunctions(this.log, this.connMgr, "PUBLIC", e.getSqlFunctions());
            }
        }
    }

    public DistributedSqlConfiguration distributedConfiguration() {
        return this.distrCfg;
    }

    @Override
    public Map<String, Integer> secondaryIndexesInlineSize() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (GridH2Table table : this.schemaMgr.dataTables()) {
            for (Index index : table.getIndexes()) {
                if (!(index instanceof H2TreeIndexBase) || index.getIndexType().isPrimaryKey()) continue;
                map.put(index.getSchema().getName() + "#" + index.getTable().getName() + "#" + index.getName(), ((H2TreeIndexBase)index).inlineSize());
            }
        }
        return map;
    }

    public IgniteStatisticsManager statsManager() {
        return this.statsMgr;
    }

    @Override
    public void defragment(CacheGroupContext grpCtx, CacheGroupContext newCtx, PageMemoryEx partPageMem, IntMap<LinkMap> mappingByPart, CheckpointTimeoutLock cpLock, Runnable cancellationChecker, IgniteThreadPoolExecutor defragmentationThreadPool) throws IgniteCheckedException {
        this.defragmentation.defragment(grpCtx, newCtx, partPageMem, mappingByPart, cpLock, cancellationChecker, this.log, defragmentationThreadPool);
    }

    @Override
    public void markIndexRenamed(GridCacheContext<?, ?> cacheCtx, String indexTreeName) {
        Collection<H2TableDescriptor> descriptors = this.schemaManager().tablesForCache(cacheCtx.name());
        block0: for (H2TableDescriptor descriptor : descriptors) {
            GridH2Table tbl = descriptor.table();
            for (Index index : tbl.getIndexes()) {
                H2TreeIndex treeIndex;
                if (!(index instanceof H2TreeIndex) || !indexTreeName.equals((treeIndex = (H2TreeIndex)index).treeName())) continue;
                treeIndex.markRenamed();
                continue block0;
            }
        }
    }

    private void cancelIndexRebuildFuture(@Nullable SchemaIndexCacheFuture rebFut) {
        block3: {
            if (rebFut != null && !rebFut.isDone() && rebFut.cancelToken().cancel()) {
                try {
                    rebFut.get();
                }
                catch (IgniteCheckedException e) {
                    if (e instanceof SchemaIndexOperationCancellationException) break block3;
                    this.log.warning("Error after canceling index rebuild.", e);
                }
            }
        }
    }

    private static /* synthetic */ String lambda$executeSqlQueryWithTimer$1(String sql) {
        return sql;
    }

    static {
        PageIO.registerH2(H2InnerIO.VERSIONS, H2LeafIO.VERSIONS, H2MvccInnerIO.VERSIONS, H2MvccLeafIO.VERSIONS);
        H2ExtrasInnerIO.register();
        H2ExtrasLeafIO.register();
    }
}

