/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.util.typedef.F;
import org.jsr166.ConcurrentLinkedHashMap;

public class H2RowCache
implements GridQueryRowCacheCleaner {
    private final ConcurrentLinkedHashMap<Long, H2CacheRow> rows;
    private final CacheGroupContext grpCtx;
    private int usageCnt = 1;

    public H2RowCache(CacheGroupContext grpCtx, int maxSize) {
        this.grpCtx = grpCtx;
        this.rows = new ConcurrentLinkedHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors(), maxSize);
    }

    public H2CacheRow get(long link) throws IgniteCheckedException {
        H2CacheRow row = this.rows.get(link);
        if (row != null) {
            this.touch(link);
        }
        return row;
    }

    public void put(H2CacheRow row) {
        this.rows.put(row.link(), row);
    }

    @Override
    public void remove(long link) {
        this.rows.remove(link);
    }

    public void onCacheRegistered() {
        ++this.usageCnt;
    }

    public boolean onCacheUnregistered(GridCacheContextInfo cacheInfo) {
        boolean res = --this.usageCnt == 0;
        this.clearForCache(cacheInfo);
        return res;
    }

    public int size() {
        return this.rows.size();
    }

    private void clearForCache(GridCacheContextInfo cacheInfo) {
        int cacheId = cacheInfo.cacheId();
        Iterator<Map.Entry<Long, H2CacheRow>> iter = this.rows.entrySet().iterator();
        while (iter.hasNext()) {
            H2CacheRow row = iter.next().getValue();
            if (!F.eq(cacheId, row.cacheId())) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touch(long link) throws IgniteCheckedException {
        PageMemory mem = this.grpCtx.dataRegion().pageMemory();
        int grpId = this.grpCtx.groupId();
        long pageId = PageIdUtils.pageId(link);
        long page = mem.acquirePage(grpId, pageId);
        try {
            mem.readLock(grpId, pageId, page);
            mem.readUnlock(grpId, pageId, page);
        }
        finally {
            mem.releasePage(grpId, pageId, page);
        }
    }
}

