/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.engine.Session;
import org.jetbrains.annotations.Nullable;

public class H2QueryInfo {
    @Nullable
    private final Long runningQryId;
    @Nullable
    private final String label;
    private final QueryType type;
    private final long beginTs;
    private final String schema;
    private final String sql;
    private final boolean enforceJoinOrder;
    private final boolean distributedJoin;
    private final boolean lazy;
    private final PreparedStatement stmt;
    private final UUID node;

    public H2QueryInfo(QueryType type, PreparedStatement stmt, String sql, ClusterNode node, @Nullable Long runningQryId, @Nullable String label) {
        try {
            assert (stmt != null);
            this.type = type;
            this.sql = sql;
            this.node = node.id();
            this.runningQryId = runningQryId;
            this.beginTs = U.currentTimeMillis();
            this.schema = stmt.getConnection().getSchema();
            Session s2 = H2Utils.session(stmt.getConnection());
            this.enforceJoinOrder = s2.isForceJoinOrder();
            this.distributedJoin = s2.isJoinBatchEnabled();
            this.lazy = s2.isLazyQueryExecution();
            this.stmt = stmt;
            this.label = label;
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Cannot collect query info", 1, e);
        }
    }

    protected void printInfo(StringBuilder msg) {
    }

    public long time() {
        return U.currentTimeMillis() - this.beginTs;
    }

    public Long runningQueryId() {
        return this.runningQryId;
    }

    public UUID node() {
        return this.node;
    }

    public QueryType type() {
        return this.type;
    }

    public void printLogMessage(IgniteLogger log, String msg, String additionalInfo) {
        String globalQueryId = this.runningQryId == null ? "(unknown)" : QueryUtils.globalQueryId(this.node, this.runningQryId);
        StringBuilder msgSb = new StringBuilder(msg).append(" [globalQueryId=").append(globalQueryId);
        if (this.label != null) {
            msgSb.append(", label=").append(this.label);
        }
        if (additionalInfo != null) {
            msgSb.append(", ").append(additionalInfo);
        }
        msgSb.append(", duration=").append(this.time()).append("ms").append(", type=").append((Object)this.type).append(", distributedJoin=").append(this.distributedJoin).append(", enforceJoinOrder=").append(this.enforceJoinOrder).append(", lazy=").append(this.lazy).append(", schema=").append(this.schema).append(", sql='").append(this.sql).append("', plan=").append(GridSqlQueryParser.prepared(this.stmt).getPlanSQL(false));
        this.printInfo(msgSb);
        msgSb.append(']');
        String throttleKey = globalQueryId + "#" + (this.runningQryId == null ? this.sql : this.type);
        LT.warn(log, throttleKey, msgSb.toString());
    }

    public String description() {
        return "H2QueryInfo [type=" + (Object)((Object)this.type) + ", globalQueryId=" + QueryUtils.globalQueryId(this.node, this.runningQryId) + ", beginTs=" + this.beginTs + ", distributedJoin=" + this.distributedJoin + ", enforceJoinOrder=" + this.enforceJoinOrder + ", lazy=" + this.lazy + ", schema=" + this.schema + ", sql='" + this.sql + "']";
    }

    public static enum QueryType {
        LOCAL,
        MAP,
        REDUCE;

    }
}

