/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;

public class DmlStatementsProcessor {
    private static final IgniteProductVersion RMV_ANON_CLS_POS_CHANGED_SINCE = IgniteProductVersion.fromString("2.7.0");
    private static final Runnable DUMMY_1 = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Runnable DUMMY_2 = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Runnable DUMMY_3 = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final IgniteInClosure<MutableEntry<Object, Object>> RMV_OLD = new IgniteInClosure<MutableEntry<Object, Object>>(){

        @Override
        public void apply(MutableEntry<Object, Object> e) {
            e.remove();
        }
    };
    private static final IgniteInClosure<MutableEntry<Object, Object>> RMV = new IgniteInClosure<MutableEntry<Object, Object>>(){

        @Override
        public void apply(MutableEntry<Object, Object> e) {
            e.remove();
        }
    };

    public static IgniteInClosure<MutableEntry<Object, Object>> getRemoveClosure(ClusterNode node, Object key) {
        assert (node != null);
        assert (key != null);
        IgniteInClosure<MutableEntry<Object, Object>> rmvC = RMV;
        if (node.version().compareTo(RMV_ANON_CLS_POS_CHANGED_SINCE) < 0) {
            rmvC = RMV_OLD;
        }
        return rmvC;
    }

    public static final class EntryValueUpdater
    implements IgniteInClosure<MutableEntry<Object, Object>> {
        private final Object val;

        public EntryValueUpdater(Object val) {
            assert (val != null);
            this.val = val;
        }

        @Override
        public void apply(MutableEntry<Object, Object> e) {
            e.setValue(this.val);
        }
    }

    public static final class ModifyingEntryProcessor
    implements EntryProcessor<Object, Object, Boolean> {
        private final Object val;
        private final IgniteInClosure<MutableEntry<Object, Object>> entryModifier;

        public ModifyingEntryProcessor(Object val, IgniteInClosure<MutableEntry<Object, Object>> entryModifier) {
            assert (val != null);
            this.val = val;
            this.entryModifier = entryModifier;
        }

        @Override
        public Boolean process(MutableEntry<Object, Object> entry, Object ... arguments) throws EntryProcessorException {
            if (!entry.exists()) {
                return null;
            }
            Object entryVal = entry.getValue();
            if (entryVal == null) {
                return null;
            }
            if (!F.eq(entryVal, this.val)) {
                return false;
            }
            this.entryModifier.apply(entry);
            return null;
        }
    }

    public static final class InsertEntryProcessor
    implements EntryProcessor<Object, Object, Boolean> {
        private final Object val;

        public InsertEntryProcessor(Object val) {
            this.val = val;
        }

        @Override
        public Boolean process(MutableEntry<Object, Object> entry, Object ... arguments) throws EntryProcessorException {
            if (entry.exists()) {
                return false;
            }
            entry.setValue(this.val);
            return null;
        }
    }
}

