/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.gridgain.internal.h2.util.DateTimeUtils;

public class DistributedSqlConfiguration {
    private static final String PROPERTY_UPDATE_MESSAGE = "SQL parameter '%s' was changed from '%s' to '%s'";
    public static final HashSet<String> DFLT_DISABLED_FUNCS = (HashSet)Arrays.stream(new String[]{"FILE_READ", "FILE_WRITE", "CSVWRITE", "CSVREAD", "MEMORY_FREE", "MEMORY_USED", "LOCK_MODE", "LINK_SCHEMA", "SESSION_ID", "CANCEL_SESSION"}).collect(Collectors.toSet());
    public static final int DFLT_QRY_TIMEOUT = 0;
    private final SimpleDistributedProperty<HashSet<String>> disabledSqlFuncs = new SimpleDistributedProperty<HashSet>("sql.disabledFunctions", SimpleDistributedProperty::parseStringSet);
    private final SimpleDistributedProperty<TimeZone> timeZone = new SimpleDistributedProperty<TimeZone>("sql.timeZone", TimeZone::getTimeZone);
    private final SimpleDistributedProperty<Integer> dfltQueryTimeout = new SimpleDistributedProperty<Integer>("sql.defaultQueryTimeout", SimpleDistributedProperty::parseNonNegativeInteger);
    private final DistributedBooleanProperty disableCreateLuceneIndexForStringValueType = DistributedBooleanProperty.detachedBooleanProperty("sql.disableCreateLuceneIndexForStringValueType");
    private final GridKernalContext ctx;

    public DistributedSqlConfiguration(final GridKernalContext ctx, final IgniteLogger log) {
        this.ctx = ctx;
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedSqlConfiguration.this.disabledSqlFuncs.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedSqlConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedSqlConfiguration.this.dfltQueryTimeout.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedSqlConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedSqlConfiguration.this.timeZone.addListener((name, oldTz, newTz) -> {
                    if (!Objects.equals(oldTz, newTz)) {
                        DateTimeUtils.setTimeZone(newTz);
                    }
                });
                dispatcher.registerProperties(new SimpleDistributedProperty[]{DistributedSqlConfiguration.this.disabledSqlFuncs, DistributedSqlConfiguration.this.timeZone, DistributedSqlConfiguration.this.dfltQueryTimeout});
                dispatcher.registerProperties(new DistributedBooleanProperty[]{DistributedSqlConfiguration.this.disableCreateLuceneIndexForStringValueType});
            }

            @Override
            public void onReadyToWrite() {
                if (ReadableDistributedMetaStorage.isSupported(ctx)) {
                    DistributedConfigurationUtils.setDefaultValue(DistributedSqlConfiguration.this.disabledSqlFuncs, DFLT_DISABLED_FUNCS, log);
                    DistributedSqlConfiguration.this.setTimeZoneDefault(log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedSqlConfiguration.this.dfltQueryTimeout, (int)ctx.config().getSqlConfiguration().getDefaultQueryTimeout(), log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedSqlConfiguration.this.disableCreateLuceneIndexForStringValueType, false, log);
                } else {
                    log.warning("Distributed metastorage is not supported. All distributed SQL configuration parameters are unavailable.");
                    DistributedSqlConfiguration.this.disabledSqlFuncs.localUpdate(null);
                    DistributedSqlConfiguration.this.dfltQueryTimeout.localUpdate(Integer.valueOf((int)ctx.config().getSqlConfiguration().getDefaultQueryTimeout()));
                    DistributedSqlConfiguration.this.disableCreateLuceneIndexForStringValueType.localUpdate(Boolean.valueOf(false));
                }
            }
        });
    }

    private void setTimeZoneDefault(IgniteLogger log) {
        TimeZone tz = this.timeZone.get();
        if (tz == null) {
            try {
                this.timeZone.propagateAsync(null, TimeZone.getDefault()).listen(future -> {
                    if (future.error() != null) {
                        log.error("Cannot set default value of '" + this.timeZone.getName() + '\'', future.error());
                    }
                });
            }
            catch (IgniteCheckedException e) {
                log.error("Cannot initiate setting default value of '" + this.timeZone.getName() + '\'', e);
            }
        } else {
            if (!tz.equals(TimeZone.getDefault())) {
                log.warning("Node time zone is '" + TimeZone.getDefault().getID() + "'. SQL timezone is set up to '" + tz.getID() + '\'');
            }
            DateTimeUtils.setTimeZone(tz);
        }
    }

    public Set<String> disabledFunctions() {
        return this.disabledSqlFuncs.getOrDefault(DFLT_DISABLED_FUNCS);
    }

    public GridFutureAdapter<?> disabledFunctions(HashSet<String> disabledFuncs) throws IgniteCheckedException {
        return this.disabledSqlFuncs.propagateAsync(disabledFuncs);
    }

    public void listenDisabledFunctions(DistributePropertyListener<? super HashSet<String>> lsnr) {
        this.disabledSqlFuncs.addListener(lsnr);
    }

    public TimeZone timeZone() {
        assert (this.timeZone.get() != null);
        return this.timeZone.get();
    }

    public GridFutureAdapter<?> updateTimeZone(TimeZone tz) throws IgniteCheckedException {
        return this.timeZone.propagateAsync(tz);
    }

    public int defaultQueryTimeout() {
        Integer t2 = this.dfltQueryTimeout.get();
        return t2 != null ? t2 : 0;
    }

    public GridFutureAdapter<?> defaultQueryTimeout(int timeout) throws IgniteCheckedException {
        A.ensure(timeout >= 0, "default query timeout value must not be negative.");
        return this.dfltQueryTimeout.propagateAsync(timeout);
    }

    public void listenDefaultQueryTimeout(DistributePropertyListener<Integer> lsnr) {
        this.dfltQueryTimeout.addListener(lsnr);
    }

    public boolean isDisableCreateLuceneIndexForStringValueType() {
        Boolean ret = (Boolean)this.disableCreateLuceneIndexForStringValueType.get();
        return ret != null && ret != false;
    }

    public GridFutureAdapter<?> disableCreateLuceneIndexForStringValueType(boolean disableCreateIdx) throws IgniteCheckedException {
        return this.disableCreateLuceneIndexForStringValueType.propagateAsync(disableCreateIdx);
    }
}

