/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ConcurrentPool<E> {
    private final ConcurrentLinkedQueue<E> pool = new ConcurrentLinkedQueue();
    private final AtomicInteger size = new AtomicInteger(0);
    private final int maxPoolSize;

    public ConcurrentPool(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public boolean recycle(E e) {
        int poolSize;
        do {
            if ((poolSize = this.size.get()) < this.maxPoolSize) continue;
            return false;
        } while (!this.size.compareAndSet(poolSize, poolSize + 1));
        this.pool.add(e);
        return true;
    }

    public E borrow() {
        E r = this.pool.poll();
        if (r != null) {
            this.size.decrementAndGet();
        }
        return r;
    }

    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        this.pool.forEach(action);
    }

    public Stream<E> stream() {
        return this.pool.stream();
    }

    public void clear() {
        this.pool.clear();
        this.size.set(0);
    }
}

