/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Objects;
import org.apache.ignite.internal.util.typedef.F;

public class QueryHistoryKey {
    private final String qry;
    private final String schema;
    private final boolean loc;
    private final boolean distributedJoins;
    private final boolean enforceJoinOrder;
    private final boolean lazy;
    private final int hash;

    public QueryHistoryKey(String qry, String schema, boolean loc, boolean distributedJoins, boolean enforceJoinOrder, boolean lazy) {
        assert (qry != null);
        assert (schema != null);
        this.qry = qry;
        this.schema = schema;
        this.loc = loc;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.lazy = lazy;
        this.hash = Objects.hash(qry, schema, loc, distributedJoins, enforceJoinOrder, lazy);
    }

    public String query() {
        return this.qry;
    }

    public String schema() {
        return this.schema;
    }

    public boolean local() {
        return this.loc;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean enforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean lazy() {
        return this.lazy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryHistoryKey key = (QueryHistoryKey)o;
        return F.eq(this.qry, key.qry) && F.eq(this.schema, key.schema) && F.eq(this.loc, key.loc) && F.eq(this.lazy, key.lazy) && F.eq(this.enforceJoinOrder, key.enforceJoinOrder) && F.eq(this.distributedJoins, key.distributedJoins);
    }
}

