/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryHistoryKey;
import org.apache.ignite.internal.processors.query.QueryHistoryMetricsValue;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

public class QueryHistory {
    @GridToStringExclude
    private final AtomicReference<ConcurrentLinkedDeque8.Node<QueryHistory>> linkRef;
    private volatile QueryHistoryMetricsValue val;
    private final QueryHistoryKey key;

    public QueryHistory(GridRunningQueryInfo info, boolean failed) {
        this.key = new QueryHistoryKey(info.query(), info.schemaName(), info.local(), info.distributedJoins(), info.enforceJoinOrder(), info.lazy());
        long failures = failed ? 1L : 0L;
        long duration = System.currentTimeMillis() - info.startTime();
        long reserved = info.memoryMetricProvider().maxReserved();
        long allocatedOnDisk = info.memoryMetricProvider().maxWrittenOnDisk();
        long totalWrittenOnDisk = info.memoryMetricProvider().totalWrittenOnDisk();
        this.val = new QueryHistoryMetricsValue(1L, failures, duration, duration, info.startTime(), reserved, reserved, allocatedOnDisk, allocatedOnDisk, totalWrittenOnDisk, totalWrittenOnDisk);
        this.linkRef = new AtomicReference();
    }

    public QueryHistoryKey key() {
        return this.key;
    }

    public QueryHistory aggregateWithNew(QueryHistory m4) {
        this.val = new QueryHistoryMetricsValue(this.val.execs() + m4.executions(), this.val.failures() + m4.failures(), Math.min(this.val.minTime(), m4.minimumTime()), Math.max(this.val.maxTime(), m4.maximumTime()), Math.max(this.val.lastStartTime(), m4.lastStartTime()), Math.min(this.val.minMemory(), m4.minMemory()), Math.max(this.val.maxMemory(), m4.maxMemory()), Math.min(this.val.minBytesAllocatedOnDisk(), m4.minBytesAllocatedOnDisk()), Math.max(this.val.maxBytesAllocatedOnDisk(), m4.maxBytesAllocatedOnDisk()), Math.min(this.val.minTotalBytesWrittenOnDisk(), m4.minTotalBytesWrittenOnDisk()), Math.max(this.val.maxTotalBytesWrittenOnDisk(), m4.maxTotalBytesWrittenOnDisk()));
        return this;
    }

    public String query() {
        return this.key.query();
    }

    public String schema() {
        return this.key.schema();
    }

    public boolean local() {
        return this.key.local();
    }

    public long executions() {
        return this.val.execs();
    }

    public long failures() {
        return this.val.failures();
    }

    public long minimumTime() {
        return this.val.minTime();
    }

    public long maximumTime() {
        return this.val.maxTime();
    }

    public long minMemory() {
        return this.val.minMemory();
    }

    public long maxMemory() {
        return this.val.maxMemory();
    }

    public long minBytesAllocatedOnDisk() {
        return this.val.minBytesAllocatedOnDisk();
    }

    public long maxBytesAllocatedOnDisk() {
        return this.val.maxBytesAllocatedOnDisk();
    }

    public long minTotalBytesWrittenOnDisk() {
        return this.val.minTotalBytesWrittenOnDisk();
    }

    public long maxTotalBytesWrittenOnDisk() {
        return this.val.maxTotalBytesWrittenOnDisk();
    }

    public long lastStartTime() {
        return this.val.lastStartTime();
    }

    public boolean distributedJoins() {
        return this.key.distributedJoins();
    }

    public boolean enforceJoinOrder() {
        return this.key.enforceJoinOrder();
    }

    public boolean lazy() {
        return this.key.lazy();
    }

    @Nullable
    public ConcurrentLinkedDeque8.Node<QueryHistory> link() {
        return this.linkRef.get();
    }

    public boolean replaceLink(ConcurrentLinkedDeque8.Node<QueryHistory> expLink, ConcurrentLinkedDeque8.Node<QueryHistory> updatedLink) {
        return this.linkRef.compareAndSet(expLink, updatedLink);
    }

    public String toString() {
        return S.toString(QueryHistory.class, this);
    }
}

