/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.utils;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackGateway;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenable;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class PlatformFutureUtils {
    public static final int TYP_BYTE = 1;
    public static final int TYP_BOOL = 2;
    public static final int TYP_SHORT = 3;
    public static final int TYP_CHAR = 4;
    public static final int TYP_INT = 5;
    public static final int TYP_FLOAT = 6;
    public static final int TYP_LONG = 7;
    public static final int TYP_DOUBLE = 8;
    public static final int TYP_OBJ = 9;

    public static PlatformListenable listen(PlatformContext ctx, IgniteInternalFuture fut, long futPtr, int typ, PlatformTarget target) {
        PlatformListenable listenable = PlatformFutureUtils.getListenable(fut);
        PlatformFutureUtils.listen(ctx, listenable, futPtr, typ, null, target);
        return listenable;
    }

    public static PlatformListenable listen(PlatformContext ctx, IgniteFuture fut, long futPtr, int typ, PlatformTarget target) {
        PlatformListenable listenable = PlatformFutureUtils.getListenable(fut);
        PlatformFutureUtils.listen(ctx, listenable, futPtr, typ, null, target);
        return listenable;
    }

    public static PlatformListenable listen(PlatformContext ctx, IgniteInternalFuture fut, long futPtr, int typ, Writer writer, PlatformTarget target) {
        PlatformListenable listenable = PlatformFutureUtils.getListenable(fut);
        PlatformFutureUtils.listen(ctx, listenable, futPtr, typ, writer, target);
        return listenable;
    }

    public static PlatformListenable listen(PlatformContext ctx, IgniteFuture fut, long futPtr, int typ, Writer writer, PlatformTarget target) {
        PlatformListenable listenable = PlatformFutureUtils.getListenable(fut);
        PlatformFutureUtils.listen(ctx, listenable, futPtr, typ, writer, target);
        return listenable;
    }

    public static PlatformListenable listen(PlatformContext ctx, IgniteInternalFuture fut, long futPtr, Writer writer, PlatformTarget target) {
        PlatformListenable listenable = PlatformFutureUtils.getListenable(fut);
        PlatformFutureUtils.listen(ctx, listenable, futPtr, 9, writer, target);
        return listenable;
    }

    public static PlatformListenable getListenable(IgniteInternalFuture fut) {
        return new InternalFutureListenable(fut);
    }

    public static PlatformListenable getListenable(IgniteFuture fut) {
        return new FutureListenable(fut);
    }

    public static void listen(final PlatformContext ctx, PlatformListenable listenable, final long futPtr, final int typ, final @Nullable Writer writer, final PlatformTarget target) {
        final PlatformCallbackGateway gate = ctx.gateway();
        listenable.listen(new IgniteBiInClosure<Object, Throwable>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void apply(Object res, Throwable err) {
                block31: {
                    if (err instanceof Exception) {
                        err = target.convertException((Exception)err);
                    }
                    if (writer != null && PlatformFutureUtils.writeToWriter(res, err, ctx, writer, futPtr)) {
                        return;
                    }
                    if (err != null) {
                        PlatformFutureUtils.writeFutureError(ctx, futPtr, err);
                        return;
                    }
                    try {
                        if (typ == 9) {
                            if (res == null) {
                                gate.futureNullResult(futPtr);
                                break block31;
                            }
                            try (PlatformMemory mem = ctx.memory().allocate();){
                                PlatformOutputStream out = mem.output();
                                BinaryRawWriterEx outWriter = ctx.writer(out);
                                outWriter.writeObjectDetached(res);
                                out.synchronize();
                                gate.futureObjectResult(futPtr, mem.pointer());
                                break block31;
                            }
                        }
                        if (res == null) {
                            gate.futureNullResult(futPtr);
                            break block31;
                        }
                        switch (typ) {
                            case 1: {
                                gate.futureByteResult(futPtr, ((Byte)res).byteValue());
                                break;
                            }
                            case 2: {
                                gate.futureBoolResult(futPtr, (Boolean)res != false ? 1L : 0L);
                                break;
                            }
                            case 3: {
                                gate.futureShortResult(futPtr, ((Short)res).shortValue());
                                break;
                            }
                            case 4: {
                                gate.futureCharResult(futPtr, ((Character)res).charValue());
                                break;
                            }
                            case 5: {
                                gate.futureIntResult(futPtr, ((Integer)res).intValue());
                                break;
                            }
                            case 6: {
                                gate.futureFloatResult(futPtr, Float.floatToIntBits(((Float)res).floatValue()));
                                break;
                            }
                            case 7: {
                                gate.futureLongResult(futPtr, (Long)res);
                                break;
                            }
                            case 8: {
                                gate.futureDoubleResult(futPtr, Double.doubleToLongBits((Double)res));
                                break;
                            }
                            default: {
                                assert (false) : "Should not reach this: " + typ;
                                break;
                            }
                        }
                    }
                    catch (Throwable t2) {
                        PlatformFutureUtils.writeFutureError(ctx, futPtr, t2);
                        if (!(t2 instanceof Error)) break block31;
                        throw t2;
                    }
                }
            }
        });
    }

    private static void writeFutureError(PlatformContext ctx, long futPtr, Throwable err) {
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx outWriter = ctx.writer(out);
            PlatformUtils.writeError(err, outWriter);
            PlatformUtils.writeErrorData(err, outWriter);
            out.synchronize();
            ctx.gateway().futureError(futPtr, mem.pointer());
        }
    }

    private static boolean writeToWriter(Object obj, Throwable err, PlatformContext ctx, Writer writer, long futPtr) {
        boolean canWrite = writer.canWrite(obj, err);
        if (!canWrite) {
            return false;
        }
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx outWriter = ctx.writer(out);
            writer.write(outWriter, obj, err);
            out.synchronize();
            ctx.gateway().futureObjectResult(futPtr, mem.pointer());
        }
        return true;
    }

    private static class InternalFutureListenable
    implements PlatformListenable {
        private final IgniteInternalFuture fut;

        public InternalFutureListenable(IgniteInternalFuture fut) {
            this.fut = fut;
        }

        @Override
        public void listen(final IgniteBiInClosure<Object, Throwable> lsnr) {
            this.fut.listen(new IgniteInClosure<IgniteInternalFuture>(){
                private static final long serialVersionUID = 0L;

                @Override
                public void apply(IgniteInternalFuture fut0) {
                    try {
                        lsnr.apply(fut0.get(), null);
                    }
                    catch (Throwable err) {
                        lsnr.apply(null, err);
                    }
                }
            });
        }

        @Override
        public boolean cancel() throws IgniteCheckedException {
            return this.fut.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.fut.isCancelled();
        }
    }

    private static class FutureListenable
    implements PlatformListenable {
        private final IgniteFuture fut;

        public FutureListenable(IgniteFuture fut) {
            this.fut = fut;
        }

        @Override
        public void listen(final IgniteBiInClosure<Object, Throwable> lsnr) {
            this.fut.listen(new IgniteInClosure<IgniteFuture>(){
                private static final long serialVersionUID = 0L;

                @Override
                public void apply(IgniteFuture fut0) {
                    block2: {
                        try {
                            lsnr.apply(fut0.get(), null);
                        }
                        catch (Throwable err) {
                            lsnr.apply(null, err);
                            if (!(err instanceof Error)) break block2;
                            throw err;
                        }
                    }
                }
            });
        }

        @Override
        public boolean cancel() {
            return this.fut.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.fut.isCancelled();
        }
    }

    public static interface Writer {
        public void write(BinaryRawWriterEx var1, Object var2, Throwable var3);

        public boolean canWrite(Object var1, Throwable var2);
    }
}

