/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.tx;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;

public class ClientTxEndRequest
extends ClientRequest {
    private final int txId;
    private final boolean committed;

    public ClientTxEndRequest(BinaryRawReader reader) {
        super(reader);
        this.txId = reader.readInt();
        this.committed = reader.readBoolean();
    }

    @Override
    public boolean isAsync(ClientConnectionContext ctx) {
        return true;
    }

    @Override
    public IgniteInternalFuture<ClientResponse> processAsync(ClientConnectionContext ctx) {
        return this.endTxAsync(ctx).chain(f -> {
            if (f.error() != null) {
                throw new GridClosureException(f.error());
            }
            return this.process(ctx);
        });
    }

    private IgniteInternalFuture<IgniteInternalTx> endTxAsync(ClientConnectionContext ctx) {
        ClientTxContext txCtx = ctx.txContext(this.txId);
        if (txCtx == null && !this.committed) {
            return new GridFinishedFuture<IgniteInternalTx>();
        }
        if (txCtx == null) {
            throw new IgniteClientException(1021, "Transaction with id " + this.txId + " not found.");
        }
        try {
            txCtx.acquire(this.committed);
            if (this.committed) {
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = txCtx.tx().context().commitTxAsync(txCtx.tx());
                return igniteInternalFuture;
            }
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = txCtx.tx().rollbackAsync();
            return igniteInternalFuture;
        }
        catch (IgniteTxTimeoutCheckedException e) {
            throw new IgniteClientException(1022, e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteClientException(1, e.getMessage(), e);
        }
        finally {
            ctx.removeTxContext(this.txId);
            try {
                txCtx.release(false);
            }
            catch (IgniteCheckedException igniteCheckedException) {}
        }
    }
}

