/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryCursor;

class ClientCacheSqlFieldsQueryResponse
extends ClientResponse {
    private final ClientCacheQueryCursor cursor;
    private final FieldsQueryCursor<List> fieldsCursor;
    private final boolean includeFieldNames;

    ClientCacheSqlFieldsQueryResponse(long requestId, ClientCacheQueryCursor cursor, FieldsQueryCursor<List> fieldsCursor, boolean includeFieldNames) {
        super(requestId);
        assert (cursor != null);
        assert (fieldsCursor != null);
        this.cursor = cursor;
        this.fieldsCursor = fieldsCursor;
        this.includeFieldNames = includeFieldNames;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        try {
            super.encode(ctx, writer);
            writer.writeLong(this.cursor.id());
            int cnt = this.fieldsCursor.getColumnsCount();
            writer.writeInt(cnt);
            if (this.includeFieldNames) {
                for (int i = 0; i < cnt; ++i) {
                    writer.writeString(this.fieldsCursor.getFieldName(i));
                }
            }
            this.cursor.writePage(writer);
        }
        catch (Throwable t2) {
            this.cursor.close();
            throw t2;
        }
    }
}

