/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import org.apache.ignite.cache.CacheExistsException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheConfigurationSerializer;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;

public class ClientCacheGetOrCreateWithConfigurationRequest
extends ClientRequest {
    private final CacheConfiguration cacheCfg;

    public ClientCacheGetOrCreateWithConfigurationRequest(BinaryReaderExImpl reader, ClientProtocolContext protocolCtx, IgnitePluginProcessor pluginProc) {
        super(reader);
        this.cacheCfg = ClientCacheConfigurationSerializer.read(reader, protocolCtx, pluginProc);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            ctx.kernalContext().grid().getOrCreateCache(this.cacheCfg);
        }
        catch (CacheExistsException e) {
            throw new IgniteClientException(1001, e.getMessage());
        }
        return super.process(ctx);
    }
}

