/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientNotification;

public class ClientCacheEntryEventNotification
extends ClientNotification {
    private final Iterable<CacheEntryEvent<?, ?>> evts;

    public ClientCacheEntryEventNotification(short opCode, long rsrcId, Iterable<CacheEntryEvent<?, ?>> evts) {
        super(opCode, rsrcId);
        assert (evts != null);
        this.evts = evts;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);
        int pos = writer.reserveInt();
        int cnt = 0;
        for (CacheEntryEvent<?, ?> evt : this.evts) {
            writer.writeObjectDetached(evt.getKey());
            writer.writeObjectDetached(evt.getOldValue());
            writer.writeObjectDetached(evt.getValue());
            switch (evt.getEventType()) {
                case CREATED: {
                    writer.writeByte((byte)0);
                    break;
                }
                case UPDATED: {
                    writer.writeByte((byte)1);
                    break;
                }
                case REMOVED: {
                    writer.writeByte((byte)2);
                    break;
                }
                case EXPIRED: {
                    writer.writeByte((byte)3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown event type: " + (Object)((Object)evt.getEventType()));
                }
            }
            ++cnt;
        }
        writer.writeInt(pos, cnt);
    }
}

