/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.diagnostic;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContinuation;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class ReconciliationExecutionContext {
    public static final long IGNORE_JOB_PERMITS_SESSION_ID = -1317624576693539401L;
    private static final int MAX_SESSIONS = 10;
    private final GridKernalContext kernalCtx;
    private final Map<Long, Integer> runningJobsLimit = new LinkedHashMap<Long, Integer>();
    private final Map<Long, Integer> runningJobsCnt = new LinkedHashMap<Long, Integer>();
    private final Map<Long, Queue<ComputeJobContinuation>> pendingJobs = new LinkedHashMap<Long, Queue<ComputeJobContinuation>>();
    private long sesId;
    private volatile GridFutureAdapter<ReconciliationStatisticsUpdateListener> statisticsListenerFut = new GridFutureAdapter();

    public ReconciliationExecutionContext(GridKernalContext kernalCtx) {
        this.kernalCtx = kernalCtx;
    }

    public synchronized long sessionId() {
        return this.sesId;
    }

    public synchronized void registerSession(long sesId, int parallelism) {
        this.sesId = sesId;
        this.runningJobsCnt.put(sesId, 0);
        this.runningJobsLimit.put(sesId, parallelism);
        this.pendingJobs.put(sesId, new LinkedList());
        this.statisticsListenerFut = new GridFutureAdapter();
        if (this.runningJobsCnt.size() == 11) {
            Stream.of(this.runningJobsCnt, this.runningJobsLimit, this.pendingJobs).map(m4 -> m4.entrySet().iterator()).peek(Iterator::next).forEach(Iterator::remove);
        }
    }

    public synchronized boolean acquireJobPermitOrHold(long sesId, ComputeJobContinuation jobCont) {
        if (sesId == -1317624576693539401L) {
            return true;
        }
        int limit = this.runningJobsLimit.get(sesId);
        int running = this.runningJobsCnt.get(sesId);
        if (running < limit) {
            this.runningJobsCnt.put(sesId, running + 1);
            return true;
        }
        jobCont.holdcc();
        Queue<ComputeJobContinuation> jobsQueue = this.pendingJobs.get(sesId);
        jobsQueue.add(jobCont);
        return false;
    }

    public synchronized void releaseJobPermit(long sesId) {
        if (sesId == -1317624576693539401L) {
            return;
        }
        int running = this.runningJobsCnt.get(sesId);
        Queue<ComputeJobContinuation> jobsQueue = this.pendingJobs.get(sesId);
        ComputeJobContinuation pendingJob = jobsQueue.poll();
        this.runningJobsCnt.put(sesId, running - 1);
        if (pendingJob != null) {
            try {
                this.kernalCtx.closure().runLocal(pendingJob::callcc, (byte)3);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }

    public void updatePartitionStatistics(long sesId, String cacheName, int partId, boolean primary, long keysCnt) {
        this.statisticsListenerFut.listen(f -> {
            try {
                ((ReconciliationStatisticsUpdateListener)f.get()).updateScannedPartition(sesId, cacheName, partId, primary, keysCnt);
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        });
    }

    public synchronized void listenMetricsUpdates(long sesId, ReconciliationStatisticsUpdateListener listener) {
        if (sesId == this.sesId) {
            this.statisticsListenerFut.onDone(new ReconciliationStatisticsUpdateListenerAdapter(sesId, listener));
        }
    }

    public synchronized void removeMetricsUpdateListener(long sesId) {
        if (sesId == this.sesId) {
            GridFutureAdapter<NoopReconciliationStatisticsUpdateListener> fut = new GridFutureAdapter<NoopReconciliationStatisticsUpdateListener>();
            fut.onDone(new NoopReconciliationStatisticsUpdateListener());
            this.statisticsListenerFut = fut;
        }
    }

    private static class NoopReconciliationStatisticsUpdateListener
    implements ReconciliationStatisticsUpdateListener {
        private NoopReconciliationStatisticsUpdateListener() {
        }

        @Override
        public void updateScannedPartition(long sesId, String cacheName, int partId, boolean primary, long keysCnt) {
        }
    }

    private static class ReconciliationStatisticsUpdateListenerAdapter
    implements ReconciliationStatisticsUpdateListener {
        private final long sesId;
        private final ReconciliationStatisticsUpdateListener listener;

        ReconciliationStatisticsUpdateListenerAdapter(long sesId, ReconciliationStatisticsUpdateListener listener) {
            this.sesId = sesId;
            this.listener = listener;
        }

        @Override
        public void updateScannedPartition(long sesId, String cacheName, int partId, boolean primary, long keysCnt) {
            if (sesId == this.sesId) {
                this.listener.updateScannedPartition(sesId, cacheName, partId, primary, keysCnt);
            }
        }
    }

    public static interface ReconciliationStatisticsUpdateListener {
        public void updateScannedPartition(long var1, String var3, int var4, boolean var5, long var6);
    }
}

