/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cluster.DetachedClusterNode;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.processors.cluster.BranchingPointType;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaselineTopology
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Comparator<Object> CONSISTENT_ID_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().equals(o2.getClass())) {
                return ((Comparable)o1).compareTo(o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    private final int id;
    private final Map<Object, Map<String, Object>> nodeMap;
    private final Map<Short, Object> compactIdMapping;
    private final Map<Object, Short> consistentIdMapping;
    private BranchingPointType lastBranchingPointType;
    private long branchingPntHash;
    private final List<Long> branchingHist;

    private BaselineTopology(Map<Object, Map<String, Object>> nodeMap, int id) {
        this.id = id;
        this.compactIdMapping = U.newHashMap(nodeMap.size());
        this.consistentIdMapping = U.newHashMap(nodeMap.size());
        this.nodeMap = nodeMap;
        TreeSet<Object> consistentIds = new TreeSet<Object>(CONSISTENT_ID_COMPARATOR);
        for (Object o : nodeMap.keySet()) {
            this.branchingPntHash += (long)o.hashCode();
            consistentIds.add(o);
        }
        short compactId = 0;
        for (Object e : consistentIds) {
            this.compactIdMapping.put(compactId, e);
            short s2 = compactId;
            compactId = (short)(compactId + 1);
            this.consistentIdMapping.put(e, s2);
        }
        this.lastBranchingPointType = BranchingPointType.NEW_BASELINE_TOPOLOGY;
        this.branchingHist = new ArrayList<Long>();
        this.branchingHist.add(this.branchingPntHash);
    }

    public int id() {
        return this.id;
    }

    public Set<Object> consistentIds() {
        return this.nodeMap.keySet();
    }

    public List<Long> branchingHistory() {
        return this.branchingHist;
    }

    public Map<Short, Object> compactIdMapping() {
        return this.compactIdMapping;
    }

    public Map<Object, Short> consistentIdMapping() {
        return this.consistentIdMapping;
    }

    public Short resolveShortConsistentId(Object constId) {
        return this.consistentIdMapping.get(constId);
    }

    public Object resolveConsistentId(Short constId) {
        return this.compactIdMapping.get(constId);
    }

    public long branchingPointHash() {
        return this.branchingPntHash;
    }

    public Map<String, Object> attributes(Object consId) {
        return this.nodeMap.get(consId);
    }

    public List<BaselineNode> currentBaseline() {
        ArrayList<BaselineNode> res = new ArrayList<BaselineNode>();
        for (Map.Entry<Object, Map<String, Object>> consIdAttrsEntry : this.nodeMap.entrySet()) {
            res.add(new DetachedClusterNode(consIdAttrsEntry.getKey(), consIdAttrsEntry.getValue()));
        }
        return res;
    }

    public ClusterNode baselineNode(Object consId) {
        Map<String, Object> attrs = this.nodeMap.get(consId);
        return attrs != null ? new DetachedClusterNode(consId, attrs) : null;
    }

    public List<ClusterNode> createBaselineView(Collection<ClusterNode> aliveNodes, @Nullable IgnitePredicate<ClusterNode> nodeFilter) {
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(this.nodeMap.size());
        boolean nullNodeFilter = nodeFilter == null;
        for (ClusterNode node : aliveNodes) {
            if (!this.nodeMap.containsKey(node.consistentId()) || !nullNodeFilter && !CU.affinityNode(node, nodeFilter)) continue;
            res.add(node);
        }
        assert (res.size() <= this.nodeMap.size());
        if (res.size() == this.nodeMap.size()) {
            return res;
        }
        HashMap<Object, ClusterNode> consIdMap = new HashMap<Object, ClusterNode>();
        for (ClusterNode clusterNode : aliveNodes) {
            if (!this.nodeMap.containsKey(clusterNode.consistentId()) || !nullNodeFilter && !CU.affinityNode(clusterNode, nodeFilter)) continue;
            consIdMap.put(clusterNode.consistentId(), clusterNode);
        }
        for (Map.Entry entry : this.nodeMap.entrySet()) {
            Object consId = entry.getKey();
            if (consIdMap.containsKey(consId)) continue;
            DetachedClusterNode node = new DetachedClusterNode(consId, (Map)entry.getValue());
            if (!nullNodeFilter && !CU.affinityNode(node, nodeFilter)) continue;
            consIdMap.put(consId, node);
        }
        res = new ArrayList();
        res.addAll(consIdMap.values());
        Collections.sort(res, NodeOrderComparator.getInstance());
        return res;
    }

    public boolean isSatisfied(@NotNull Collection<ClusterNode> presentedNodes) {
        if (presentedNodes.size() < this.nodeMap.size()) {
            return false;
        }
        HashSet<Object> presentedNodeIds = new HashSet<Object>();
        for (ClusterNode node : presentedNodes) {
            presentedNodeIds.add(node.consistentId());
        }
        return presentedNodeIds.containsAll(this.nodeMap.keySet());
    }

    public int size() {
        return this.nodeMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaselineTopology top = (BaselineTopology)o;
        return this.nodeMap != null ? this.nodeMap.keySet().equals(top.nodeMap.keySet()) : top.nodeMap == null;
    }

    public int hashCode() {
        return this.nodeMap != null ? this.nodeMap.hashCode() : 0;
    }

    public static boolean equals(BaselineTopology blt1, BaselineTopology blt2) {
        if (blt1 == null && blt2 == null) {
            return true;
        }
        if (blt1 == null ^ blt2 == null) {
            return false;
        }
        return blt1.equals(blt2);
    }

    public boolean isNewTopology() {
        return this.lastBranchingPointType == BranchingPointType.NEW_BASELINE_TOPOLOGY && this.id == 0;
    }

    @Nullable
    public static BaselineTopology build(Collection<? extends BaselineNode> nodes, int id) {
        if (nodes == null) {
            return null;
        }
        HashMap<Object, Map<String, Object>> nodeMap = new HashMap<Object, Map<String, Object>>();
        for (BaselineNode baselineNode : nodes) {
            nodeMap.put(baselineNode.consistentId(), baselineNode.attributes());
        }
        return new BaselineTopology(nodeMap, id);
    }

    boolean isCompatibleWith(BaselineTopology blt) {
        return blt == null || this.branchingPntHash == blt.branchingPntHash || this.branchingHist.contains(blt.branchingPntHash);
    }

    boolean updateHistory(Collection<? extends BaselineNode> nodes) {
        long newTopHash = this.calculateTopologyHash(nodes);
        this.lastBranchingPointType = BranchingPointType.CLUSTER_ACTIVATION;
        if (this.branchingPntHash != newTopHash) {
            this.branchingPntHash = newTopHash;
            this.branchingHist.add(newTopHash);
            return true;
        }
        return false;
    }

    void resetBranchingHistory(long newBranchingPointHash) {
        this.lastBranchingPointType = BranchingPointType.BRANCHING_HISTORY_RESET;
        this.branchingHist.clear();
        this.branchingPntHash = newBranchingPointHash;
        this.branchingHist.add(newBranchingPointHash);
    }

    private long calculateTopologyHash(Collection<? extends BaselineNode> nodes) {
        long res = 0L;
        Set<Object> bltConsIds = this.nodeMap.keySet();
        for (BaselineNode baselineNode : nodes) {
            if (!bltConsIds.contains(baselineNode.consistentId())) continue;
            res += (long)baselineNode.consistentId().hashCode();
        }
        return res;
    }

    public String toString() {
        return "BaselineTopology [id=" + this.id + ", branchingHash=" + this.branchingPntHash + ", branchingType='" + (Object)((Object)this.lastBranchingPointType) + '\'' + ", baselineNodes=" + this.nodeMap.keySet() + ']';
    }
}

