/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationKeyMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationRepairMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationValueMeta;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PartitionReconciliationDataRowMeta
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private PartitionReconciliationKeyMeta keyMeta;
    private Map<UUID, PartitionReconciliationValueMeta> valMeta;
    private PartitionReconciliationRepairMeta repairMeta;

    public PartitionReconciliationDataRowMeta() {
    }

    public PartitionReconciliationDataRowMeta(PartitionReconciliationKeyMeta keyMeta, Map<UUID, PartitionReconciliationValueMeta> valMeta) {
        this.keyMeta = keyMeta;
        this.valMeta = valMeta;
    }

    public PartitionReconciliationDataRowMeta(PartitionReconciliationKeyMeta keyMeta, Map<UUID, PartitionReconciliationValueMeta> valMeta, PartitionReconciliationRepairMeta repairMeta) {
        this.keyMeta = keyMeta;
        this.valMeta = valMeta;
        this.repairMeta = repairMeta;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.keyMeta);
        U.writeMap(out, this.valMeta);
        out.writeObject(this.repairMeta);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.keyMeta = (PartitionReconciliationKeyMeta)in.readObject();
        this.valMeta = U.readMap(in);
        this.repairMeta = (PartitionReconciliationRepairMeta)in.readObject();
    }

    public PartitionReconciliationKeyMeta keyMeta() {
        return this.keyMeta;
    }

    public Map<UUID, PartitionReconciliationValueMeta> valueMeta() {
        return this.valMeta;
    }

    public PartitionReconciliationRepairMeta repairMeta() {
        return this.repairMeta;
    }

    public String toString() {
        return S.toString(PartitionReconciliationDataRowMeta.class, this);
    }

    public int hashCode() {
        return Objects.hash(this.keyMeta, this.valMeta, this.repairMeta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReconciliationDataRowMeta meta = (PartitionReconciliationDataRowMeta)o;
        if (!Objects.equals(this.keyMeta, meta.keyMeta)) {
            return false;
        }
        if (!Objects.equals(this.valMeta, meta.valMeta)) {
            return false;
        }
        return Objects.equals(this.repairMeta, meta.repairMeta);
    }
}

