/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.CacheQueryObjectValueContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class ConsistencyUtils {
    public static void printDivergenceDetailsForKey(IdleVerifyResultV2 res, IgniteLogger log) throws IgniteCheckedException {
        if (F.isEmpty(res.hashConflicts())) {
            return;
        }
        Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> e0 = res.hashConflicts().entrySet().iterator().next();
        List<PartitionHashRecordV2> list = e0.getValue();
        PartitionKeyV2 first = e0.getKey();
        list.sort(new Comparator<PartitionHashRecordV2>(){

            @Override
            public int compare(PartitionHashRecordV2 o1, PartitionHashRecordV2 o2) {
                return o1.consistentId().toString().compareTo(o2.consistentId().toString());
            }
        });
        IgniteEx g0 = ConsistencyUtils.grid(list.get(0).consistentId());
        IgniteEx g1 = list.stream().skip(1L).filter(r -> r.partitionHash() != ((PartitionHashRecordV2)list.get(0)).partitionHash()).map(l -> ConsistencyUtils.grid(l.consistentId())).findFirst().orElseThrow(() -> new IgniteCheckedException("Failed to find a node by consistent id"));
        int part = first.partitionId();
        CacheGroupContext grpCtx0 = g0.context().cache().cacheGroup(first.groupId());
        List<CacheDataRow> dataRows0 = ConsistencyUtils.rows(grpCtx0, part);
        CacheGroupContext grpCtx1 = g1.context().cache().cacheGroup(first.groupId());
        List<CacheDataRow> dataRows1 = ConsistencyUtils.rows(grpCtx1, part);
        CacheQueryObjectValueContext ctx = new CacheQueryObjectValueContext(grpCtx0.cacheObjectContext().kernalContext());
        List<CacheDataRow> diff = ConsistencyUtils.diff(dataRows0, dataRows1, ctx);
        if (diff.isEmpty()) {
            diff = ConsistencyUtils.diff(dataRows1, dataRows0, ctx);
        }
        if (diff.isEmpty()) {
            log.info(">>>> Divergencies not detected");
            return;
        }
        CacheDataRow testRow = diff.get(0);
        CacheDataRow r0 = dataRows0.stream().filter(r -> r.key().equals(testRow.key())).findFirst().orElse(null);
        CacheDataRow r1 = dataRows1.stream().filter(r -> r.key().equals(testRow.key())).findFirst().orElse(null);
        log.info(">>>> Test node 0 [name=" + g0.name() + ", part=" + part + ", row=" + r0 + ']');
        log.info(">>>> Test node 1 [name=" + g1.name() + ", part=" + part + ", row=" + r1 + ']');
        log.info(">>>> Test node 0 [tree=" + grpCtx0.topology().localPartition(part).dataStore().pendingTree().printTree() + ']');
        log.info(">>>> Test node 1 [tree=" + grpCtx1.topology().localPartition(part).dataStore().pendingTree().printTree() + ']');
        ConsistencyUtils.printKeyHistory(g0, log, testRow, grpCtx0);
        ConsistencyUtils.printKeyHistory(g1, log, testRow, grpCtx1);
    }

    private static List<CacheDataRow> diff(List<CacheDataRow> dataRows0, List<CacheDataRow> dataRows1, CacheObjectValueContext ctx) {
        ArrayList<CacheDataRow> diff = new ArrayList<CacheDataRow>();
        for (CacheDataRow r0 : dataRows0) {
            boolean exists = false;
            GridCacheVersion ver0 = r0.version();
            Object k0 = r0.key().value(ctx, false);
            Object v0 = r0.value().value(ctx, false);
            for (CacheDataRow r1 : dataRows1) {
                GridCacheVersion ver1 = r1.version();
                Object k1 = r1.key().value(ctx, false);
                Object v1 = r1.value().value(ctx, false);
                if (!ver0.equals(ver1) || !k0.equals(k1) || (v0 == null || !v0.equals(v1)) && (v0 != null || v1 != null)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            diff.add(r0);
        }
        return diff;
    }

    public static void printKeyHistory(IgniteEx grid, IgniteLogger log, CacheDataRow testRow, CacheGroupContext grpCtx) throws IgniteCheckedException {
        IgniteWriteAheadLogManager walMgr = grid.context().cache().context().wal();
        if (walMgr == null) {
            return;
        }
        CacheQueryObjectValueContext ctx = new CacheQueryObjectValueContext(grpCtx.cacheObjectContext().kernalContext());
        log.info(">>>> Dumping key history [name=" + grid.name() + ", key=" + testRow.key().value(ctx, false));
        try (WALIterator iter0 = walMgr.replay(null);){
            while (iter0.hasNext()) {
                IgniteBiTuple tup = (IgniteBiTuple)iter0.next();
                if (!(tup.get2() instanceof DataRecord)) continue;
                DataRecord rec = (DataRecord)tup.get2();
                for (DataEntry entry : rec.writeEntries()) {
                    if (!entry.key().equals(testRow.key()) || entry.cacheId() != testRow.cacheId() && testRow.cacheId() != 0) continue;
                    log.info(">>>>    " + entry + ", key=" + entry.key().value(ctx, false).toString() + ", val=" + (entry.value() == null ? "NULL" : entry.value().value(ctx, false).toString()));
                }
            }
        }
    }

    public static List<CacheDataRow> rows(CacheGroupContext grpCtx, int part) throws IgniteCheckedException {
        CacheQueryObjectValueContext cacheObjCtx = new CacheQueryObjectValueContext(grpCtx.cacheObjectContext().kernalContext());
        ArrayList<CacheDataRow> rows = new ArrayList<CacheDataRow>();
        grpCtx.offheap().partitionIterator(part, 3).forEach(rows::add);
        for (CacheDataRow row : rows) {
            row.key().value(cacheObjCtx, false);
            row.value().value(cacheObjCtx, false);
        }
        return rows;
    }

    @Nullable
    private static IgniteEx grid(Object consistentId) {
        return G.allGrids().stream().filter(g2 -> g2.cluster().localNode().consistentId().equals(consistentId)).findFirst().orElse(null);
    }
}

