/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointPages;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.DelayedPageReplacementTracker;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class DelayedDirtyPageStoreWrite {
    private final PageStoreWriter flushDirtyPage;
    private final int pageSize;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc;
    private final DelayedPageReplacementTracker tracker;
    @Nullable
    private FullPageId fullPageId;
    private int tag = -1;
    @Nullable
    private CheckpointPages checkpointPages;

    public DelayedDirtyPageStoreWrite(PageStoreWriter flushDirtyPage, ThreadLocal<ByteBuffer> byteBufThreadLoc, int pageSize, DelayedPageReplacementTracker tracker) {
        this.flushDirtyPage = flushDirtyPage;
        this.pageSize = pageSize;
        this.byteBufThreadLoc = byteBufThreadLoc;
        this.tracker = tracker;
    }

    public void copyPageToTemporaryBuffer(FullPageId fullPageId, ByteBuffer originPageBuf, int tag, CheckpointPages checkpointPages) {
        this.tracker.lock(fullPageId);
        ByteBuffer tlb = this.byteBufThreadLoc.get();
        tlb.rewind();
        long writeAddr = GridUnsafe.bufferAddress(tlb);
        long origBufAddr = GridUnsafe.bufferAddress(originPageBuf);
        GridUnsafe.copyMemory(origBufAddr, writeAddr, this.pageSize);
        this.fullPageId = fullPageId;
        this.tag = tag;
        this.checkpointPages = checkpointPages;
    }

    public void flushCopiedPageIfExists() throws IgniteCheckedException {
        if (this.fullPageId == null) {
            return;
        }
        assert (this.checkpointPages != null) : this.fullPageId;
        Throwable errorOnWrite = null;
        try {
            this.flushDirtyPage.writePage(this.fullPageId, this.byteBufThreadLoc.get(), this.tag);
        }
        catch (Throwable t2) {
            errorOnWrite = t2;
            throw t2;
        }
        finally {
            this.checkpointPages.unblockFsyncOnPageReplacement(this.fullPageId, errorOnWrite);
            this.tracker.unlock(this.fullPageId);
            this.fullPageId = null;
            this.tag = -1;
        }
    }
}

