/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.maintenance;

import java.io.File;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClearFolderAction
implements MaintenanceAction<Void> {
    public static final String ACTION_NAME = "clearFolder";
    private final File rootStoreDir;
    private final String[] cacheStoreFolders;
    private final MaintenanceRegistry maintenanceRegistry;

    public ClearFolderAction(MaintenanceRegistry maintenanceRegistry, File rootStoreDir, String[] cacheStoreFolders) {
        this.maintenanceRegistry = maintenanceRegistry;
        this.rootStoreDir = rootStoreDir;
        this.cacheStoreFolders = cacheStoreFolders;
    }

    @Override
    public Void execute() {
        for (String cacheStoreFolderName : this.cacheStoreFolders) {
            File cacheStoreDir = new File(this.rootStoreDir, cacheStoreFolderName);
            if (!cacheStoreDir.exists() || !cacheStoreDir.isDirectory()) continue;
            for (File file : cacheStoreDir.listFiles()) {
                file.delete();
            }
            cacheStoreDir.delete();
        }
        this.maintenanceRegistry.unregisterMaintenanceTask("clearFolderAction");
        return null;
    }

    @Override
    @NotNull
    public String name() {
        return ACTION_NAME;
    }

    @Override
    @Nullable
    public String description() {
        return "Clearing cache folders on disk [rootStoreDir=" + this.rootStoreDir + ", cacheStoreFolders=(" + String.join((CharSequence)",", this.cacheStoreFolders) + ')' + ']';
    }
}

