/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageFragmentedUpdateRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageUpdateRecord;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CorruptedFreeListException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheFreeList
extends AbstractFreeList<CacheDataRow> {
    private final PageHandler<CacheDataRow, Boolean> updateDataRowTtl = new UpdateRowMetaHandler();

    public CacheFreeList(int cacheGrpId, String name, DataRegion dataRegion, @Nullable IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew, PageLockTrackerManager pageLockTrackerManager, GridKernalContext ctx, @Nullable AtomicLong pageListCacheLimit, byte pageFlag) throws IgniteCheckedException {
        super(cacheGrpId, name, dataRegion, null, wal, metaPageId, initNew, pageLockTrackerManager, ctx, pageListCacheLimit, pageFlag);
    }

    @Override
    public void insertDataRow(CacheDataRow row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        super.insertDataRow(row, statHolder);
        assert (row.key().partition() == PageIdUtils.partId(row.link())) : "Constructed a link with invalid partition ID [partId=" + row.key().partition() + ", link=" + U.hexLong(row.link()) + ']';
    }

    @Override
    public boolean updateDataRowTtl(long link, CacheDataRow row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            Boolean updated = this.write(pageId, this.updateDataRowTtl, row, itemId, null, statHolder);
            assert (updated != null);
            return updated;
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new CorruptedFreeListException("Failed to update data row", t2, this.grpId, new long[0]);
        }
    }

    static /* synthetic */ int access$1000(CacheFreeList x0) {
        return x0.grpId;
    }

    private final class UpdateRowMetaHandler
    extends PageHandler<CacheDataRow, Boolean> {
        private UpdateRowMetaHandler() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, CacheDataRow row, int itemId, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            DataPageIO io = (DataPageIO)iox;
            DataPagePayload data = io.readPayload(pageAddr, itemId, CacheFreeList.this.pageSize());
            Boolean updated = data.nextLink() == 0L ? this.updateTtl(cacheId, pageId, page, pageAddr, io, row, itemId, walPlc) : this.updateFragmentedTtl(cacheId, pageId, page, pageAddr, row, itemId, walPlc, statHolder);
            CacheFreeList.this.evictionTracker().touchPage(pageId);
            return updated;
        }

        private Boolean updateTtl(int cacheId, long pageId, long page, long pageAddr, DataPageIO io, CacheDataRow row, int itemId, Boolean walPlc) throws IgniteCheckedException {
            DataPagePayload data = io.readPayload(pageAddr, itemId, CacheFreeList.this.pageSize());
            assert (data.nextLink() == 0L) : "This method must be called only for not fragmented rows.";
            io.updateExpirationTime(pageAddr, data.offset(), row);
            if (CacheFreeList.this.needWalDeltaRecord(pageId, page, walPlc)) {
                int rowSize = data.payloadSize();
                byte[] payload = new byte[rowSize];
                data = io.readPayload(pageAddr, itemId, CacheFreeList.this.pageSize());
                assert (data.payloadSize() == rowSize);
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, rowSize);
                CacheFreeList.this.wal.log(new DataPageUpdateRecord(cacheId, pageId, itemId, payload));
            }
            return Boolean.TRUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean updateFragmentedTtl(int cacheId, long pageId, long page, long pageAddr, CacheDataRow row, int itemId, Boolean walPlc, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            long nextLink = 0L;
            boolean pageUpdated = false;
            int scannedBytes = 0;
            int updatedBytes = 0;
            boolean firstPage = true;
            do {
                int cutItemId = firstPage ? itemId : PageIdUtils.itemId(nextLink);
                long curPageId = firstPage ? pageId : PageIdUtils.pageId(nextLink);
                long curPage = firstPage ? page : CacheFreeList.this.pageMem.acquirePage(CacheFreeList.this.grpId, curPageId, statHolder);
                try {
                    long curPageAddr = firstPage ? pageAddr : CacheFreeList.this.pageMem.writeLock(CacheFreeList.this.grpId, curPageId, curPage);
                    try {
                        assert (curPageAddr != 0L) : "Failed to acquire write lock on the page [grpId=" + CacheFreeList.access$1000(CacheFreeList.this) + ", pageId=" + curPageId + ", page=" + curPage + ", firstPage=" + firstPage + ", nextLink=" + nextLink + ']';
                        ByteBuffer buf = CacheFreeList.this.pageMem.pageBuffer(curPageAddr);
                        DataPageIO io = DataPageIO.VERSIONS.forPage(curPageAddr);
                        DataPagePayload data = io.readPayload(curPageAddr, cutItemId, CacheFreeList.this.pageSize());
                        buf.position(data.offset());
                        buf.limit(data.offset() + data.payloadSize());
                        int updatedOnCurrPage = io.updateExpirationTimeFragmentData(row, buf, data.payloadSize(), updatedBytes, scannedBytes);
                        pageUpdated = updatedOnCurrPage != 0;
                        scannedBytes += data.payloadSize();
                        updatedBytes += updatedOnCurrPage;
                        if (pageUpdated && CacheFreeList.this.needWalDeltaRecord(curPageId, curPage, walPlc)) {
                            data = io.readPayload(curPageAddr, cutItemId, CacheFreeList.this.pageSize());
                            byte[] payload = new byte[data.payloadSize()];
                            PageUtils.getBytes(curPageAddr, data.offset(), payload, 0, data.payloadSize());
                            CacheFreeList.this.wal.log(new DataPageFragmentedUpdateRecord(cacheId, curPageId, cutItemId, data.nextLink(), payload));
                        }
                        if (updatedOnCurrPage == Integer.MAX_VALUE) {
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                        nextLink = data.nextLink();
                    }
                    finally {
                        if (!firstPage) {
                            CacheFreeList.this.pageMem.writeUnlock(CacheFreeList.this.grpId, curPageId, curPage, walPlc, pageUpdated);
                        }
                    }
                }
                finally {
                    if (!firstPage) {
                        CacheFreeList.this.pageMem.releasePage(CacheFreeList.this.grpId, curPageId, curPage);
                    }
                }
                firstPage = false;
            } while (nextLink != 0L);
            return Boolean.FALSE;
        }
    }
}

