/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicNearResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicCheckUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicFullUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateFilterRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateInvokeRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.UpdateErrors;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicSingleUpdateFuture
extends GridNearAtomicAbstractUpdateFuture {
    private Object key;
    private Object val;
    private GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState;

    public GridNearAtomicSingleUpdateFuture(GridCacheContext cctx, GridDhtAtomicCache cache, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, Object key, @Nullable Object val, @Nullable Object[] invokeArgs, boolean retval, boolean rawRetval, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, boolean recovery, int remapCnt) {
        super(cctx, cache, syncMode, op, invokeArgs, retval, rawRetval, expiryPlc, filter, subjId, taskNameHash, skipStore, keepBinary, recovery, remapCnt);
        assert (subjId != null);
        this.key = key;
        this.val = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNodeLeft(UUID nodeId) {
        long futId;
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        AffinityTopologyVersion remapTopVer0 = null;
        GridNearAtomicCheckUpdateRequest checkReq = null;
        boolean rcvAll = false;
        GridNearAtomicSingleUpdateFuture gridNearAtomicSingleUpdateFuture = this;
        synchronized (gridNearAtomicSingleUpdateFuture) {
            if (!this.futureMapped()) {
                return false;
            }
            futId = this.futId;
            if (this.reqState.req.nodeId.equals(nodeId)) {
                GridNearAtomicAbstractUpdateRequest req = this.reqState.onPrimaryFail();
                if (req != null) {
                    GridNearAtomicUpdateResponse res = this.primaryFailedResponse(req);
                    rcvAll = true;
                    this.reqState.onPrimaryResponse(res, this.cctx);
                    this.onPrimaryError(req, res);
                }
            } else {
                GridNearAtomicAbstractUpdateFuture.DhtLeftResult res = this.reqState.onDhtNodeLeft(nodeId);
                if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.DONE) {
                    rcvAll = true;
                } else if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.ALL_RCVD_CHECK_PRIMARY) {
                    checkReq = new GridNearAtomicCheckUpdateRequest(this.reqState.req);
                } else {
                    return false;
                }
            }
            if (rcvAll) {
                opRes0 = this.opRes;
                err0 = this.err;
                remapTopVer0 = this.onAllReceived();
            }
        }
        if (checkReq != null) {
            this.sendCheckUpdateRequest(checkReq);
        } else if (rcvAll) {
            this.finishUpdateFuture(opRes0, err0, remapTopVer0, futId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDhtResponse(UUID nodeId, GridDhtAtomicNearResponse res) {
        AffinityTopologyVersion remapTopVer0;
        CachePartialUpdateCheckedException err0;
        GridCacheReturn opRes0;
        GridNearAtomicSingleUpdateFuture gridNearAtomicSingleUpdateFuture = this;
        synchronized (gridNearAtomicSingleUpdateFuture) {
            if (!this.checkFutureId(res.futureId())) {
                return;
            }
            assert (this.reqState != null);
            assert (this.reqState.req.nodeId().equals(res.primaryId()));
            if (this.opRes == null && res.hasResult()) {
                this.opRes = res.result();
            }
            if (!this.reqState.onDhtResponse(nodeId, res)) {
                return;
            }
            opRes0 = this.opRes;
            err0 = this.err;
            remapTopVer0 = this.onAllReceived();
        }
        UpdateErrors errors = res.errors();
        if (errors != null) {
            assert (errors.error() != null);
            this.completeFuture(null, errors.error(), res.futureId());
            return;
        }
        this.finishUpdateFuture(opRes0, err0, remapTopVer0, res.futureId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPrimaryResponse(UUID nodeId, GridNearAtomicUpdateResponse res, boolean nodeErr) {
        AffinityTopologyVersion remapTopVer0;
        GridNearAtomicAbstractUpdateRequest req;
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        GridNearAtomicSingleUpdateFuture gridNearAtomicSingleUpdateFuture = this;
        synchronized (gridNearAtomicSingleUpdateFuture) {
            boolean remapKey;
            if (!this.checkFutureId(res.futureId())) {
                return;
            }
            req = this.reqState.processPrimaryResponse(nodeId, res);
            if (req == null) {
                return;
            }
            boolean bl = remapKey = res.remapTopologyVersion() != null;
            if (remapKey) {
                assert (!req.topologyVersion().equals(res.remapTopologyVersion()));
                assert (this.remapTopVer == null) : this.remapTopVer;
                this.remapTopVer = res.remapTopologyVersion();
            } else if (res.error() != null) {
                this.onPrimaryError(req, res);
            } else {
                GridCacheReturn ret = res.returnValue();
                if (this.op == GridCacheOperation.TRANSFORM) {
                    if (ret != null) {
                        assert (ret.value() == null || ret.value() instanceof Map) : ret.value();
                        if (ret.value() != null) {
                            if (this.opRes != null) {
                                this.opRes.mergeEntryProcessResults(ret);
                            } else {
                                this.opRes = ret;
                            }
                        }
                    }
                } else {
                    this.opRes = ret;
                }
                assert (this.reqState != null);
                if (!this.reqState.onPrimaryResponse(res, this.cctx)) {
                    return;
                }
            }
            remapTopVer0 = this.onAllReceived();
            if (remapTopVer0 == null) {
                err0 = this.err;
                opRes0 = this.opRes;
            }
        }
        if (res.error() != null && res.failedKeys() == null) {
            this.completeFuture(null, res.error(), res.futureId());
            return;
        }
        if (remapTopVer0 != null) {
            this.waitAndRemap(remapTopVer0);
            return;
        }
        if (this.nearEnabled && !nodeErr) {
            this.updateNear(req, res);
        }
        this.completeFuture(opRes0, err0, res.futureId());
    }

    private AffinityTopologyVersion onAllReceived() {
        assert (Thread.holdsLock(this));
        assert (this.futureMapped()) : this;
        AffinityTopologyVersion remapTopVer0 = null;
        if (this.remapTopVer == null) {
            ClusterTopologyCheckedException topErr;
            if (this.err != null && X.hasCause((Throwable)this.err, CachePartialUpdateCheckedException.class) && X.hasCause((Throwable)this.err, ClusterTopologyCheckedException.class) && this.storeFuture() && --this.remapCnt > 0 && !((topErr = X.cause(this.err, ClusterTopologyCheckedException.class)) instanceof ClusterTopologyServerNotFoundException)) {
                CachePartialUpdateCheckedException cause = X.cause(this.err, CachePartialUpdateCheckedException.class);
                assert (cause != null && cause.topologyVersion() != null) : this.err;
                remapTopVer0 = new AffinityTopologyVersion(cause.topologyVersion().topologyVersion() + 1L);
                this.err = null;
            }
        } else {
            remapTopVer0 = this.remapTopVer;
        }
        if (remapTopVer0 != null) {
            this.cctx.mvcc().removeAtomicFuture(this.futId);
            this.reqState = null;
            this.topVer = AffinityTopologyVersion.ZERO;
            this.futId = 0L;
            this.remapTopVer = null;
        }
        return remapTopVer0;
    }

    private void waitAndRemap(AffinityTopologyVersion remapTopVer) {
        if (this.topLocked) {
            CachePartialUpdateCheckedException e = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
            ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Failed to update keys, topology changed while execute atomic update inside transaction.");
            cause.retryReadyFuture(this.cctx.shared().exchange().affinityReadyFuture(remapTopVer));
            e.add(Collections.singleton(this.cctx.toCacheKeyObject(this.key)), cause);
            this.completeFuture(null, e, null);
            return;
        }
        IgniteInternalFuture<AffinityTopologyVersion> fut = this.cctx.shared().exchange().affinityReadyFuture(remapTopVer);
        if (fut == null) {
            fut = new GridFinishedFuture<AffinityTopologyVersion>(remapTopVer);
        }
        fut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

            @Override
            public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                GridNearAtomicSingleUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                    @Override
                    public void run() {
                        try (MTC.TraceSurroundings ignored = MTC.support(GridNearAtomicSingleUpdateFuture.this.cctx.kernalContext().tracing().create(SpanType.CACHE_API_UPDATE_MAP, MTC.span()));){
                            GridNearAtomicSingleUpdateFuture.this.mapOnTopology();
                        }
                    }
                });
            }
        });
    }

    private void updateNear(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        assert (this.nearEnabled);
        if (res.remapTopologyVersion() != null) {
            return;
        }
        GridNearAtomicCache near = (GridNearAtomicCache)this.cctx.dht().near();
        near.processNearAtomicUpdateResponse(req, res);
    }

    @Override
    protected void mapOnTopology() {
        if (this.cache.topology().stopping()) {
            this.completeFuture(null, this.cctx.shared().cache().isCacheRestarting(this.cache.name()) ? new IgniteCacheRestartingException(this.cache.name()) : new CacheStoppedException(this.cache.name()), null);
            return;
        }
        GridDhtTopologyFuture fut = this.cache.topology().topologyVersionFuture();
        if (fut.isDone()) {
            CacheInvalidStateException err = fut.validateCache(this.cctx, this.recovery, false, this.key, null);
            if (err != null) {
                this.completeFuture(null, err, null);
                return;
            }
        } else {
            assert (!this.topLocked) : this;
            fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> t2) {
                    GridNearAtomicSingleUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                        @Override
                        public void run() {
                            GridNearAtomicSingleUpdateFuture.this.mapOnTopology();
                        }
                    });
                }
            });
            return;
        }
        AffinityTopologyVersion topVer = fut.topologyVersion();
        this.map(topVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void map(AffinityTopologyVersion topVer) {
        MTC.span().addTag("topology.version", () -> Objects.toString(topVer));
        long futId = this.cctx.mvcc().nextAtomicId();
        Exception err = null;
        GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState0 = null;
        try {
            reqState0 = this.mapSingleUpdate(topVer, futId);
            GridNearAtomicSingleUpdateFuture gridNearAtomicSingleUpdateFuture = this;
            synchronized (gridNearAtomicSingleUpdateFuture) {
                assert (topVer.topologyVersion() > 0L) : topVer;
                assert (this.topVer == AffinityTopologyVersion.ZERO) : this;
                this.topVer = topVer;
                this.futId = futId;
                this.reqState = reqState0;
            }
            if (this.storeFuture() && !this.cctx.mvcc().addAtomicFuture(futId, this)) {
                assert (this.isDone());
                return;
            }
        }
        catch (Exception e) {
            err = e;
        }
        if (err != null) {
            this.completeFuture(null, err, futId);
            return;
        }
        this.sendSingleRequest(reqState0.req.nodeId(), reqState0.req);
        if (this.syncMode == CacheWriteSynchronizationMode.FULL_ASYNC) {
            this.completeFuture(new GridCacheReturn(this.cctx, true, true, null, null, true), null, null);
            return;
        }
        if (reqState0.req.initMappingLocally() && this.cctx.discovery().topologyVersion() != topVer.topologyVersion()) {
            this.checkDhtNodes(futId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDhtNodes(long futId) {
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        AffinityTopologyVersion remapTopVer0 = null;
        GridNearAtomicCheckUpdateRequest checkReq = null;
        GridNearAtomicSingleUpdateFuture gridNearAtomicSingleUpdateFuture = this;
        synchronized (gridNearAtomicSingleUpdateFuture) {
            if (!this.checkFutureId(futId)) {
                return;
            }
            assert (this.reqState != null);
            GridNearAtomicAbstractUpdateFuture.DhtLeftResult res = this.reqState.checkDhtNodes(this.cctx);
            if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.DONE) {
                opRes0 = this.opRes;
                err0 = this.err;
                remapTopVer0 = this.onAllReceived();
            } else if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.ALL_RCVD_CHECK_PRIMARY) {
                checkReq = new GridNearAtomicCheckUpdateRequest(this.reqState.req);
            } else {
                return;
            }
        }
        if (checkReq != null) {
            this.sendCheckUpdateRequest(checkReq);
        } else {
            this.finishUpdateFuture(opRes0, err0, remapTopVer0, futId);
        }
    }

    private GridNearAtomicAbstractUpdateFuture.PrimaryRequestState mapSingleUpdate(AffinityTopologyVersion topVer, long futId) throws Exception {
        if (this.key == null) {
            throw new NullPointerException("Null key.");
        }
        EntryProcessor val = this.val;
        if (val == null && this.op != GridCacheOperation.DELETE) {
            throw new NullPointerException("Null value.");
        }
        KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(this.key);
        if (this.op != GridCacheOperation.TRANSFORM) {
            val = this.cctx.toCacheObject(val);
            if (this.op == GridCacheOperation.CREATE || this.op == GridCacheOperation.UPDATE) {
                this.cctx.validateKeyAndValue(cacheKey, (CacheObject)((Object)val));
            }
        } else {
            val = EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), val);
        }
        boolean mappingKnown = this.cctx.topology().rebalanceFinished(topVer);
        List<ClusterNode> nodes = this.cctx.affinity().nodesByKey(cacheKey, topVer);
        if (F.isEmpty(nodes)) {
            throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
        }
        ClusterNode primary = nodes.get(0);
        boolean needPrimaryRes = !mappingKnown || primary.isLocal() || nodes.size() == 1 || this.nearEnabled;
        byte flags = GridNearAtomicAbstractUpdateRequest.flags(this.nearEnabled, this.topLocked, this.retval, mappingKnown, needPrimaryRes, this.skipStore, this.keepBinary, this.recovery);
        GridNearAtomicAbstractUpdateRequest req = this.canUseSingleRequest() ? (this.op == GridCacheOperation.TRANSFORM ? new GridNearAtomicSingleUpdateInvokeRequest(this.cctx.cacheId(), primary.id(), futId, topVer, this.syncMode, this.op, this.invokeArgs, this.subjId, this.taskNameHash, flags, this.cctx.deploymentEnabled()) : (this.filter == null || this.filter.length == 0 ? new GridNearAtomicSingleUpdateRequest(this.cctx.cacheId(), primary.id(), futId, topVer, this.syncMode, this.op, this.subjId, this.taskNameHash, flags, this.cctx.deploymentEnabled()) : new GridNearAtomicSingleUpdateFilterRequest(this.cctx.cacheId(), primary.id(), futId, topVer, this.syncMode, this.op, this.filter, this.subjId, this.taskNameHash, flags, this.cctx.deploymentEnabled()))) : new GridNearAtomicFullUpdateRequest(this.cctx.cacheId(), primary.id(), futId, topVer, this.syncMode, this.op, this.expiryPlc, this.invokeArgs, this.filter, this.subjId, this.taskNameHash, flags, this.cctx.deploymentEnabled(), 1);
        ((GridNearAtomicAbstractUpdateRequest)req).addUpdateEntry(cacheKey, val, -1L, -1L, null);
        return new GridNearAtomicAbstractUpdateFuture.PrimaryRequestState(req, nodes, true);
    }

    private void finishUpdateFuture(GridCacheReturn opRes, CachePartialUpdateCheckedException err, @Nullable AffinityTopologyVersion remapTopVer, long futId) {
        if (remapTopVer != null) {
            this.waitAndRemap(remapTopVer);
            return;
        }
        if (this.nearEnabled) {
            assert (this.reqState.req.response() != null);
            this.updateNear(this.reqState.req, this.reqState.req.response());
        }
        this.completeFuture(opRes, err, futId);
    }

    private boolean canUseSingleRequest() {
        return this.expiryPlc == null;
    }

    @Override
    public synchronized String toString() {
        return S.toString(GridNearAtomicSingleUpdateFuture.class, this, super.toString());
    }
}

