/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxEnlistResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public final class NearTxResultHandler
implements CI1<IgniteInternalFuture<GridCacheReturn>> {
    private static final long serialVersionUID = 0L;
    private static final NearTxResultHandler INSTANCE = new NearTxResultHandler();

    private NearTxResultHandler() {
    }

    public static NearTxResultHandler instance() {
        return INSTANCE;
    }

    public static <T> T createResponse(IgniteInternalFuture<?> future) {
        assert (future != null);
        Class<?> clazz = future.getClass();
        if (clazz == GridDhtTxEnlistFuture.class) {
            return (T)NearTxResultHandler.createResponse((GridDhtTxEnlistFuture)future);
        }
        throw new IllegalStateException();
    }

    public static GridNearTxEnlistResponse createResponse(GridDhtTxEnlistFuture fut) {
        try {
            GridCacheReturn res = (GridCacheReturn)fut.get();
            GridCacheVersion ver = null;
            IgniteUuid id = null;
            if (fut.hasNearNodeUpdates) {
                ver = fut.cctx.tm().mappedVersion(fut.nearLockVer);
                id = fut.futId;
            }
            return new GridNearTxEnlistResponse(fut.cctx.cacheId(), fut.nearFutId, fut.nearMiniId, fut.nearLockVer, res, ver, id, fut.newDhtNodes);
        }
        catch (IgniteCheckedException e) {
            return new GridNearTxEnlistResponse(fut.cctx.cacheId(), fut.nearFutId, fut.nearMiniId, fut.nearLockVer, e);
        }
    }

    @Override
    public void apply(IgniteInternalFuture<GridCacheReturn> fut0) {
        GridDhtTxAbstractEnlistFuture fut = (GridDhtTxAbstractEnlistFuture)fut0;
        GridCacheContext<?, ?> cctx = fut.cctx;
        GridDhtTxLocal tx = (GridDhtTxLocal)fut.tx;
        UUID nearNodeId = fut.nearNodeId;
        GridNearTxEnlistResponse res = (GridNearTxEnlistResponse)NearTxResultHandler.createResponse(fut);
        try {
            cctx.io().send(nearNodeId, (GridCacheMessage)res, cctx.ioPolicy());
        }
        catch (IgniteCheckedException e) {
            U.error(fut.log, "Failed to send near enlist response (will rollback transaction) [tx=" + CU.txString(tx) + ", node=" + nearNodeId + ", res=" + res + ']', e);
            try {
                tx.rollbackDhtLocalAsync();
            }
            catch (Throwable e1) {
                e.addSuppressed(e1);
            }
            throw new GridClosureException(e);
        }
    }
}

