/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtTxLocalAdapter
extends IgniteTxLocalAdapter {
    private static final long serialVersionUID = 0L;
    public static final IgniteInternalFuture<Boolean> ROLLBACK_FUT = new GridFutureAdapter<Boolean>();
    private static final AtomicReferenceFieldUpdater<GridDhtTxLocalAdapter, IgniteInternalFuture> LOCK_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridDhtTxLocalAdapter.class, IgniteInternalFuture.class, "lockFut");
    protected Map<UUID, GridDistributedTxMapping> nearMap = new ConcurrentHashMap<UUID, GridDistributedTxMapping>();
    protected Map<UUID, GridDistributedTxMapping> dhtMap = new ConcurrentHashMap<UUID, GridDistributedTxMapping>();
    protected volatile boolean mapped;
    protected boolean explicitLock;
    private Collection<GridCacheVersion> pendingVers;
    private boolean nearOnOriginatingNode;
    private Set<ClusterNode> lockTxNodes;
    @GridToStringExclude
    protected volatile IgniteInternalFuture<?> lockFut;

    protected GridDhtTxLocalAdapter() {
    }

    protected GridDhtTxLocalAdapter(GridCacheSharedContext cctx, GridCacheVersion xidVer, boolean implicit, boolean implicitSingle, boolean sys, boolean explicitLock, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean invalidate, boolean storeEnabled, boolean onePhaseCommit, int txSize, @Nullable UUID subjId, int taskNameHash) {
        super(cctx, xidVer, implicit, implicitSingle, sys, plc, concurrency, isolation, timeout, invalidate, storeEnabled, onePhaseCommit, txSize, subjId, taskNameHash);
        assert (cctx != null);
        this.explicitLock = explicitLock;
        this.threadId = Thread.currentThread().getId();
    }

    void addLockTransactionNode(ClusterNode node) {
        assert (node != null);
        assert (!node.isLocal());
        if (this.lockTxNodes == null) {
            this.lockTxNodes = new HashSet<ClusterNode>();
        }
        this.lockTxNodes.add(node);
    }

    public void nearOnOriginatingNode(boolean hasNear) {
        this.nearOnOriginatingNode = hasNear;
    }

    boolean nearOnOriginatingNode() {
        return this.nearOnOriginatingNode;
    }

    public boolean explicitLock() {
        return this.explicitLock;
    }

    public void explicitLock(boolean explicitLock) {
        this.explicitLock = explicitLock;
    }

    @Nullable
    Set<ClusterNode> lockTransactionNodes() {
        return this.lockTxNodes;
    }

    protected abstract UUID nearNodeId();

    protected abstract IgniteUuid nearFutureId();

    @Nullable
    protected abstract IgniteInternalFuture<Boolean> addReader(long var1, GridDhtCacheEntry var3, IgniteTxEntry var4, AffinityTopologyVersion var5);

    protected abstract void sendFinishReply(@Nullable Throwable var1);

    @Override
    public boolean needsCompletedVersions() {
        return this.nearOnOriginatingNode;
    }

    Collection<GridCacheVersion> pendingVersions() {
        return this.pendingVers == null ? Collections.emptyList() : this.pendingVers;
    }

    public void pendingVersions(Collection<GridCacheVersion> pendingVers) {
        this.pendingVers = pendingVers;
    }

    protected void mapExplicitLocks() {
        if (!this.mapped) {
            if (!this.implicit()) {
                this.mapped = true;
                return;
            }
            GridLeanMap<ClusterNode, List<GridDhtCacheEntry>> dhtEntryMap = null;
            GridLeanMap<ClusterNode, List<GridDhtCacheEntry>> nearEntryMap = null;
            block2: for (IgniteTxEntry e : this.allEntries()) {
                assert (e.cached() != null);
                GridCacheContext cacheCtx = e.cached().context();
                if (cacheCtx.isNear()) continue;
                if (e.cached().obsolete()) {
                    GridCacheEntryEx cached = cacheCtx.cache().entryEx(e.key(), this.topologyVersion());
                    e.cached(cached);
                }
                if (e.cached().detached() || e.cached().isLocal()) continue;
                while (true) {
                    try {
                        if (e.explicitVersion() == null || e.explicitVersion().equals(this.xidVer)) continue block2;
                        if (dhtEntryMap == null) {
                            dhtEntryMap = new GridLeanMap<ClusterNode, List<GridDhtCacheEntry>>();
                        }
                        if (nearEntryMap == null) {
                            nearEntryMap = new GridLeanMap<ClusterNode, List<GridDhtCacheEntry>>();
                        }
                        cacheCtx.dhtMap((GridDhtCacheEntry)e.cached(), e.explicitVersion(), log, dhtEntryMap, nearEntryMap);
                        continue block2;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        GridCacheEntryEx cached = cacheCtx.cache().entryEx(e.key(), this.topologyVersion());
                        e.cached(cached);
                        continue;
                    }
                    break;
                }
            }
            if (!F.isEmpty(dhtEntryMap)) {
                this.addDhtNodeEntryMapping(dhtEntryMap);
            }
            if (!F.isEmpty(nearEntryMap)) {
                this.addNearNodeEntryMapping(nearEntryMap);
            }
            this.mapped = true;
        }
    }

    Map<UUID, GridDistributedTxMapping> dhtMap() {
        this.mapExplicitLocks();
        return this.dhtMap;
    }

    Map<UUID, GridDistributedTxMapping> nearMap() {
        this.mapExplicitLocks();
        return this.nearMap;
    }

    private void addDhtNodeEntryMapping(Map<ClusterNode, List<GridDhtCacheEntry>> mappings) {
        this.addMapping(mappings, this.dhtMap);
    }

    private void addNearNodeEntryMapping(Map<ClusterNode, List<GridDhtCacheEntry>> mappings) {
        this.addMapping(mappings, this.nearMap);
    }

    public boolean removeMapping(UUID nodeId) {
        return this.removeMapping(nodeId, null, this.dhtMap) | this.removeMapping(nodeId, null, this.nearMap);
    }

    boolean removeDhtMapping(UUID nodeId, GridCacheEntryEx entry) {
        return this.removeMapping(nodeId, entry, this.dhtMap);
    }

    boolean removeNearMapping(UUID nodeId, GridCacheEntryEx entry) {
        return this.removeMapping(nodeId, entry, this.nearMap);
    }

    private boolean removeMapping(UUID nodeId, @Nullable GridCacheEntryEx entry, Map<UUID, GridDistributedTxMapping> map) {
        if (entry != null) {
            boolean ret;
            IgniteTxEntry txEntry;
            if (log.isDebugEnabled()) {
                log.debug("Removing mapping for entry [nodeId=" + nodeId + ", entry=" + entry + ']');
            }
            if ((txEntry = this.entry(entry.txKey())) == null) {
                return false;
            }
            GridDistributedTxMapping m4 = map.get(nodeId);
            boolean bl = ret = m4 != null && m4.removeEntry(txEntry);
            if (m4 != null && m4.empty()) {
                map.remove(nodeId);
            }
            return ret;
        }
        return map.remove(nodeId) != null;
    }

    private void addMapping(Map<ClusterNode, List<GridDhtCacheEntry>> mappings, Map<UUID, GridDistributedTxMapping> dst) {
        for (Map.Entry<ClusterNode, List<GridDhtCacheEntry>> mapping : mappings.entrySet()) {
            ClusterNode n = mapping.getKey();
            GridDistributedTxMapping m4 = dst.get(n.id());
            List<GridDhtCacheEntry> entries = mapping.getValue();
            for (GridDhtCacheEntry entry : entries) {
                IgniteTxEntry txEntry = this.entry(entry.txKey());
                if (txEntry == null) continue;
                if (m4 == null) {
                    m4 = new GridDistributedTxMapping(n);
                    dst.put(n.id(), m4);
                }
                m4.add(txEntry);
            }
        }
    }

    @Override
    public void addInvalidPartition(int cacheId, int part) {
        assert (false) : "DHT transaction encountered invalid partition [part=" + part + ", tx=" + this + ']';
    }

    @Nullable
    public IgniteInternalFuture<Boolean> addEntry(long msgId, IgniteTxEntry e) throws IgniteCheckedException {
        this.init();
        TransactionState state = this.state();
        assert (state == TransactionState.PREPARING) : "Invalid tx state for adding entry [msgId=" + msgId + ", e=" + e + ", tx=" + this + ']';
        e.unmarshal(this.cctx, false, this.cctx.deploy().globalLoader());
        this.checkInternal(e.txKey());
        GridCacheContext<?, ?> cacheCtx = e.context();
        GridDhtCacheAdapter<?, ?> dhtCache = cacheCtx.isNear() ? cacheCtx.near().dht() : cacheCtx.dht();
        try {
            IgniteTxEntry existing = this.entry(e.txKey());
            if (existing != null) {
                existing.op(e.op());
                existing.value(e.value(), e.hasWriteValue(), e.hasReadValue());
                existing.entryProcessors(e.entryProcessors());
                existing.ttl(e.ttl());
                existing.filters(e.filters());
                existing.expiry(e.expiry());
                existing.conflictExpireTime(e.conflictExpireTime());
                existing.conflictVersion(e.conflictVersion());
            } else {
                existing = e;
                this.addActiveCache(dhtCache.context(), false);
                GridDhtCacheEntry cached = dhtCache.entryExx(existing.key(), this.topologyVersion());
                existing.cached(cached);
                GridCacheVersion explicit = existing.explicitVersion();
                if (explicit != null) {
                    GridCacheVersion dhtVer = this.cctx.mvcc().mappedVersion(explicit);
                    if (dhtVer == null) {
                        throw new IgniteCheckedException("Failed to find dht mapping for explicit entry version: " + existing);
                    }
                    existing.explicitVersion(dhtVer);
                }
                this.txState.addEntry(existing);
                if (log.isDebugEnabled()) {
                    log.debug("Added entry to transaction: " + existing);
                }
            }
            return this.addReader(msgId, dhtCache.entryExx(existing.key()), existing, this.topologyVersion());
        }
        catch (GridDhtInvalidPartitionException ex) {
            throw new IgniteCheckedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgniteInternalFuture<GridCacheReturn> lockAllAsync(GridCacheContext cacheCtx, List<GridCacheEntryEx> entries, long msgId, boolean read, boolean needRetVal, long createTtl, long accessTtl, boolean skipStore, boolean keepBinary, boolean nearCache) {
        try {
            this.checkValid();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(entries)) {
            return new GridFinishedFuture<GridCacheReturn>(ret);
        }
        this.init();
        this.onePhaseCommit(this.onePhaseCommit);
        try {
            Collection<KeyCacheObject> passedKeys;
            GridFutureAdapter enlistFut = new GridFutureAdapter();
            if (!this.updateLockFuture(null, enlistFut)) {
                return this.finishFuture(enlistFut, this.timedOut() ? this.timeoutException() : this.rollbackException(), false);
            }
            GridLeanSet<KeyCacheObject> skipped = null;
            try {
                AffinityTopologyVersion topVer = this.topologyVersion();
                GridDhtCacheAdapter dhtCache = cacheCtx.isNear() ? cacheCtx.near().dht() : cacheCtx.dht();
                for (int i = 0; i < entries.size(); ++i) {
                    GridCacheEntryEx entry = entries.get(i);
                    KeyCacheObject key = entry.key();
                    IgniteTxEntry txEntry = this.entry(entry.txKey());
                    if (txEntry == null) {
                        GridDhtCacheEntry cached;
                        while (true) {
                            try {
                                cached = dhtCache.entryExx(key, topVer);
                                cached.unswap(read);
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Get removed entry: " + key);
                                continue;
                            }
                            break;
                        }
                        this.addActiveCache(dhtCache.context(), false);
                        txEntry = this.addEntry(GridCacheOperation.NOOP, null, null, null, cached, null, CU.empty0(), false, -1L, -1L, null, skipStore, keepBinary, nearCache);
                        if (read) {
                            txEntry.ttl(accessTtl);
                        }
                        txEntry.cached(cached);
                        this.addReader(msgId, cached, txEntry, topVer);
                        continue;
                    }
                    if (skipped == null) {
                        skipped = new GridLeanSet<KeyCacheObject>();
                    }
                    skipped.add(key);
                }
            }
            finally {
                this.finishFuture(enlistFut, null, true);
            }
            assert (this.pessimistic());
            Collection<KeyCacheObject> keys = F.viewReadOnly(entries, CU.entry2Key(), new IgnitePredicate[0]);
            Collection<KeyCacheObject> collection = passedKeys = skipped != null ? F.view(keys, F0.notIn(skipped)) : keys;
            if (log.isDebugEnabled()) {
                log.debug("Lock keys: " + passedKeys);
            }
            return this.obtainLockAsync(cacheCtx, ret, passedKeys, read, needRetVal, createTtl, accessTtl, skipStore, keepBinary);
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
    }

    private IgniteInternalFuture<GridCacheReturn> obtainLockAsync(final GridCacheContext cacheCtx, GridCacheReturn ret, final Collection<KeyCacheObject> passedKeys, final boolean read, boolean needRetVal, long createTtl, final long accessTtl, boolean skipStore, boolean keepBinary) {
        if (log.isDebugEnabled()) {
            log.debug("Before acquiring transaction lock on keys [keys=" + passedKeys + ']');
        }
        if (passedKeys.isEmpty()) {
            return new GridFinishedFuture<GridCacheReturn>(ret);
        }
        GridDhtCacheAdapter dhtCache = cacheCtx.isNear() ? cacheCtx.nearTx().dht() : cacheCtx.dhtTx();
        long timeout = this.remainingTime();
        if (timeout == -1L) {
            return new GridFinishedFuture<GridCacheReturn>(this.timeoutException());
        }
        if (this.isRollbackOnly()) {
            return new GridFinishedFuture<GridCacheReturn>(this.rollbackException());
        }
        GridDhtFuture<Boolean> fut = ((GridDhtTransactionalCacheAdapter)dhtCache).lockAllAsyncInternal(passedKeys, timeout, this, this.isInvalidate(), read, needRetVal, this.isolation, createTtl, accessTtl, CU.empty0(), skipStore, keepBinary);
        return new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(ret){

            @Override
            protected GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                if (log.isDebugEnabled()) {
                    log.debug("Acquired transaction lock on keys: " + passedKeys);
                }
                GridDhtTxLocalAdapter.this.postLockWrite(cacheCtx, passedKeys, ret, false, false, read, accessTtl, CU.empty0(), false);
                return ret;
            }
        });
    }

    @Override
    public boolean localFinish(boolean commit, boolean clearThreadMap) throws IgniteCheckedException {
        IgniteCheckedException err;
        block18: {
            if (log.isDebugEnabled()) {
                log.debug("Finishing dht local tx [tx=" + this + ", commit=" + commit + "]");
            }
            if (this.optimistic()) {
                this.state(TransactionState.PREPARED);
            }
            if (commit) {
                if (!this.state(TransactionState.COMMITTING)) {
                    TransactionState state = this.state();
                    if (state != TransactionState.COMMITTING && state != TransactionState.COMMITTED) {
                        throw new IgniteCheckedException("Invalid transaction state for commit [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']');
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Invalid transaction state for commit (another thread is committing): " + this);
                    }
                    return false;
                }
            } else if (!this.state(TransactionState.ROLLING_BACK)) {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid transaction state for rollback [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']');
                }
                return false;
            }
            err = null;
            try {
                if (commit && !this.isRollbackOnly()) {
                    this.userCommit();
                } else {
                    this.userRollback(clearThreadMap);
                }
            }
            catch (IgniteCheckedException e) {
                err = e;
                commit = false;
                if (this.isRollbackOnly()) break block18;
                this.systemInvalidate(true);
                U.warn(log, "Set transaction invalidation flag to true due to error [tx=" + CU.txString(this) + ", err=" + err + ']');
            }
        }
        if (err != null) {
            this.state(TransactionState.UNKNOWN);
            throw err;
        }
        if (commit) {
            if (!this.onePhaseCommit() && !this.state(TransactionState.COMMITTED)) {
                this.state(TransactionState.UNKNOWN);
                throw new IgniteCheckedException("Invalid transaction state for commit: " + this);
            }
        } else if (!this.state(TransactionState.ROLLED_BACK)) {
            this.state(TransactionState.UNKNOWN);
            throw new IgniteCheckedException("Invalid transaction state for rollback: " + this);
        }
        return true;
    }

    protected abstract void clearPrepareFuture(GridDhtTxPrepareFuture var1);

    public final boolean commitOnPrepare() {
        return this.onePhaseCommit() && !this.near() && !this.nearOnOriginatingNode;
    }

    public IgniteInternalFuture<?> lockFuture() {
        return this.lockFut;
    }

    public boolean updateLockFuture(IgniteInternalFuture<?> oldFut, IgniteInternalFuture<?> newFut) {
        return LOCK_FUT_UPD.compareAndSet(this, oldFut, newFut);
    }

    public void clearLockFuture(@Nullable IgniteInternalFuture cond) {
        IgniteInternalFuture<?> f;
        while (!((f = this.lockFut) == null || f == ROLLBACK_FUT || cond != null && f != cond || this.updateLockFuture(f, null))) {
        }
    }

    public <T> GridFutureAdapter<T> finishFuture(GridFutureAdapter<T> f, Throwable err, boolean clearLockFut) {
        if (clearLockFut) {
            this.clearLockFuture(null);
        }
        f.onDone(err);
        return f;
    }

    @Nullable
    public IgniteInternalFuture<?> tryRollbackAsync() {
        IgniteInternalFuture<?> fut;
        do {
            if ((fut = this.lockFut) != ROLLBACK_FUT) continue;
            return null;
        } while (!this.updateLockFuture(fut, ROLLBACK_FUT));
        return fut;
    }

    protected final IgniteInternalFuture<GridNearTxPrepareResponse> chainOnePhasePrepare(final GridDhtTxPrepareFuture prepFut) {
        if (this.commitOnPrepare()) {
            return this.finishFuture().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, GridNearTxPrepareResponse>(){

                @Override
                public GridNearTxPrepareResponse applyx(IgniteInternalFuture<IgniteInternalTx> finishFut) throws IgniteCheckedException {
                    return (GridNearTxPrepareResponse)prepFut.get();
                }
            });
        }
        return prepFut;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDhtTxLocalAdapter.class, this, "nearNodes", this.nearMap.keySet(), "dhtNodes", this.dhtMap.keySet(), "explicitLock", (Object)this.explicitLock, "super", (Object)super.toString());
    }

    public void incrementLockCounter() {
        this.txCounters(true).incrementLockCounter();
    }

    public int lockCounter() {
        TxCounters txCntrs = this.txCounters(false);
        return txCntrs != null ? txCntrs.lockCounter() : 0;
    }
}

