/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ExchangeContext {
    @SystemProperty(value="Enables the compatibility mode for the exchange protocol of version 1")
    public static final String IGNITE_EXCHANGE_COMPATIBILITY_VER_1 = "IGNITE_EXCHANGE_COMPATIBILITY_VER_1";
    private Set<Integer> requestGrpsAffOnJoin;
    private boolean fetchAffOnJoin;
    private boolean exchangeFreeSwitch;
    private final boolean merge;
    private final ExchangeDiscoveryEvents evts;
    private final boolean compatibilityNode = IgniteSystemProperties.getBoolean("IGNITE_EXCHANGE_COMPATIBILITY_VER_1", false);
    private final boolean bltForVolatileCachesSup = SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_FOR_IN_MEMORY_CACHES_FEATURE");
    private final boolean supFreeSwitch;

    public ExchangeContext(boolean crd, GridDhtPartitionsExchangeFuture fut) {
        int protocolVer = GridCachePartitionExchangeManager.exchangeProtocolVersion(fut.firstEventCache().minimumNodeVersion());
        this.supFreeSwitch = IgniteFeatures.allNodesSupports(fut.sharedContext().kernalContext(), fut.firstEventCache().allNodes(), IgniteFeatures.PME_FREE_SWITCH);
        if (!this.compatibilityNode && fut.wasRebalanced() && fut.isBaselineNodeFailed() && this.supFreeSwitch && (this.bltForVolatileCachesSup || CU.dataRegions(fut.firstEventCache().allNodes(), fut.sharedContext().kernalContext().marshallerContext().jdkMarshaller(), U.resolveClassLoader(fut.sharedContext().kernalContext().config())).allMatch(DataRegionConfiguration::isPersistenceEnabled))) {
            this.exchangeFreeSwitch = true;
            this.merge = false;
        } else if (this.compatibilityNode || crd && fut.localJoinExchange()) {
            this.fetchAffOnJoin = true;
            this.merge = false;
        } else {
            boolean startCaches = fut.exchangeId().isJoined() && fut.sharedContext().cache().hasCachesReceivedFromJoin(fut.exchangeId().eventNode());
            this.fetchAffOnJoin = protocolVer == 1;
            this.merge = !startCaches && protocolVer > 1 && fut.firstEvent().type() != 18;
        }
        this.evts = new ExchangeDiscoveryEvents(fut);
    }

    boolean supportsMergeExchanges(ClusterNode node) {
        return !this.compatibilityNode && GridCachePartitionExchangeManager.exchangeProtocolVersion(node.version()) > 1;
    }

    public boolean supportsFreeSwitch() {
        return this.supFreeSwitch;
    }

    public ExchangeDiscoveryEvents events() {
        return this.evts;
    }

    public boolean fetchAffinityOnJoin() {
        return this.fetchAffOnJoin;
    }

    public boolean exchangeFreeSwitch() {
        return this.exchangeFreeSwitch;
    }

    synchronized void addGroupAffinityRequestOnJoin(Integer grpId) {
        if (this.requestGrpsAffOnJoin == null) {
            this.requestGrpsAffOnJoin = new HashSet<Integer>();
        }
        this.requestGrpsAffOnJoin.add(grpId);
    }

    @Nullable
    public synchronized Set<Integer> groupsAffinityRequestOnJoin() {
        return this.requestGrpsAffOnJoin;
    }

    public boolean mergeExchanges() {
        return this.merge;
    }

    public String toString() {
        return S.toString(ExchangeContext.class, this);
    }
}

