/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderQuery;

public class IoStatisticsQueryHelper {
    private static final ThreadLocal<IoStatisticsHolderQuery> CUR_QRY_STATS = new ThreadLocal();

    public static void startGatheringQueryStatistics(String qryId) {
        IoStatisticsHolderQuery currQryStatisticsHolder = CUR_QRY_STATS.get();
        assert (currQryStatisticsHolder == null) : currQryStatisticsHolder;
        CUR_QRY_STATS.set(new IoStatisticsHolderQuery(qryId));
    }

    public static void mergeQueryStatistics(IoStatisticsHolderQuery qryStat) {
        assert (qryStat != null);
        IoStatisticsHolderQuery currQryStatisticsHolder = CUR_QRY_STATS.get();
        assert (currQryStatisticsHolder != null);
        currQryStatisticsHolder.merge(qryStat.logicalReads(), qryStat.physicalReads());
    }

    public static IoStatisticsHolder finishGatheringQueryStatistics() {
        IoStatisticsHolderQuery currQryStatisticsHolder = CUR_QRY_STATS.get();
        assert (currQryStatisticsHolder != null);
        CUR_QRY_STATS.remove();
        return currQryStatisticsHolder;
    }

    static void trackLogicalReadQuery(long pageAddr) {
        IoStatisticsHolderQuery currQryStatisticsHolder = CUR_QRY_STATS.get();
        if (currQryStatisticsHolder != null) {
            currQryStatisticsHolder.trackLogicalRead(pageAddr);
        }
    }

    static void trackPhysicalAndLogicalReadQuery(long pageAddr) {
        IoStatisticsHolderQuery currQryStatisticsHolder = CUR_QRY_STATS.get();
        if (currQryStatisticsHolder != null) {
            currQryStatisticsHolder.trackPhysicalAndLogicalRead(pageAddr);
        }
    }
}

