/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.systemview.AbstractSystemViewExporterSpi;
import org.apache.ignite.internal.managers.systemview.FiltrableSystemViewLocal;
import org.apache.ignite.internal.managers.systemview.SystemViewLocal;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemView;

class SqlViewExporterSpi
extends AbstractSystemViewExporterSpi {
    private SchemaManager mgr;

    SqlViewExporterSpi() {
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        GridKernalContext ctx = ((IgniteEx)this.ignite()).context();
        if (ctx.query().getIndexing() instanceof IgniteH2Indexing) {
            this.mgr = ((IgniteH2Indexing)ctx.query().getIndexing()).schemaManager();
            this.sysViewReg.forEach(this::register);
            this.sysViewReg.addSystemViewCreationListener(this::register);
        }
    }

    private void register(SystemView<?> sysView) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found new system view [name=" + sysView.name() + ']');
        }
        GridKernalContext ctx = ((IgniteEx)this.ignite()).context();
        SystemViewLocal view = sysView instanceof FiltrableSystemView ? new FiltrableSystemViewLocal(ctx, sysView) : new SystemViewLocal(ctx, sysView);
        try {
            this.mgr.createSystemView(QueryUtils.sysSchemaName(), view);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException(e);
        }
    }
}

