/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.maintenance;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.Ignition;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.maintenance.MaintenanceFileStore;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaintenanceProcessor
extends GridProcessorAdapter
implements MaintenanceRegistry {
    private static final String DISABLED_ERR_MSG = "Maintenance Mode is not supported for in-memory and client nodes";
    private static final Pattern ALPHANUMERIC_UNDERSCORE = Pattern.compile("^[a-zA-Z_0-9]+$");
    public static final int DFLT_MAINTENANCE_MODE_EXIT_CODE = 0;
    private final Map<String, MaintenanceTask> activeTasks = new ConcurrentHashMap<String, MaintenanceTask>();
    private final Map<String, MaintenanceTask> requestedTasks = new ConcurrentHashMap<String, MaintenanceTask>();
    private final Map<String, MaintenanceWorkflowCallback> workflowCallbacks = new ConcurrentHashMap<String, MaintenanceWorkflowCallback>();
    private final MaintenanceFileStore fileStorage;
    private final boolean disabled;
    private volatile boolean maintenanceMode;
    private final boolean autoShutdown = IgniteSystemProperties.getBoolean("IGNITE_MAINTENANCE_AUTO_SHUTDOWN_AFTER_RECOVERY");
    private final int mntcModeExitCode = IgniteSystemProperties.getInteger("IGNITE_MAINTENANCE_MODE_EXIT_CODE", 0);

    public MaintenanceProcessor(GridKernalContext ctx) {
        super(ctx);
        boolean bl = this.disabled = !CU.isPersistenceEnabled(ctx.config()) || ctx.clientNode();
        if (this.disabled) {
            this.fileStorage = new MaintenanceFileStore(true, null, null, null);
            return;
        }
        this.fileStorage = new MaintenanceFileStore(false, ctx.pdsFolderResolver(), ctx.config().getDataStorageConfiguration().getFileIOFactory(), this.log);
    }

    @Override
    @Nullable
    public MaintenanceTask registerMaintenanceTask(MaintenanceTask task) throws IgniteCheckedException {
        return this.registerMaintenanceTask0(task, null);
    }

    @Override
    public void registerMaintenanceTask(MaintenanceTask task, UnaryOperator<MaintenanceTask> remappingFunction) throws IgniteCheckedException {
        assert (remappingFunction != null);
        this.registerMaintenanceTask0(task, remappingFunction);
    }

    @Nullable
    private MaintenanceTask registerMaintenanceTask0(MaintenanceTask task, @Nullable UnaryOperator<MaintenanceTask> remappingFunction) throws IgniteCheckedException {
        MaintenanceTask oldTask;
        MaintenanceTask taskToWrite;
        if (this.disabled) {
            throw new IgniteCheckedException(DISABLED_ERR_MSG);
        }
        if (this.isMaintenanceMode()) {
            throw new IgniteCheckedException("Node is already in Maintenance Mode, registering additional maintenance task is not allowed in Maintenance Mode.");
        }
        if (remappingFunction != null) {
            taskToWrite = this.requestedTasks.compute(task.name(), (taskName, prevTask) -> {
                if (prevTask != null) {
                    return (MaintenanceTask)remappingFunction.apply((MaintenanceTask)prevTask);
                }
                return task;
            });
            oldTask = null;
        } else {
            taskToWrite = task;
            oldTask = this.requestedTasks.put(task.name(), task);
            if (oldTask != null) {
                this.log.info("Maintenance Task with name " + task.name() + " is already registered" + (oldTask.parameters() != null ? " with parameters " + oldTask.parameters() : ".") + " It will be replaced with new task" + task.parameters() != null ? " with parameters " + task.parameters() : ".");
            }
        }
        try {
            this.fileStorage.writeMaintenanceTask(taskToWrite);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to register maintenance task " + task, e);
        }
        return oldTask;
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        try {
            this.fileStorage.stop();
        }
        catch (IOException e) {
            this.log.warning("Failed to free maintenance file resources", e);
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.disabled) {
            return;
        }
        try {
            this.fileStorage.init();
            this.activeTasks.putAll(this.fileStorage.getAllTasks());
            this.maintenanceMode = !this.activeTasks.isEmpty();
        }
        catch (Throwable t2) {
            this.log.warning("Caught exception when starting MaintenanceProcessor, maintenance mode won't be entered", t2);
            this.activeTasks.clear();
            this.fileStorage.clear();
        }
    }

    @Override
    public void prepareAndExecuteMaintenance() {
        if (!this.isMaintenanceMode()) {
            return;
        }
        this.workflowCallbacks.entrySet().removeIf(cbE -> {
            if (!((MaintenanceWorkflowCallback)cbE.getValue()).shouldProceedWithMaintenance()) {
                this.unregisterMaintenanceTask((String)cbE.getKey());
                return true;
            }
            return false;
        });
        if (!this.workflowCallbacks.isEmpty()) {
            if (this.log.isInfoEnabled()) {
                String mntcTasksNames = String.join((CharSequence)", ", this.workflowCallbacks.keySet());
                this.log.info("Node requires maintenance, non-empty set of maintenance tasks is found: [" + mntcTasksNames + ']');
            }
            this.proceedWithMaintenance();
        } else if (this.isMaintenanceMode() && this.log.isInfoEnabled()) {
            this.log.info("All maintenance tasks are fixed, no need to enter maintenance mode. Restart the node to get it back to normal operations.");
        }
        if (this.isMaintenanceMode() && this.autoShutdown) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting a thread that will shut down the node when all active maintenance tasks are completed.");
            }
            this.startShutdownThread();
        }
    }

    private void proceedWithMaintenance() {
        for (Map.Entry<String, MaintenanceWorkflowCallback> cbE : this.workflowCallbacks.entrySet()) {
            MaintenanceAction<?> mntcAct = cbE.getValue().automaticAction();
            if (mntcAct == null) continue;
            try {
                mntcAct.execute();
            }
            catch (Throwable t2) {
                this.log.warning("Failed to execute automatic action for maintenance task: " + this.activeTasks.get(cbE.getKey()), t2);
                throw t2;
            }
        }
    }

    @Override
    @Nullable
    public MaintenanceTask activeMaintenanceTask(String maitenanceTaskName) {
        return this.activeTasks.get(maitenanceTaskName);
    }

    @Override
    public boolean isMaintenanceMode() {
        return this.maintenanceMode;
    }

    @Override
    public boolean unregisterMaintenanceTask(String maintenanceTaskName) {
        if (this.disabled) {
            return false;
        }
        boolean deleted = this.isMaintenanceMode() ? this.activeTasks.remove(maintenanceTaskName) != null : this.requestedTasks.remove(maintenanceTaskName) != null;
        try {
            this.fileStorage.deleteMaintenanceTask(maintenanceTaskName);
        }
        catch (IOException e) {
            this.log.warning("Failed to clear maintenance task with name " + maintenanceTaskName + " from file, whole file will be deleted", e);
            this.fileStorage.clear();
        }
        return deleted;
    }

    @Override
    public void registerWorkflowCallback(@NotNull String maintenanceTaskName, @NotNull MaintenanceWorkflowCallback cb) {
        if (this.disabled) {
            throw new IgniteException(DISABLED_ERR_MSG);
        }
        List<MaintenanceAction<?>> actions = cb.allActions();
        if (actions == null || actions.isEmpty()) {
            throw new IgniteException("Maintenance workflow callback should provide at least one maintenance action");
        }
        int size = actions.size();
        long distinctSize = actions.stream().map(MaintenanceAction::name).distinct().count();
        if (distinctSize < (long)size) {
            throw new IgniteException("All actions of a single workflow should have unique names: " + actions.stream().map(MaintenanceAction::name).collect(Collectors.joining(", ")));
        }
        Optional<String> wrongActionName = actions.stream().map(MaintenanceAction::name).filter(name -> !ALPHANUMERIC_UNDERSCORE.matcher((CharSequence)name).matches()).findFirst();
        if (wrongActionName.isPresent()) {
            throw new IgniteException("All actions' names should contain only alphanumeric and underscore symbols: " + wrongActionName.get());
        }
        this.workflowCallbacks.put(maintenanceTaskName, cb);
    }

    @Override
    public List<MaintenanceAction<?>> actionsForMaintenanceTask(String maintenanceTaskName) {
        if (this.disabled) {
            throw new IgniteException(DISABLED_ERR_MSG);
        }
        if (!this.activeTasks.containsKey(maintenanceTaskName)) {
            throw new IgniteException("Maintenance workflow callback for given task name not found, cannot retrieve maintenance actions for it: " + maintenanceTaskName);
        }
        return this.workflowCallbacks.get(maintenanceTaskName).allActions();
    }

    @Override
    @Nullable
    public MaintenanceTask requestedTask(String maintenanceTaskName) {
        return this.requestedTasks.get(maintenanceTaskName);
    }

    private void startShutdownThread() {
        final String igniteInstanceName = this.ctx.config().getIgniteInstanceName();
        IgniteThread t2 = new IgniteThread(new GridWorker(igniteInstanceName, "maintenance-shutdown-thread", this.log){

            @Override
            protected void body() throws InterruptedException {
                long lastLogTs = U.currentTimeMillis();
                while (true) {
                    if (MaintenanceProcessor.this.activeTasks.isEmpty() && Ignition.state(igniteInstanceName) == IgniteState.STARTED) {
                        G.stop(igniteInstanceName, false);
                        if (MaintenanceProcessor.this.mntcModeExitCode != 0) {
                            System.exit(MaintenanceProcessor.this.mntcModeExitCode);
                        }
                        return;
                    }
                    if (this.log.isInfoEnabled() && U.currentTimeMillis() - lastLogTs > 2000L) {
                        lastLogTs = U.currentTimeMillis();
                        this.log.info("Node will be shut down when all active maintenance tasks are completed [activeTasks=" + MaintenanceProcessor.this.activeTasks + "]");
                    }
                    Thread.sleep(100L);
                }
            }
        });
        t2.start();
    }
}

