/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionGroup;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionNode;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionPartition;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskResult;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopologyImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CacheDistributionTask
extends VisorMultiNodeTask<CacheDistributionTaskArg, CacheDistributionTaskResult, CacheDistributionNode> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected CacheDistributionTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        ArrayList<CacheDistributionNode> infos = new ArrayList<CacheDistributionNode>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            infos.add((CacheDistributionNode)res.getData());
        }
        return new CacheDistributionTaskResult(infos, exceptions);
    }

    @Override
    protected VisorJob<CacheDistributionTaskArg, CacheDistributionNode> job(CacheDistributionTaskArg arg) {
        return new CacheDistributionJob(arg, this.debug);
    }

    private static class CacheDistributionJob
    extends VisorJob<CacheDistributionTaskArg, CacheDistributionNode> {
        private static final long serialVersionUID = 0L;

        public CacheDistributionJob(@Nullable CacheDistributionTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public CacheDistributionNode run(CacheDistributionTaskArg arg) throws IgniteException {
            try {
                CacheDistributionNode info = new CacheDistributionNode();
                ClusterNode node = this.ignite.localNode();
                info.setNodeId(node.id());
                info.setAddresses(node.addresses().toString());
                if (arg.getUserAttributes() != null) {
                    info.setUserAttributes(new TreeMap<String, String>());
                    for (String userAttribute : arg.getUserAttributes()) {
                        info.getUserAttributes().put(userAttribute, (String)node.attributes().get(userAttribute));
                    }
                }
                info.setGroups(new ArrayList<CacheDistributionGroup>());
                HashSet<Integer> grpIds = new HashSet<Integer>();
                if (arg.getCaches() == null) {
                    Collection<CacheGroupContext> ctxs = this.ignite.context().cache().cacheGroups();
                    for (CacheGroupContext ctx : ctxs) {
                        grpIds.add(ctx.groupId());
                    }
                } else {
                    for (String cacheName : arg.getCaches()) {
                        grpIds.add(CU.cacheId(cacheName));
                    }
                }
                if (grpIds.isEmpty()) {
                    return info;
                }
                for (Integer id : grpIds) {
                    CacheDistributionGroup grp = new CacheDistributionGroup();
                    info.getGroups().add(grp);
                    grp.setGroupId(id);
                    DynamicCacheDescriptor desc = this.ignite.context().cache().cacheDescriptor(id);
                    CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(desc == null ? id.intValue() : desc.groupId());
                    grp.setGroupName(grpCtx.cacheOrGroupName());
                    grp.setPartitions(new ArrayList<CacheDistributionPartition>());
                    GridDhtPartitionTopologyImpl top = (GridDhtPartitionTopologyImpl)grpCtx.topology();
                    AffinityAssignment assignment = grpCtx.affinity().readyAffinity(top.readyTopologyVersion());
                    List<GridDhtLocalPartition> locParts = top.localPartitions();
                    for (int i = 0; i < locParts.size(); ++i) {
                        GridDhtLocalPartition part = locParts.get(i);
                        if (part == null) continue;
                        CacheDistributionPartition partDto = new CacheDistributionPartition();
                        grp.getPartitions().add(partDto);
                        int p = part.id();
                        partDto.setPartition(p);
                        partDto.setPrimary(assignment.primaryPartitions(node.id()).contains(p));
                        partDto.setState(part.state());
                        partDto.setUpdateCounter(part.updateCounter());
                        partDto.setSize(desc == null ? part.dataStore().fullSize() : part.dataStore().cacheSize(id));
                    }
                }
                return info;
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(CacheDistributionJob.class, this);
        }
    }
}

