/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.jetbrains.annotations.Nullable;

public abstract class GridClientUtils {
    public static void closeQuiet(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static <T> GridClientPredicate<T> contains(final Collection<T> c) {
        return new GridClientPredicate<T>(){

            @Override
            public boolean apply(T t2) {
                return c != null && !c.isEmpty() && c.contains(t2);
            }
        };
    }

    @Nullable
    public static <T> T first(@Nullable Iterable<? extends T> c) {
        if (c == null) {
            return null;
        }
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <T> Collection<T> applyFilter(Iterable<? extends T> elements, GridClientPredicate<? super T> ... filters) {
        assert (filters != null);
        LinkedList<T> res = new LinkedList<T>();
        for (T e : elements) {
            boolean add = true;
            for (GridClientPredicate<T> gridClientPredicate : filters) {
                if (gridClientPredicate == null || gridClientPredicate.apply(e)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            res.add(e);
        }
        return res;
    }

    public static boolean restAvailable(GridClientNode node, GridClientProtocol p) {
        return !node.availableAddresses(p, false).isEmpty();
    }

    public static void shutdownNow(Class<?> owner, ExecutorService exec, Logger log) {
        if (exec != null) {
            List<Runnable> tasks = exec.shutdownNow();
            if (!tasks.isEmpty()) {
                log.warning("Runnable tasks outlived thread pool executor service [owner=" + GridClientUtils.getSimpleName(owner) + ", tasks=" + tasks + ']');
            }
            try {
                exec.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                log.warning("Got interrupted while waiting for executor service to stop.");
                exec.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String getSimpleName(Class<?> cls) {
        return cls.getSimpleName().isEmpty() ? cls.getName() : cls.getSimpleName();
    }

    public static int safeAbs(int i) {
        return (i = Math.abs(i)) < 0 ? 0 : i;
    }

    public static boolean nodeSupports(UUID nodeId, GridClient client, IgniteFeatures fut) throws GridClientException {
        return nodeId == null && GridClientUtils.allNodesSupport(client, fut) || nodeId != null && client.compute().node(nodeId).supports(fut);
    }

    public static boolean allNodesSupport(GridClient client, IgniteFeatures feature) throws GridClientException {
        return client.compute().nodes().stream().allMatch(node -> node.supports(feature));
    }
}

