/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.InvalidUserCommandCheckedException;
import org.apache.ignite.internal.InvalidUserCommandException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.discovery.DiscoverySpi;

public class UserCommandExceptions {
    public static IgniteException invalidUserCommandException(String message, DiscoverySpi discoverySpi) {
        if (IgniteFeatures.allNodesSupport(null, discoverySpi, IgniteFeatures.HAS_INVALID_USER_COMMAND_EXCEPTION)) {
            return new InvalidUserCommandException(message);
        }
        return new IgniteException(message);
    }

    public static IgniteException invalidUserCommandException(String message, GridKernalContext ctx) {
        return UserCommandExceptions.invalidUserCommandException(message, ctx.config().getDiscoverySpi());
    }

    public static IgniteCheckedException invalidUserCommandCheckedException(String message, DiscoverySpi discoverySpi) {
        if (IgniteFeatures.allNodesSupport(null, discoverySpi, IgniteFeatures.HAS_INVALID_USER_COMMAND_EXCEPTION)) {
            return new InvalidUserCommandCheckedException(message);
        }
        return new IgniteCheckedException(message);
    }

    public static IgniteCheckedException invalidUserCommandCheckedException(String message, GridKernalContext ctx) {
        return UserCommandExceptions.invalidUserCommandCheckedException(message, ctx.config().getDiscoverySpi());
    }

    public static boolean causedByUserCommandException(Throwable ex) {
        return X.hasCause(ex, InvalidUserCommandException.class) || X.hasCause(ex, InvalidUserCommandCheckedException.class);
    }
}

