/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.mxbean.QueryMXBean;
import org.apache.ignite.resources.IgniteInstanceResource;

public class QueryMXBeanImpl
implements QueryMXBean {
    public static final String EXPECTED_GLOBAL_QRY_ID_FORMAT = "Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'";
    private final GridKernalContext ctx;
    private final IgniteLogger log;

    public QueryMXBeanImpl(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(QueryMXBeanImpl.class);
    }

    @Override
    public void cancelContinuous(String originNodeId, String routineId) {
        A.notNullOrEmpty(originNodeId, "originNodeId");
        A.notNullOrEmpty(routineId, "routineId");
        if (this.log.isInfoEnabled()) {
            this.log.info("Killing continuous query[routineId=" + routineId + ", originNodeId=" + originNodeId + ']');
        }
        this.cancelContinuous(UUID.fromString(originNodeId), UUID.fromString(routineId));
    }

    @Override
    public void cancelSQL(String id) {
        A.notNull(id, "id");
        if (this.log.isInfoEnabled()) {
            this.log.info("Killing sql query[id=" + id + ']');
        }
        try {
            T2<UUID, Long> ids = SqlKillQueryCommand.parseGlobalQueryId(id);
            if (ids == null) {
                throw new IllegalArgumentException("Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
            }
            this.cancelSQL((UUID)ids.get1(), (Long)ids.get2());
        }
        catch (IgniteException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancelSQL(UUID originNodeId, long qryId) {
        this.ctx.grid().compute(this.ctx.grid().cluster().forNodeId(originNodeId, new UUID[0])).broadcast(new CancelSQLOnInitiator(), qryId);
    }

    public void cancelContinuous(UUID originNodeId, UUID routineId) {
        this.ctx.grid().compute(this.ctx.grid().cluster().forNodeId(originNodeId, new UUID[0])).broadcast(new CancelContinuousOnInitiator(), routineId);
    }

    private static class CancelContinuousOnInitiator
    implements IgniteClosure<UUID, Void> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        private CancelContinuousOnInitiator() {
        }

        @Override
        public Void apply(UUID routineId) {
            IgniteInternalFuture<?> fut = this.ignite.context().continuous().stopRoutine(routineId);
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            return null;
        }
    }

    private static class CancelSQLOnInitiator
    implements IgniteClosure<Long, Void> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        private CancelSQLOnInitiator() {
        }

        @Override
        public Void apply(Long qryId) {
            this.ignite.context().query().cancelQueries(Collections.singleton(qryId));
            return null;
        }
    }
}

