/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.CheckpointWriteOrder;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.EncryptionConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.configuration.WarmUpConfiguration;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mem.MemoryAllocator;
import org.jetbrains.annotations.Nullable;

public class DataStorageConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final long UNLIMITED_WAL_ARCHIVE = -1L;
    public static final long DFLT_DATA_REGION_INITIAL_SIZE = 0x10000000L;
    private static final double DFLT_DATA_REGION_FRACTION = 0.2;
    public static final long DFLT_DATA_REGION_MAX_SIZE = Math.max((long)(0.2 * (double)U.getTotalMemoryAvailable()), 0x10000000L);
    private static final long DFLT_SYS_REG_INIT_SIZE = 0x2800000L;
    private static final long DFLT_SYS_REG_MAX_SIZE = 0x6400000L;
    public static final int DFLT_PAGE_SIZE = 4096;
    public static final int MAX_PAGE_SIZE = 16384;
    public static final int MIN_PAGE_SIZE = 1024;
    public static final String DFLT_DATA_REG_DEFAULT_NAME = "default";
    public static final int DFLT_CHECKPOINT_FREQ = 180000;
    public static final int DFLT_LOCK_WAIT_TIME = 10000;
    public static final boolean DFLT_METRICS_ENABLED = true;
    public static final int DFLT_SUB_INTERVALS = 5;
    public static final int DFLT_RATE_TIME_INTERVAL_MILLIS = 60000;
    public static final int DFLT_CHECKPOINT_THREADS = 4;
    public static final CheckpointWriteOrder DFLT_CHECKPOINT_WRITE_ORDER = CheckpointWriteOrder.SEQUENTIAL;
    public static final int DFLT_WAL_HISTORY_SIZE = 20;
    public static final long DFLT_WAL_ARCHIVE_MAX_SIZE = 0x40000000L;
    public static final int DFLT_WAL_SEGMENTS = 10;
    public static final int DFLT_WAL_SEGMENT_SIZE = 0x4000000;
    public static final WALMode DFLT_WAL_MODE = WALMode.LOG_ONLY;
    public static final int DFLT_TLB_SIZE = 131072;
    public static final int DFLT_WAL_BUFF_SIZE = 0x1000000;
    public static final int DFLT_WAL_FLUSH_FREQ = 2000;
    public static final int DFLT_WAL_FSYNC_DELAY = 1000;
    public static final int DFLT_WAL_RECORD_ITERATOR_BUFFER_SIZE = 0x4000000;
    public static final boolean DFLT_WAL_ALWAYS_WRITE_FULL_PAGES = false;
    public static final String DFLT_WAL_PATH = "db/wal";
    public static final String DFLT_WAL_ARCHIVE_PATH = "db/wal/archive";
    public static final String DFLT_BINARY_METADATA_PATH = "db/binary_meta";
    public static final String DFLT_MARSHALLER_PATH = "db/marshaller";
    public static final boolean DFLT_WRITE_THROTTLING_ENABLED = false;
    public static final boolean DFLT_WAL_COMPACTION_ENABLED = false;
    public static final int DFLT_WAL_COMPACTION_LEVEL = 1;
    public static final int DFLT_DEFRAGMENTATION_THREAD_POOL_SIZE = 4;
    public static final DiskPageCompression DFLT_WAL_PAGE_COMPRESSION = DiskPageCompression.DISABLED;
    public static final boolean DFLT_USE_ASYNC_FILE_IO_FACTORY = true;
    public static final long HALF_MAX_WAL_ARCHIVE_SIZE = -1L;
    private long sysRegionInitSize = 0x2800000L;
    private long sysRegionMaxSize = 0x6400000L;
    private int pageSize = IgniteSystemProperties.getInteger("IGNITE_DEFAULT_DATA_STORAGE_PAGE_SIZE", 0);
    private int concLvl;
    private DataRegionConfiguration dfltDataRegConf = new DataRegionConfiguration();
    @GridToStringInclude
    private DataRegionConfiguration[] dataRegions;
    private String storagePath;
    private long checkpointFreq = 180000L;
    private long lockWaitTime = 10000L;
    private int checkpointThreads = 4;
    private CheckpointWriteOrder checkpointWriteOrder = DFLT_CHECKPOINT_WRITE_ORDER;
    private int walHistSize = 20;
    private long maxWalArchiveSize = 0x40000000L;
    private int walSegments = 10;
    private int walSegmentSize = 0x4000000;
    private String walPath = "db/wal";
    private String walArchivePath = "db/wal/archive";
    private boolean metricsEnabled = true;
    private WALMode walMode = DFLT_WAL_MODE;
    private int walTlbSize = 131072;
    private int walBuffSize;
    private long walFlushFreq = 2000L;
    private long walFsyncDelay = 1000L;
    private int walRecordIterBuffSize = 0x4000000;
    private boolean alwaysWriteFullPages = false;
    private FileIOFactory fileIOFactory = IgniteSystemProperties.getBoolean("IGNITE_USE_ASYNC_FILE_IO_FACTORY", true) ? new AsyncFileIOFactory() : new RandomAccessFileIOFactory();
    private int metricsSubIntervalCnt = 5;
    private long metricsRateTimeInterval = 60000L;
    private long walAutoArchiveAfterInactivity = -1L;
    private boolean writeThrottlingEnabled = false;
    private boolean walCompactionEnabled = false;
    private int walCompactionLevel = 1;
    private Long checkpointReadLockTimeout;
    private DiskPageCompression walPageCompression = DFLT_WAL_PAGE_COMPRESSION;
    private Integer walPageCompressionLevel;
    @Nullable
    private WarmUpConfiguration dfltWarmUpCfg;
    private EncryptionConfiguration encCfg = new EncryptionConfiguration();
    private int defragmentationThreadPoolSize = 4;
    private long minWalArchiveSize = -1L;
    @Nullable
    private MemoryAllocator memoryAllocator = null;

    public long getSystemRegionInitialSize() {
        return this.sysRegionInitSize;
    }

    public DataStorageConfiguration setSystemRegionInitialSize(long sysRegionInitSize) {
        A.ensure(sysRegionInitSize > 0L, "System region initial size can not be less zero.");
        this.sysRegionInitSize = sysRegionInitSize;
        return this;
    }

    public long getSystemRegionMaxSize() {
        return this.sysRegionMaxSize;
    }

    public DataStorageConfiguration setSystemRegionMaxSize(long sysRegionMaxSize) {
        A.ensure(sysRegionMaxSize > 0L, "System region max size can not be less zero.");
        this.sysRegionMaxSize = sysRegionMaxSize;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public DataStorageConfiguration setPageSize(int pageSize) {
        if (pageSize != 0) {
            A.ensure(pageSize >= 1024 && pageSize <= 16384, "Page size must be between 1kB and 16kB.");
            A.ensure(U.isPow2(pageSize), "Page size must be a power of 2.");
        }
        this.pageSize = pageSize;
        return this;
    }

    public DataRegionConfiguration[] getDataRegionConfigurations() {
        return this.dataRegions;
    }

    public DataStorageConfiguration setDataRegionConfigurations(DataRegionConfiguration ... dataRegionConfigurations) {
        this.dataRegions = dataRegionConfigurations;
        return this;
    }

    public int getConcurrencyLevel() {
        return this.concLvl <= 0 ? Runtime.getRuntime().availableProcessors() : this.concLvl;
    }

    public DataStorageConfiguration setConcurrencyLevel(int concLvl) {
        this.concLvl = concLvl;
        return this;
    }

    public DataRegionConfiguration getDefaultDataRegionConfiguration() {
        return this.dfltDataRegConf;
    }

    public DataStorageConfiguration setDefaultDataRegionConfiguration(DataRegionConfiguration dfltDataRegConf) {
        this.dfltDataRegConf = dfltDataRegConf;
        return this;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public DataStorageConfiguration setStoragePath(String persistenceStorePath) {
        this.storagePath = persistenceStorePath;
        return this;
    }

    public long getCheckpointFrequency() {
        return this.checkpointFreq <= 0L ? 180000L : this.checkpointFreq;
    }

    public DataStorageConfiguration setCheckpointFrequency(long checkpointFreq) {
        this.checkpointFreq = checkpointFreq;
        return this;
    }

    public int getCheckpointThreads() {
        return this.checkpointThreads;
    }

    public DataStorageConfiguration setCheckpointThreads(int checkpointThreads) {
        this.checkpointThreads = checkpointThreads;
        return this;
    }

    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    public DataStorageConfiguration setLockWaitTime(long lockWaitTime) {
        this.lockWaitTime = lockWaitTime;
        return this;
    }

    @Deprecated
    public int getWalHistorySize() {
        return this.walHistSize <= 0 ? 20 : this.walHistSize;
    }

    @Deprecated
    public DataStorageConfiguration setWalHistorySize(int walHistSize) {
        this.walHistSize = walHistSize;
        return this;
    }

    public boolean isWalHistorySizeParameterUsed() {
        return this.getWalHistorySize() != 20 && this.getWalHistorySize() != Integer.MAX_VALUE;
    }

    public long getMaxWalArchiveSize() {
        if (this.maxWalArchiveSize == -1L) {
            return -1L;
        }
        return this.maxWalArchiveSize <= 0L ? 0x40000000L : this.maxWalArchiveSize;
    }

    public DataStorageConfiguration setMaxWalArchiveSize(long walArchiveMaxSize) {
        if (walArchiveMaxSize != 0L && walArchiveMaxSize != -1L) {
            A.ensure(walArchiveMaxSize > 0L, "Max WAL archive size can be only greater than 0 or must be equal to -1 (to be unlimited)");
        }
        this.maxWalArchiveSize = walArchiveMaxSize;
        return this;
    }

    public int getWalSegments() {
        return this.walSegments <= 0 ? 10 : this.walSegments;
    }

    public DataStorageConfiguration setWalSegments(int walSegments) {
        if (walSegments != 0) {
            A.ensure(walSegments > 1, "Number of WAL segments must be greater than 1.");
        }
        this.walSegments = walSegments;
        return this;
    }

    public int getWalSegmentSize() {
        return this.walSegmentSize == 0 ? 0x4000000 : this.walSegmentSize;
    }

    public DataStorageConfiguration setWalSegmentSize(int walSegmentSize) {
        if (walSegmentSize != 0) {
            A.ensure(walSegmentSize >= 524288, "WAL segment size must be between 512Kb and 2Gb.");
        }
        this.walSegmentSize = walSegmentSize;
        return this;
    }

    public String getWalPath() {
        return this.walPath;
    }

    public DataStorageConfiguration setWalPath(String walStorePath) {
        this.walPath = walStorePath;
        return this;
    }

    public String getWalArchivePath() {
        return this.walArchivePath;
    }

    public DataStorageConfiguration setWalArchivePath(String walArchivePath) {
        this.walArchivePath = walArchivePath;
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public DataStorageConfiguration setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
        return this;
    }

    public boolean isWriteThrottlingEnabled() {
        return this.writeThrottlingEnabled;
    }

    public DataStorageConfiguration setWriteThrottlingEnabled(boolean writeThrottlingEnabled) {
        this.writeThrottlingEnabled = writeThrottlingEnabled;
        return this;
    }

    @Deprecated
    public long getMetricsRateTimeInterval() {
        return this.metricsRateTimeInterval;
    }

    @Deprecated
    public DataStorageConfiguration setMetricsRateTimeInterval(long metricsRateTimeInterval) {
        this.metricsRateTimeInterval = metricsRateTimeInterval;
        return this;
    }

    @Deprecated
    public int getMetricsSubIntervalCount() {
        return this.metricsSubIntervalCnt;
    }

    @Deprecated
    public DataStorageConfiguration setMetricsSubIntervalCount(int metricsSubIntervalCnt) {
        this.metricsSubIntervalCnt = metricsSubIntervalCnt;
        return this;
    }

    public WALMode getWalMode() {
        return this.walMode == null ? DFLT_WAL_MODE : this.walMode;
    }

    public DataStorageConfiguration setWalMode(WALMode walMode) {
        if (walMode == WALMode.DEFAULT) {
            walMode = WALMode.FSYNC;
        }
        this.walMode = walMode;
        return this;
    }

    public int getWalThreadLocalBufferSize() {
        return this.walTlbSize <= 0 ? 131072 : this.walTlbSize;
    }

    public DataStorageConfiguration setWalThreadLocalBufferSize(int walTlbSize) {
        this.walTlbSize = walTlbSize;
        return this;
    }

    public int getWalBufferSize() {
        return this.walBuffSize <= 0 ? this.getWalSegmentSize() / 4 : this.walBuffSize;
    }

    public DataStorageConfiguration setWalBufferSize(int walBuffSize) {
        this.walBuffSize = walBuffSize;
        return this;
    }

    public long getWalFlushFrequency() {
        return this.walFlushFreq;
    }

    public DataStorageConfiguration setWalFlushFrequency(long walFlushFreq) {
        this.walFlushFreq = walFlushFreq;
        return this;
    }

    public long getWalFsyncDelayNanos() {
        return this.walFsyncDelay <= 0L ? 1000L : this.walFsyncDelay;
    }

    public DataStorageConfiguration setWalFsyncDelayNanos(long walFsyncDelayNanos) {
        this.walFsyncDelay = walFsyncDelayNanos;
        return this;
    }

    public int getWalRecordIteratorBufferSize() {
        return this.walRecordIterBuffSize <= 0 ? 0x4000000 : this.walRecordIterBuffSize;
    }

    public DataStorageConfiguration setWalRecordIteratorBufferSize(int walRecordIterBuffSize) {
        this.walRecordIterBuffSize = walRecordIterBuffSize;
        return this;
    }

    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    public DataStorageConfiguration setAlwaysWriteFullPages(boolean alwaysWriteFullPages) {
        this.alwaysWriteFullPages = alwaysWriteFullPages;
        return this;
    }

    public FileIOFactory getFileIOFactory() {
        return this.fileIOFactory;
    }

    public DataStorageConfiguration setFileIOFactory(FileIOFactory fileIOFactory) {
        this.fileIOFactory = fileIOFactory;
        return this;
    }

    public DataStorageConfiguration setWalAutoArchiveAfterInactivity(long walAutoArchiveAfterInactivity) {
        this.walAutoArchiveAfterInactivity = walAutoArchiveAfterInactivity;
        return this;
    }

    public long getWalAutoArchiveAfterInactivity() {
        return this.walAutoArchiveAfterInactivity;
    }

    public CheckpointWriteOrder getCheckpointWriteOrder() {
        return this.checkpointWriteOrder;
    }

    public DataStorageConfiguration setCheckpointWriteOrder(CheckpointWriteOrder checkpointWriteOrder) {
        this.checkpointWriteOrder = checkpointWriteOrder;
        return this;
    }

    public boolean isWalCompactionEnabled() {
        return this.walCompactionEnabled;
    }

    public DataStorageConfiguration setWalCompactionEnabled(boolean walCompactionEnabled) {
        this.walCompactionEnabled = walCompactionEnabled;
        return this;
    }

    public int getWalCompactionLevel() {
        return this.walCompactionLevel;
    }

    public void setWalCompactionLevel(int walCompactionLevel) {
        this.walCompactionLevel = walCompactionLevel;
    }

    public Long getCheckpointReadLockTimeout() {
        return this.checkpointReadLockTimeout;
    }

    public DataStorageConfiguration setCheckpointReadLockTimeout(long checkpointReadLockTimeout) {
        this.checkpointReadLockTimeout = checkpointReadLockTimeout;
        return this;
    }

    public DiskPageCompression getWalPageCompression() {
        return this.walPageCompression == null ? DFLT_WAL_PAGE_COMPRESSION : this.walPageCompression;
    }

    public DataStorageConfiguration setWalPageCompression(DiskPageCompression walPageCompression) {
        this.walPageCompression = walPageCompression;
        return this;
    }

    public Integer getWalPageCompressionLevel() {
        return this.walPageCompressionLevel;
    }

    public DataStorageConfiguration setWalPageCompressionLevel(Integer walPageCompressionLevel) {
        this.walPageCompressionLevel = walPageCompressionLevel;
        return this;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encCfg;
    }

    public DataStorageConfiguration setEncryptionConfiguration(EncryptionConfiguration encCfg) {
        this.encCfg = encCfg;
        return this;
    }

    public DataStorageConfiguration setDefaultWarmUpConfiguration(@Nullable WarmUpConfiguration dfltWarmUpCfg) {
        this.dfltWarmUpCfg = dfltWarmUpCfg;
        return this;
    }

    @Nullable
    public WarmUpConfiguration getDefaultWarmUpConfiguration() {
        return this.dfltWarmUpCfg;
    }

    public DataStorageConfiguration setDefragmentationThreadPoolSize(int defragmentationThreadPoolSize) {
        A.ensure(defragmentationThreadPoolSize > 1, "Defragmentation thread pool size must be greater or equal to 1.");
        this.defragmentationThreadPoolSize = defragmentationThreadPoolSize;
        return this;
    }

    public int getDefragmentationThreadPoolSize() {
        return this.defragmentationThreadPoolSize;
    }

    public long getMinWalArchiveSize() {
        return this.minWalArchiveSize;
    }

    public DataStorageConfiguration setMinWalArchiveSize(long walArchiveMinSize) {
        if (walArchiveMinSize != -1L) {
            A.ensure(walArchiveMinSize > 0L, "Min WAL archive size can be only greater than 0 or must be equal to -1 (to be half of max WAL archive size)");
        }
        this.minWalArchiveSize = walArchiveMinSize;
        return this;
    }

    @Nullable
    public MemoryAllocator getMemoryAllocator() {
        return this.memoryAllocator;
    }

    public DataStorageConfiguration setMemoryAllocator(MemoryAllocator allocator) {
        this.memoryAllocator = allocator;
        return this;
    }

    public String toString() {
        return S.toString(DataStorageConfiguration.class, this);
    }
}

