/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.sorted;

import java.util.Comparator;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicyFactory;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.sorted.SortedEvictionPolicy;

public class SortedEvictionPolicyFactory<K, V>
extends AbstractEvictionPolicyFactory<SortedEvictionPolicy<K, V>> {
    private static final long serialVersionUID = 0L;
    private Comparator<EvictableEntry<K, V>> comp;

    public SortedEvictionPolicyFactory() {
    }

    public SortedEvictionPolicyFactory(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public SortedEvictionPolicyFactory(int maxSize, int batchSize, long maxMemSize) {
        this.setMaxSize(maxSize);
        this.setBatchSize(batchSize);
        this.setMaxMemorySize(maxMemSize);
    }

    public Comparator<EvictableEntry<K, V>> getComp() {
        return this.comp;
    }

    public void setComp(Comparator<EvictableEntry<K, V>> comp) {
        this.comp = comp;
    }

    @Override
    public SortedEvictionPolicy<K, V> create() {
        SortedEvictionPolicy<K, V> policy = new SortedEvictionPolicy<K, V>(this.comp);
        policy.setBatchSize(this.getBatchSize());
        policy.setMaxMemorySize(this.getMaxMemorySize());
        policy.setMaxSize(this.getMaxSize());
        return policy;
    }
}

