/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.binary;

import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.util.typedef.internal.A;

public class BinaryBasicIdMapper
implements BinaryIdMapper {
    public static final boolean DFLT_LOWER_CASE = true;
    private static final char MAX_LOWER_CASE_CHAR = '~';
    private static final char[] LOWER_CASE_CHARS = new char[127];
    private boolean isLowerCase = true;

    public BinaryBasicIdMapper() {
    }

    public BinaryBasicIdMapper(boolean isLowerCase) {
        this.isLowerCase = isLowerCase;
    }

    @Override
    public int typeId(String typeName) {
        int id;
        A.notNull(typeName, "typeName");
        int n = id = this.isLowerCase ? BinaryBasicIdMapper.lowerCaseHashCode(typeName) : typeName.hashCode();
        if (id != 0) {
            return id;
        }
        throw new BinaryObjectException("Binary ID mapper resolved type ID to zero (either change type's name or use custom ID mapper) [name=" + typeName + ", isLowerCase=" + this.isLowerCase + "]");
    }

    @Override
    public int fieldId(int typeId, String fieldName) {
        int id;
        A.notNull(fieldName, "fieldName");
        int n = id = this.isLowerCase ? BinaryBasicIdMapper.lowerCaseHashCode(fieldName) : fieldName.hashCode();
        if (id != 0) {
            return id;
        }
        throw new BinaryObjectException("Binary ID mapper resolved field ID to zero (either change filed's name or use custom ID mapper) [name=" + fieldName + ", isLowerCase=" + this.isLowerCase + "]");
    }

    public boolean isLowerCase() {
        return this.isLowerCase;
    }

    public BinaryBasicIdMapper setLowerCase(boolean isLowerCase) {
        this.isLowerCase = isLowerCase;
        return this;
    }

    private static int lowerCaseHashCode(String str) {
        int len = str.length();
        int h2 = 0;
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i);
            c = c <= 126 ? LOWER_CASE_CHARS[c] : Character.toLowerCase(c);
            h2 = 31 * h2 + c;
        }
        return h2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryBasicIdMapper)) {
            return false;
        }
        BinaryBasicIdMapper mapper = (BinaryBasicIdMapper)o;
        return this.isLowerCase == mapper.isLowerCase;
    }

    public int hashCode() {
        return this.isLowerCase ? 1 : 0;
    }

    public String toString() {
        return "BinaryBaseIdMapper [isLowerCase=" + this.isLowerCase + ']';
    }

    static {
        for (char c = '\u0000'; c <= '~'; c = (char)(c + '\u0001')) {
            BinaryBasicIdMapper.LOWER_CASE_CHARS[c] = Character.toLowerCase(c);
        }
    }
}

