/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store;

import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public class KeyRecord {
    private final byte[] key;
    private final Instant issuedAt;
    private final Instant expirationTime;

    public KeyRecord(byte[] key, Instant issuedAt, Instant expirationTime) {
        this.key = key;
        this.issuedAt = issuedAt;
        this.expirationTime = expirationTime;
    }

    public byte[] key() {
        return this.key;
    }

    public Instant issuedAt() {
        return this.issuedAt;
    }

    public Instant expirationTime() {
        return this.expirationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyRecord keyRecord = (KeyRecord)o;
        return Arrays.equals(this.key, keyRecord.key) && Objects.equals(this.issuedAt.toEpochMilli(), keyRecord.issuedAt.toEpochMilli()) && Objects.equals(this.expirationTime.toEpochMilli(), keyRecord.expirationTime.toEpochMilli());
    }

    public int hashCode() {
        int result = Objects.hash(this.issuedAt, this.expirationTime);
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }
}

