/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class KeyMetadataRecord {
    private final int id;
    private final Instant issuedAt;
    private final Instant expirationTime;

    public KeyMetadataRecord(int id, Instant issuedAt, Instant expirationTime) {
        this.id = id;
        this.issuedAt = issuedAt.truncatedTo(ChronoUnit.MILLIS);
        this.expirationTime = expirationTime.truncatedTo(ChronoUnit.MILLIS);
    }

    public int id() {
        return this.id;
    }

    public Instant issuedAt() {
        return this.issuedAt;
    }

    public Instant expirationTime() {
        return this.expirationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyMetadataRecord that = (KeyMetadataRecord)o;
        return this.id == that.id && Objects.equals(this.issuedAt, that.issuedAt) && Objects.equals(this.expirationTime, that.expirationTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.issuedAt, this.expirationTime);
    }
}

