/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key;

import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.security.key.KeyConverter;
import org.gridgain.internal.security.key.PublicKeyChain;
import org.gridgain.internal.security.key.store.PublicKeyChainRecord;
import org.gridgain.internal.security.key.store.serde.KeyChainRecordSerDe;
import org.gridgain.internal.security.key.store.serde.MetastoreKeySerDe;
import org.jetbrains.annotations.Nullable;

class PublicKeyChainCache<K extends PublicKey>
implements WatchListener {
    private final KeyConverter<?, K> keyConverter;
    private final Map<String, PublicKeyChain<K>> nodeToPublicKey = new ConcurrentHashMap<String, PublicKeyChain<K>>();

    PublicKeyChainCache(KeyConverter<?, K> keyConverter) {
        this.keyConverter = keyConverter;
    }

    @Nullable
    PublicKeyChain<K> get(String nodeName) {
        return this.nodeToPublicKey.get(nodeName);
    }

    boolean put(String nodeName, PublicKeyChain<K> newChain) {
        PublicKeyChain computed = this.nodeToPublicKey.compute(nodeName, (k, currentChain) -> {
            if (currentChain == null) {
                return newChain;
            }
            if (newChain.currentKey().metadata().issuedAt().isAfter(currentChain.currentKey().metadata().issuedAt())) {
                return currentChain.merge(newChain.currentKey());
            }
            return currentChain;
        });
        return computed.currentKey() == newChain.currentKey();
    }

    public CompletableFuture<Void> onUpdate(WatchEvent event) {
        Entry newEntry = event.entryEvent().newEntry();
        String nodeName = MetastoreKeySerDe.deserialize(newEntry.key());
        if (newEntry.empty() || newEntry.tombstone()) {
            this.nodeToPublicKey.remove(nodeName);
        } else {
            this.updateRecord(nodeName, KeyChainRecordSerDe.deserialize(newEntry.value()));
        }
        return CompletableFutures.nullCompletedFuture();
    }

    void updateRecord(String nodeName, PublicKeyChainRecord record) {
        PublicKeyChain<K> publicKeyChain = this.keyConverter.publicKeyChainFromRecord(record);
        this.nodeToPublicKey.put(nodeName, publicKeyChain);
    }
}

