/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.gridgain.internal.security.key.IgnitePrivateKey;
import org.gridgain.internal.security.key.IgnitePublicKey;
import org.gridgain.internal.security.key.KeyDecoder;
import org.gridgain.internal.security.key.KeyMetadata;
import org.gridgain.internal.security.key.PublicKeyChain;
import org.gridgain.internal.security.key.store.KeyMetadataRecord;
import org.gridgain.internal.security.key.store.PrivateKeyRecord;
import org.gridgain.internal.security.key.store.PublicKeyChainRecord;
import org.gridgain.internal.security.key.store.PublicKeyRecord;

class KeyConverter<S extends PrivateKey, P extends PublicKey> {
    private final KeyDecoder<S, P> decoder;

    KeyConverter(KeyDecoder<S, P> decoder) {
        this.decoder = decoder;
    }

    IgnitePrivateKey<S> privateKeyFromRecord(PrivateKeyRecord record) {
        S s = this.decoder.decodePrivateKey(record.keyBytes());
        return new IgnitePrivateKey<S>(s, KeyConverter.fromMetadataRecord(record.metadata()));
    }

    PublicKeyChain<P> publicKeyChainFromRecord(PublicKeyChainRecord record) {
        IgnitePublicKey<P> key = this.publicKeyFromRecord(record.keyRecord());
        PublicKeyRecord prevKeyRecord = record.prevKeyRecord();
        IgnitePublicKey<P> prevKey = prevKeyRecord != null ? this.publicKeyFromRecord(prevKeyRecord) : null;
        return new PublicKeyChain<P>(key, prevKey);
    }

    IgnitePublicKey<P> publicKeyFromRecord(PublicKeyRecord record) {
        P p = this.decoder.decodePublicKey(record.keyBytes());
        return new IgnitePublicKey<P>(p, KeyConverter.fromMetadataRecord(record.metadata()));
    }

    PublicKeyRecord publicKeyRecordFromKey(IgnitePublicKey<P> key) {
        return new PublicKeyRecord(key.key().getEncoded(), KeyConverter.toMetadataRecord(key.metadata()));
    }

    PrivateKeyRecord privateKeyRecordFromKey(IgnitePrivateKey<S> key) {
        return new PrivateKeyRecord(key.key().getEncoded(), KeyConverter.toMetadataRecord(key.metadata()));
    }

    private static KeyMetadataRecord toMetadataRecord(KeyMetadata metadata) {
        return new KeyMetadataRecord(metadata.id(), metadata.issuedAt(), metadata.expirationTime());
    }

    private static KeyMetadata fromMetadataRecord(KeyMetadataRecord metadataRecord) {
        return new KeyMetadata(metadataRecord.id(), metadataRecord.issuedAt(), metadataRecord.expirationTime());
    }
}

